/*	v_size.c- Change the Viewport Size */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_size( viewport *v, unsigned nrows, unsigned ncols )
{
    /* Change the viewport size. The viewport must be closed
     * (not just deactivated) to change its size. False is
     * returned and nothing happens if the viewport isn't
     * closed, true otherwise.
     */

    if( v->magic != VMAGIC  ||  !v->closed )
        return 0;

    if( v->savebuf )            /* A differently sized save buffer is   */
    {                           /* required for the new size. Will      */
        VFREE( v->savebuf );    /* be allocated by v_open.              */
        v->savebuf = NULL;
    }
    if( v->old_image )
    {
        VFREE( v->old_image );
        v->old_image = NULL;
    }
    v->nrows = nrows;           /* Set up the new size. */
    v->ncols = ncols;

    return 1;
}
