/* ICONS.c --- A sample program drawing icons and moving them.        */

#include <stdio.h>
#include <stdlib.h>		

typedef char Icon[160];  /* Array of 160 bytes forms an icon      */

/* Display icon at location x,y from system RAM into video RAM with write mode 0 */
extern void near Display_Icon(int x, int y, void far *Data);
/* Copy icon from one place in video RAM to another location with write mode 1 */
extern void near Copy_Icon(int OrigX, int OrigY, int X, int Y);
extern void near Video_Mode(int Mode) ; 
extern void near Set_Pixel(int x, int y, int Color); /* Set a pixel to color */

Icon Icon1 = {
               0x03,0x00,0x00,0x00,0x00, 0xF8,0x00,0x00,0x00,0x00,
               0x07,0x00,0x03,0x03,0x03, 0xFC,0x00,0xF8,0xF8,0xF8,
               0x0F,0x00,0x07,0x07,0x07, 0xF8,0x70,0x70,0x70,0x80,
               0x0F,0x00,0x06,0x06,0x07, 0xF8,0xF0,0xD0,0xD0,0x40,
               0x0F,0x00,0x06,0x06,0x07, 0xFC,0xF8,0xF8,0xF8,0x00,
               0x0F,0x01,0x05,0x05,0x06, 0xF8,0xE0,0xE0,0xE0,0x10,
               0x0F,0x01,0x05,0x05,0x06, 0xF8,0x70,0x70,0x50,0xB0,
               0x0F,0x01,0x01,0x01,0x00, 0xFC,0xB8,0xB8,0xB8,0x40,
               0x3F,0x00,0x00,0x0F,0x02, 0xFE,0x00,0x00,0xCC,0x0C,
               0x7F,0x00,0x00,0x3F,0x21, 0xFE,0x00,0x00,0xFC,0x0C,
               0x7F,0x00,0x00,0x33,0x30, 0xFC,0x00,0x00,0xF0,0xC0,
               0x3F,0x00,0x00,0x03,0x00, 0xFC,0x00,0x00,0xC0,0x00,
               0x3F,0x18,0x18,0x1B,0x1B, 0xFE,0x04,0x04,0xF4,0x04,
               0x7F,0x30,0x30,0x3F,0x30, 0xFE,0x0C,0x0C,0xFC,0xCC,
               0x7F,0x20,0x20,0x27,0x20, 0xFC,0x18,0x18,0x18,0x18,
               0x27,0x00,0x00,0x00,0x00, 0x18,0x00,0x00,0x00,0x00 
              };
void delay(int count);

void main ()
{
	int i,j;                           /* Loop variables                        */

	Video_Mode ( 0x0d );            /* Step 1 - Set video mode to 320x200x16    */
                                    /* Sets up 2 wide by 4 high memory          */
	for (j=0; j<=15; j++)          /* Step 2 - Manually drawn the background    */
		for (i=0; i<=15; i++)      /*    icon using the Set_Pixel function      */
			if ((i+j & 1)==1)      /* Alternate pixels lt. and dk. blue         */
				Set_Pixel(i,j,1);  /* This generates the background             */
			else Set_Pixel(i,j,9); /* pattern which you can change.             */
                                    
 /* Step 3 */                       
	for (j=0; j<13; j++)             /* Step 3 Copy the icon to fill screen     */
		for (i=0; i<=19; i++)        /*   12.5 vertical is actual needed,       */
			Copy_Icon(0,0,i*2,j*16); /*   the extra byte will be offscreen.     */

	Display_Icon(2, 90,&Icon1[0]); /* Step 4 Draw icon bitmap to start position */
	Display_Icon(0,184,&Icon1[0]); /*    and draw a copy for Copy_Icon          */

	getch();                         /* Wait for user input                     */

#define DELAY	100				/* set this value to your liking */
	for (j=0; j<20*DELAY; j += DELAY) {		 /* add our little delay loop                   */
		Copy_Icon(2,90,37,90);		  /* rewrite the background   */
		for (i=2; i<38; i++) {   /* Step 5 - Perform some animation using icons */
	    	Copy_Icon(0,184,i,90);   /*    Copy the icon to the new position    */
		    Copy_Icon(0,  0,i-2,90); /*    Overwrite trailing position w/bkg    */
			delay(j);
		}
		Display_Icon(0,184,&Icon1[0]); /*    and draw a copy for Copy_Icon  */
   }

	getch();                           /* Wait for user prompt              */
	Video_Mode ( 3 );         /* Properly restore text mode before exiting  */
};

void delay(int count) {	/* our delay function to slow things down */
	while (count--)
		srand(0);		/* use any function for delay */
}
