' =======================================================
'  VGABOX.BAS  Copyright (c) 1990  Michael Welch
'  included with GrafWiz by permission
' =======================================================
'  Name:  VGABOX.BAS
'  Type:  Main Module
'  Lang:  Microsoft QuickBASIC v4.5
'  Ver:   1.00
'  Date:  10/30/1990
'  By:    Michael Welch of Dallas, Texas
'  Reqs:  Crescent Software's PDQ.LIB
'         Tom Hanlin's Graphics Wizard replacement lib
'  Purp:  (multifaceted):
'         1.  To demonstrate the efficiency of Crescent's
'             BCOMxx replacement library for QuickBASIC.
'         2.  To demonstrate the capabilities and the
'             extensions of Tom Hanlin's Graphics Wizard
'             replacement graphics library.
'         3.  To demonstrate the color range of the VGA's
'             high-color mode.
'| Mods:  Thomas G. Hanlin III
'|        My modifications were largely a matter of
'|        reformatting the source to appear more like
'|        the other GRAFWIZ sources, for consistency.
'|        A few other trivial alterations were made.
' =======================================================
'
DECLARE FUNCTION BiosInkey% ()          ' PDQ replacement for ASC(INKEY$)
DECLARE FUNCTION PDQRand% (Range%)      ' PDQ replacement for RND
DECLARE SUB PDQRandomize (Seed%)        ' PDQ replacement for RANDOMIZE

   REM $INCLUDE: 'GRAFWIZ.BI'

   DEFINT A-Z                           ' does not need floating point math

   GetDisplay Adapter, Mono            ' check adapter type
   IF Adapter < 6 THEN                 ' just end if less than VGA
      PRINT "Sorry, you need a VGA for this demo!"
      END
   END IF

   DEF SEG = 0
   z = PEEK(&H41C) + PEEK(&H41D) * 256
   PDQRandomize z                      ' RANDOMIZE based on system timer

   PRINT
   PRINT "VGABOX v1.00  (P) 1990 Mike Welch"
   PRINT "VGA animation demo of 256 colors"
   PRINT "[] Slows down    [] Larger box"        ' <-- won't be able to
   PRINT "[] Speeds up     [] Smaller box"       ' <-- print these chars!
   PRINT "ESC Terminates    Other key, CLS"
   PRINT
   PRINT "Any key continues"
   DO: LOOP UNTIL LEN(INKEY$)

   G13Mode 1                            ' SCREEN 13 replacement

   ' Altered from S&B4EGA to work with
   ' the new SCREEN 13 mode of GRAFWIZ
   G13Cls                                  ' clear screen
   BoxSiz = 10                             ' initial box size
   Delay = 10                              ' initial delay rate
   DO                                      ' loop until keypress
      EndLoop = 0                          ' reset Boolean flag
      c = c + 1                            ' increase color counter
      IF c > 246 THEN c = 1                ' reset if out of range (black)
      DO                                   ' derive legal value for animation
         X1 = X1 + Xo                      ' add to x-coord
         Y1 = Y1 + Yo                      ' add to y-coord
         z = PDQRand(2)                    ' used for animation, step value
         IF X1 < 15 THEN                   ' if under x range
            Xo = z                         ' enlarge value
         ELSEIF X1 > 305 THEN              ' if over x range
            Xo = 0 - z - 1                 ' decrease value
         ELSEIF Y1 < 15 THEN               ' if under y range
            Yo = z                         ' enlarge
         ELSEIF Y1 > 185 THEN              ' if over y range
            Yo = 0 - z - 1                 ' decrease
         ELSE
            EndLoop = -1                   ' quit computing and draw box
         END IF
      LOOP UNTIL EndLoop

      G13Color c, 0                        ' set color here
      G13Box X1 - BoxSiz, Y1 + BoxSiz, X1 + BoxSiz, Y1 - BoxSiz, c

      IF c MOD Delay = 0 THEN CALL Pause(1)' delay 1/18th second

      a = BiosInkey                        ' no errors here w/PDQ
      IF a THEN                            ' if a key was pressed
         SELECT CASE a                     ' PDQ: -val for extended key
            CASE -75                       ' left_arrow; slow down
               IF Delay > 1 THEN Delay = Delay - 1
            CASE -77                       ' right_arrow; speed up
               IF Delay < 64 THEN Delay = Delay + 1
            CASE -72                       ' up_arrow; make box larger
               IF BoxSiz < 10 THEN BoxSiz = BoxSiz + 1
            CASE -80                       ' down_arrow; make box smaller
               IF BoxSiz > 2 THEN BoxSiz = BoxSiz - 1
            CASE 27                        ' ESC
               c = 0                       ' set end loop flag
            CASE ELSE                      ' any other key
              G13Cls                       ' clear screen
         END SELECT
      END IF
   LOOP WHILE c

   G13Mode 0                               ' restore text mode
   PRINT "[2J";
