TITLE  'Clip 3D'
NAME   CLIP3D
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Clip line to window in 3D (partial)                    |
;   caller:      FAR call (QuickBASIC convention)                       |
;                inside=CLIP3D%(vseg,voff)                              |
;    stack:     +06 = offset of data                                    |
;                08 = segment                                           |
;  returns:      true if line visible/clipped line points if inside     |
;     NOTE:      window must have been established                      |
;     NOTE:      currently does not clip behind viewer (z info not used)|
;------------------------------------------------------------------------

PARMS           = 2
ARGoff          EQU [bp+06]
ARGseg          EQU [bp+08]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

CLIP3D_TEXT     SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:CLIP3D_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  CLIP3D
CLIP3D          PROC    FAR

                sub     bx,bx
                mov     ax,X1clip3      ;make sure we have a valid window
                sub     ax,X0clip3      ;to avoid division by zero
                cmp     ax,bx
                jg      C01
C00:            sub     ax,ax           ;return inside = FALSE
                jmp     CLIP3D_xit3

C01:            mov     ax,Y1clip3
                sub     ax,Y0clip3
                cmp     ax,bx
                jle     C00

                push    bp
                mov     bp,sp
                push    bp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGoff
                mov     si,[bx]
                mov     bx,ARGseg
                mov     es,[bx]         ;es:si->(x0,y0),(x1,y1) data
                push    si              ;es:si is ON STACK
                push    es

                db 26h
                lodsw
                mov     x0,ax
                db 26h
                lodsw
                mov     y0,ax

                db 26h
                lodsw
                mov     x1,ax
                db 26h
                lodsw
                mov     y1,ax

                call    Trap0           ;set up DIV0INT

                mov     ax,x1
                sub     ax,x0
                mov     di,ax           ;di=deltaX=EndPt.X2 - EndPt.X1
                mov     ax,y1
                sub     ax,y0
                mov     si,ax           ;si=deltaY=EndPt.Y2 - EndPt.Y1

                call    SetOutCode1_2
                call    SetOutCode2_2

                ;main loop
                
C3_00:          mov     Inside,-1
                mov     ax,OC1
                or      ax,OC2
                jz      L1
                mov     Inside,0

L1:             mov     Outside,-1
                mov     ax,OC1
                and     ax,OC2
                jnz     L2
                mov     Outside,0

L2:             mov     ax,Outside
                not     ax
                mov     bx,Inside
                not     bx
                and     ax,bx           ;WHILE (NOT(Outside)) AND (NOT(Inside))
                jnz     L3
                jmp     CLIP3D_xit

L3:             mov     bx,1000         ;multiplier/divisor 10^4 overflows
                                        ; if we do signed IMUL & IDIV
                mov     bp,OC1          ;c=C1
                or      bp,bp           ;IF c = 0 then c = C2
                jnz     C3_01
                mov     bp,OC2

C3_01:          test    bp,1            ;IF c AND left
                jz      C3_02
                mov     cx,X0clip3
                sub     cx,x0           ;cx=(Region.ULx-EndPt.X1)

                mov     ax,si           ;si=deltaY
                imul    bx              ;dx:ax=(dy*1000)
                idiv    di              ;ax=(dy*1000\dx)  di=deltaX

                imul    cx      ;dx:ax=(Region.ULx-EndPt.X1)*(dy*1000\dx)
                idiv    bx      ;ax=(Region.ULx-EndPt.X1)*(dy*1000\dx)\1000

                ;ax=EndPt.Y1+(Region.ULx-EndPt.X1)*(dy*1000\dx)\1000
                add     ax,y0           ;ax=y
                mov     cx,X0clip3      ;cx=Region.ULx=x
                xchg    ax,cx           ;ax=x  cx=y
                jmp     short C3_05

C3_02:          test    bp,2            ;ELSEIF c AND above
                jz      C3_03

                mov     cx,Y0clip3
                sub     cx,y0           ;cx=(Region.ULy-EndPt.Y1)

                mov     ax,di           ;di=deltaX
                imul    bx              ;dx:ax=(dx*1000)
                idiv    si              ;ax=(dx*1000\dy) si=deltaY

                imul    cx      ;dx:ax=(Region.ULy-EndPt.Y1)*(dx*1000\dy)
                idiv    bx      ;ax=(Region.ULy-EndPt.Y1)*(dx*1000\dy)\1000

                ;ax=EndPt.X1+(Region.ULy-EndPt.Y1)*(dx*1000\dy)\1000
                add     ax,x0           ;ax=x
                mov     cx,Y0clip3      ;cx=Region.ULy=y
                jmp     short C3_05

C3_03:          test    bp,4            ;ELSEIF c and right
                jz      C3_04

                mov     cx,X1clip3
                sub     cx,x0           ;cx=(Region.LRx-EndPt.X1)

                mov     ax,si           ;si=deltaY
                imul    bx              ;dx:ax=(dy*1000)
                idiv    di              ;ax=(dy*1000\dx)  di=deltaX

                imul    cx      ;dx:ax=(Region.LRx-EndPt.X1)*(dy*1000\dx)
                idiv    bx      ;ax=(Region.LRx-EndPt.X1)*(dy*1000\dx)\1000

                ;ax=EndPt.Y1+(Region.LRx-EndPt.X1)*(dy*1000\dx)\1000
                add     ax,y0           ;ax=y
                mov     cx,X1clip3      ;cx=Region.LRx
                xchg    ax,cx           ;ax=x  cx=y
                jmp     short C3_05

C3_04:          test    bp,8            ;ELSEIF c AND below
                jz      C3_05

                mov     cx,Y1clip3
                sub     cx,y0           ;cx=(Region.LRy-EndPt.Y1)

                mov     ax,di           ;di=deltaX
                imul    bx              ;dx:ax=(dx*1000)
                idiv    si              ;ax=(dx*1000\dy)  si=deltaY

                imul    cx      ;dx:ax=(Region.LRy-EndPt.Y1)*(dx*1000\dy)
                idiv    bx      ;ax=(Region.LRy-EndPt.Y1)*(dx*1000\dy)\1000

                ;ax=EndPt.X1+(Region.LRy-EndPt.Y1)*(dx*1000\dy)\1000
                add     ax,x0           ;ax=x
                mov     cx,Y1clip3      ;cx=Region.LRy=y
                jmp     short C3_05

C3_05:          cmp     bp,OC1          ;IF c = C1
                jne     C3_06
                mov     x0,ax           ;EndPt.X1 = x
                mov     y0,cx           ;EndPt.Y1 = y
                call    SetOutCode1_2
                jmp     short C3_07
                                        ;ELSE
C3_06:          mov     x1,ax           ;EndPt.X2 = x
                mov     y1,cx           ;EndPt.Y2 = y
                call    SetOutCode2_2

C3_07:          jmp     C3_00           ;loop to main


CLIP3D_xit:     call    UnTrap0
                pop     es              ;es:di->original points
                pop     di
                cmp     Inside,-1
                jne     CLIP3D_xit2
                mov     ax,x0
                stosw
                mov     ax,y0
                stosw

                mov     ax,x1
                mov     x0,ax           ;update step point
                stosw
                mov     ax,y1
                mov     y0,ax
                stosw

CLIP3D_xit2:    mov     ax,Inside
CLIP3D_xit2a:   pop     di
                pop     si
                pop     ds
                pop     bp
                mov     sp,bp
                pop     bp
CLIP3D_xit3:    RET     PARMS*2

CLIP3D          ENDP


SetOutCode1_2   PROC NEAR

                sub     cx,cx           ;clear outcode 1
                mov     ax,x0           ;EndPt.X0
                cmp     ax,X0clip3      ;EndPt.X0 < Region.ULx?
                jge     SOC1_1           ;not to left of region
                or      cx,1
                jmp     short SOC1_2
SOC1_1:         cmp     ax,X1clip3      ;EndPt.X0 > Region.LRx?
                jle     SOC1_2          ;not to right of region
                or      cx,4

SOC1_2:         mov     ax,y0           ;EndPt.Y0
                cmp     ax,Y0clip3      ;EndPt.Y0 < Region.ULy?
                jge     SOC1_3          ;not above region
                or      cx,2
                jmp     short SOC1_4
SOC1_3:         cmp     ax,Y1clip3      ;EndPt.Y0 > Region.LRy?
                jle     SOC1_4          ;not below region
                or      cx,8
SOC1_4:         mov     OC1,cx
                ret
SetOutCode1_2   ENDP


SetOutCode2_2   PROC NEAR

                sub     cx,cx           ;clear outcode 2
                mov     ax,x1           ;EndPt.X1
                cmp     ax,X0clip3      ;EndPt.X1 < Region.ULx?
                jge     SOC2_1          ;not to left of region
                or      cx,1
                jmp     short SOC2_2
SOC2_1:         cmp     ax,X1clip3      ;EndPt.X1 > Region.LRx?
                jle     SOC2_2          ;not to right of region
                or      cx,4

SOC2_2:         mov     ax,y1           ;EndPt.Y1
                cmp     ax,Y0clip3      ;EndPt.Y1 < Region.ULy?
                jge     SOC2_3          ;not above region
                or      cx,2
                jmp     short SOC2_4
SOC2_3:         cmp     ax,Y1clip3      ;EndPt.Y1 > Region.LRy?
                jle     SOC2_4          ;not below region
                or      cx,8
SOC2_4:         mov     OC2,cx          ;outcode 2 done
                ret
SetOutCode2_2   ENDP


Trap0           PROC NEAR

                push    ds
                sub     ax,ax
                mov     ds,ax
                mov     es,ax
                mov     si,ax           ;ds:si->div by zero int vector
                mov     di,ax           ;es:di->ditto
                cli
                lodsw                   ;get old offset
                mov     ss:[INT0off],ax
                lodsw                   ;get old segment
                mov     ss:[INT0seg],ax
                sti
                cli
                mov     ax,offset DIV0INT ;point it to DIVINT
                stosw
                mov     ax,cs
                stosw
                sti
                pop     ds
                ret

DIV0INT:        add     sp,10           ;remove IRET address,flags,es:si->
                call    UnTrap0
                sub     ax,ax
                jmp     CLIP3D_xit2a

Trap0           ENDP

UnTrap0         PROC NEAR

                sub     ax,ax
                mov     es,ax
                mov     di,ax           ;es:di->div by zero int vector
                mov     ax,INT0off
                cli
                stosw                   ;put old offset
                mov     ax,INT0seg
                stosw                   ;put old segment
                sti
                ret
UnTrap0         ENDP

CLIP3D_TEXT     ENDS
                END

