DECLARE FUNCTION FileExists% (filename$)

'FileExists using INTRPT2.OBJ INTERRUPTX()
'Cornel Huth
'21-Jul-91

'C>bc FILEX /o;
'C>link FILEX+INTRPT2;
'or C>link FILEX,FILEX.EXE,nul,QB.LIB if INTRPT2 is in QB.LIB

TYPE RegTypeX
ax AS INTEGER
bx AS INTEGER
cx AS INTEGER
dx AS INTEGER
bp AS INTEGER
si AS INTEGER
di AS INTEGER
flags AS INTEGER
ds AS INTEGER
es AS INTEGER
END TYPE

DECLARE SUB INTERRUPTX (intnum%, ireg AS RegTypeX, oreg AS RegTypeX)

DEFINT A-Z

filename$ = COMMAND$
IF LEN(filename$) THEN
   stat = FileExists(filename$)
   IF stat = 0 THEN PRINT "found" ELSE PRINT "not found, DOS error:"; stat
ELSE
   PRINT "no filename, use: C>FILEX filename"
END IF
SYSTEM

FUNCTION FileExists (filename$)

'returns 0 if file exists and is accessible
'else returns DOS error

DIM pathname AS STRING * 67
DIM ireg AS RegTypeX, oreg AS RegTypeX

pathname = filename$ + CHR$(0)

ireg.ax = &H3D00                'open file
ireg.ds = VARSEG(pathname)
ireg.dx = VARPTR(pathname)
INTERRUPTX &H21, ireg, oreg

IF oreg.flags AND 1 THEN        'open error
   FileExists = oreg.ax
ELSE                            'open okay
   ireg.ax = &H3E00             'close file
   ireg.bx = oreg.ax
   INTERRUPTX &H21, ireg, oreg
   IF oreg.flags AND 1 THEN     'close error
      FileExists = oreg.ax
   ELSE
      FileExists = 0            'file exists and accessible
   END IF
END IF

END FUNCTION

