{

Logs the current time in a file.

Version 1.00

(c) Copyright 1993, Michael Gallias

Target: Real

}

Program LogTime;

Uses CRT, DOS, CmndLine, PasStr;

{$M 2048,0,0}

Type
  TSetup        = Record
                    Msg1,
                    Msg2        :String;
                    FileName    :String;
                    Store       :Boolean;
                    Display     :Boolean;
                    List        :Boolean;
                  End;

Var
  Setup         : TSetup;

Procedure FixUnderscore(Var M:String);

Var
  x     : Byte;

Begin
  For x:=1 to Length(M) do
    If M[x]='_' Then M[x]:=' ';
End;

Procedure SetOpts;

Var
  X     : Byte;
  Item  : CommandItem;

Begin
  Setup.FileName:='C:\TEMP\BOOTLOG';
  Setup.Msg1:='Last bootup: ';
  Setup.Msg2:='.';
  Setup.Store:=True;
  Setup.Display:=True;
  Setup.List:=False;

  For X:=1 to ParamCount do
  Begin
    CommandOption(case_Leave, X, Item);
    With Item do
    If Tag = cmnd_DString Then
    Begin
      If (SName1 = 'f') Or (SName1 = 'F') Then Setup.FileName:=SName2;
      If (SName1 = '1') Then Setup.Msg1:=SName2;
      If (SName1 = '2') Then Setup.Msg2:=SName2;
    End
    Else
    If Tag = cmnd_Switch Then
    Begin
      If Switch[1] in ['d','D'] Then
      Begin
        If Switch[Length(Switch)]='-' Then
          Setup.Display:=False
        Else
          Setup.Display:=True;
      End
      Else
      If Switch[1] in ['s','S'] Then
      Begin
        If Switch[Length(Switch)]='-' Then
          Setup.Store:=False
        Else
          Setup.Store:=True;
      End
      Else
      If Switch[1] in ['l','L'] Then
      Begin
        Setup.List:=True;
        Setup.Display:=False;
        Setup.Store:=False;
      End;
    End;
  End;
  FixUnderscore(Setup.Msg1);
  FixUnderscore(Setup.Msg2);
End;

Const
  MaxTimes      = 170;

Type
  TTime         = Array [1..MaxTimes] Of DateTime;
                  {1 is the oldest time, MaxTimes is the newest}
  FTime         = File Of TTime;

Var
  Time          : TTime;


Procedure LoadFile;

Var
  C     : Char;
  F     : FTime;

Begin
  Assign(F,Setup.FileName);
  Reset(F);
  If IOResult>0 Then
  Begin
    WriteLn('Warning, Can''t open ',Setup.FileName,'.');
    WriteLn;
    WriteLn('Select:');
    WriteLn('          1.  Create Blank File');
    WriteLn('          2.  Exit');
    WriteLn;
    Repeat
      C:=ReadKey;
    Until C in ['1','2',#27];
    If C='1' Then
    Begin
      FillChar(Time,SizeOf(Time),0);
      Write('Creating New File ... ');
      Assign(F,Setup.FileName);
      Rewrite(F);
      If IOResult>0 Then
      Begin
        WriteLn('Error creating file.');
        Halt;
      End;
      Write(F,Time);
      Close(F);
      WriteLn('Done.');
    End
    Else
    Begin
      WriteLn('Exit.');
      Halt;
    End;
  End
  Else
  Begin
    Read(F,Time);
    Close(F);
  End;
End;

Function TimeString(TheTime:DateTime):String;

Var
  S, T  :String[20];
  TS    :String;

Begin
  With TheTime do
  Begin
    Str(Day:2,S);
    Str(Month:2,T);
    Str(Year,TS);
    SpacesToZeros(S,S);
    SpacesToZeros(T,T);
    TS:=S+'/'+T+'/'+TS+'  ';

    Str(Hour:2,S);
    Str(Min:2,T);
    SpacesToZeros(S,S);
    SpacesToZeros(T,T);
    TS:=TS+S+':'+T;
    Str(Sec:2,T);
    SpacesToZeros(T,T);
    TS:=TS+':'+T;
  End;

  TimeString:=TS;
End;

Procedure DisplayLastTime;
Begin
  If Time[MaxTimes].Day=0 Then Exit;

  Write(Setup.Msg1);
  Write(TimeString(Time[MaxTimes]));
  WriteLn(Setup.Msg2);
End;

Procedure UpdateTime;

Var
  X     : Word;

Begin
  For X:=1 to MaxTimes-1 do
    Time[X]:=Time[X+1];

  With Time[MaxTimes] do
  Begin
    GetDate(Year, Month, Day, X);
    GetTime(Hour, Min, Sec, X);
  End;
End;

Procedure UpdateFile;

Var
  C     : Char;
  F     : FTime;

Begin
  C:='0';
  Assign(F,Setup.FileName);
  Reset(F);
  If IOResult>0 Then C:='1';
  Write(F,Time);
  If IOResult>0 Then C:='1';
  Close(F);
  If IOResult>0 Then C:='1';
  If C='1' Then
  Begin
    WriteLn('Error Saving File ',Setup.FileName,'.');
    WriteLn('Press any key ...');
    C:=ReadKey;
  End;
End;

Procedure DisplayList;

Var
  X     : Word;

Begin
  WriteLn;
  WriteLn('Recorded Times (LOGTIME Version 1.00)');
  WriteLn;
  For X:=1 to MaxTimes do
    If Time[X].Day<>0 Then WriteLn(TimeString(Time[X]));
  WriteLn;
End;

Begin
  DirectVideo:=False;

  SetOpts;
  LoadFile;

  If Setup.Display Then
    DisplayLastTime;

  If Setup.Store Then
  Begin
    UpdateTime;
    UpdateFile;
  End;

  If Setup.List Then
    DisplayList;
End.
