/* BEGIN DAVID LAI COPYRIGHT ********************************************* */
/*
(C) Copyright David Lai 1993, 1994.  All rights reserved.

The source code is copyright by David Lai, however it is freely
distributable and released for unrestricted use.  Users may copy or modify 
this source code without charge, provided all copyright
notices remain intact in all the source code.  Portions of the source code
copyright by their respective copyright holders and are covered
under different agreements, however the source code used has
specifically been marked distributable royalty-free.

You can do whatever you want with it, even charge money for it, if
you find a sucker willing to pay for it.  This is not shareware, the program
is not crippled in any way, do not send money.  You can e-mail comments
to the electronic mail address below, or fax to the fax number below.

If you add a feature thats useful, or do a new port, you can send
the context diffs to the e-mail address below.  I may include it in
subsequent releases.  Your code must specifically be marked
freely distributable, I will not include code marked otherwise.

THE SOURCE CODE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.

The source code is provided with no support and without any obligation on
the part of David Lai to assist in its use, correction,
modification or enhancement.

DAVID LAI SHALL HAVE NO LIABILITY WITH RESPECT TO THE
INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS SOFTWARE
OR ANY PART THEREOF.

In no event will David Lai be liable for any lost revenue
or profits or other special, indirect and consequential damages, even if
David Lai has been advised of the possibility of such damages.

David Lai
1370 McKendrie St
San Jose, CA 95126
fax: 408-241-4615

lai%fastfood@daver.bungi.com

*/
/* END   DAVID LAI COPYRIGHT ********************************************* */

#define PRODUCT_ID	"Mod Compiler v0.00"

#define MOD_TAGSIZE 4
#define TAG_OFFSET_15 600L
#define TAG_OFFSET_31 1080L
#define CHECK_31_INST_OFFSET 470L
#define SAMPLE_NAME_SIZE	22
#define MAX_INSTRUMENTS	31
#define MOD_NAME_LENGTH	20
#define SAMPLE_HEADER_OFFSET 20
#define SAMPLE_HEADER_LENGTH	30
#define PATTERN_TABLE_SIZE 128
#define NOTESIZE 4
#define LINES_PER_PATTERN 64
#define MAX_VALID_END_JUMP_POS 126
#define NOTES_PER_OUTPUT_LINE	4
#define SAMPLE_BUFFER_SIZE	4096
#define SAMPLE_IGNORE_BYTES	2	/* ignore this # of bytes at start of
					   each sample */
enum sample_format
	{
	Internal,	/* internal array */
	Wave,		/* Microsoft .wav */
	Voc,		/* Creative Labs' .voc */
	Sample,		/* .SAM, raw 8-bit signed */
	Ascii		/* ascii -128 to 127 */
	};

struct sample_format_info
	{
	char *name;
	};

enum main_effects
	{
	Arpeggio=0,
	SlideUp,
	SlideDown,
	TonePortamento,
	Vibrato,
	TonePortamentoVolumeSlide,
	VibratoVolumeSlide,
	Tremolo,
	NOTUSED,
	SetSampleOffset,
	VolumeSlide,
	PositionJump,
	SetVolume,
	PatternBreak,
	Extended,
	SetSpeed,
	SetFilter=0xE0,
	FineSlideUp,
	FineSlideDown,
	GlissandoControl,
	SetVibratoWaveform,
	SetFinetune,
	JumptoLoop,
	SetTremoloWaveform,
	NOTUSED2,
	RetrigNote,
	FineVolumeSlideUp,
	FineVolumeSlideDown,
	NoteCut,
	NoteDelay,
	PatternDelay,
	InvertLoop,
	Normal=0xFF
	};

struct effect_info
	{
	char *name;
	int  number_of_args;
	};

struct sample
	{
	char	name[SAMPLE_NAME_SIZE+1];
	uint16	length;
	uint16	orig_length;
	signed char	finetune;
	unsigned char	volume;
	uint16	rpt_offset;
	uint16	rpt_length;
	off_t	data_offset;	/* offset in file of sample data */
	char	*sample_filename;
	};


#ifdef BE
struct note
	{	/* big endian (native amiga) version */
	unsigned	sample_upper:4;
	unsigned	sample_period_upper:4;
	unsigned	sample_period_lower:8;
	unsigned 	sample_lower:4;
	unsigned	effect_main:4;
	unsigned arg1:4;
	unsigned arg2:4;
	};
#else
struct note
	{	/* little endian version */
	unsigned	sample_period_upper:4;
	unsigned	sample_upper:4;
	unsigned	sample_period_lower:8;
	unsigned	effect_main:4;
	unsigned 	sample_lower:4;
	unsigned arg2:4;
	unsigned arg1:4;
	};
#endif

union u_note
	{	/* map the word in the file to the note structure */
	struct note note;
	uint32	note_word;	/* as it is in the file */
	};

#define SAMPLE_NUMBER(x) (((x)->note.sample_upper << 4) | (x)->note.sample_lower)
#define SAMPLE_PERIOD(x) (((x)->note.sample_period_upper << 8) | (x)->note.sample_period_lower)
#define EFFECT(x) ((x)->note.effect_main)
#define EXT_EFFECT(x) (((x)->note.effect_main << 4) | (x)->note.arg1)
#define ARG1(x) ((x)->note.arg1)
#define ARG2(x) ((x)->note.arg2)
#define BIGARG(x) ((ARG1(x)<<4) + ARG2(x))
#define SMALLARG(x) (ARG2(x))
#define SIGN_EXT_NIBBLE(n) ((((n)&8)==8)?(((n)&0xf)-16):((n)&0xf))

#define WARN_CHECK (warns++>30?err_exit("Too many warnings, Aborting",NULL):NULL)

#if 0
$Id: modcomp.h,v 1.1 1994/03/19 09:21:31 dlai Exp $
$Log: modcomp.h,v $
 * Revision 1.1  1994/03/19  09:21:31  dlai
 * Initial revision
 *

#endif
