/****************************************************************/
/*                                                              */
/*          Digitized Voice Programmer's Toolkit                */
/*          ------------------------------------                */
/*                                                              */
/*      Example of a program with embedded voice data           */
/*                                                              */
/*          Copyright (c) 1989, Farpoint Software               */
/*                                                              */
/*                                                              */
/*  This program simply plays a voice message while displaying  */
/*  a message repeatedly indicating the count of bytes played.  */
/*  The digitized voice data is embedded in the EXE file rather */
/*  than being read from a separate file. Study the "make" file */
/*  named EMBEDDED to see how the EXE file was created.         */
/*                                                              */
/****************************************************************/

#include "vpmod.h"

#include <stdlib.h>
#include <stdio.h>
#include <bios.h>

extern unsigned char EVMSG;
extern unsigned char EVMSGLEN;

main(argc,argv)
int argc;
char **argv;

{
long count,index;

PVOICE_INIT();

PVOICE_START(&EVMSG,(long)(&EVMSGLEN - &EVMSG),0,0,(long)(&EVMSGLEN - &EVMSG),0L);
printf("Voice playback has begun.\n");

/* loop until done */
/* if PVOICE_STATUS returns zero then playback is done */

while (PVOICE_STATUS(&count,&index))
	{

	/* displaying messages is just something to do in the foreground */

	printf("Number of bytes played = %ld\n",count);

	/* check the keystroke buffer */

	if (_bios_keybrd(_KEYBRD_READY))
		{

		/* a key was pressed, see if it is the <Esc> key */

		if ( (_bios_keybrd(_KEYBRD_READ) >> 8) == 0x01 )
			{
			PVOICE_STOP();
			printf("Voice playback stopped with <Esc>\n");
			break;
			}
		}
	}

/* do this before exiting or die later */

PVOICE_CLEANUP();

}
