procedure BADSURF;

{ A bad surface was attempted to be plotted. Explain why and halt. }
begin
  exgraphic;
  writeln ('Error: You have attempted to plot a concave surface.');
  writeln ('  This surface should be broken into at least two smaller');
  writeln ('  surfaces. Alternatively, you may possibly be able to');
  writeln ('  plot this surface anyway from a different angle or');
  writeln ('  with a lower magnification factor.');
  halt;
end;  { procedure BADSURF }


procedure FILLSURF (Surf: word; Mat: integer; Oldshade: real);

{ Draw a filled surface number Surf }

var Npts: integer;               { #points on edges of the surface }
    Nextpt: integer;             { Next point to use for filling }
    Node1, Node2: word;          { node numbers of endpts of line }
    Xpt, Ypt: points;            { pts on edges of surface }
    Vert: integer;               { vertex number }
    Pcolor: integer;             { actual color to plot with }
    Fmod: integer;               { mod for filling function }
    Ishade: integer;             { int version of shade (0..16) }
    Color1, Color2: integer;     { color #'s to use for dithering }
    Shade: real;                 { shade interpolated between palette entries }
    Col: integer;                { color # (temp) }

begin
{$ifdef BIGMEM}
with ptrd^ do with ptre^ do with ptrh^ do with ptri^ do
begin
{$endif}
  Shade := Oldshade;
  if (onscreen (Surf)) then begin

    if Mat = 0 then
      { Used in hidden line plots only }
      Col := 0
    else
      Col := Color[Mat];
    if (Ncolors >= 3) and (Mono) then
      { use system's colors as shades of grey }
      colormod (Shade, GrSys, Col, Pcolor, Fmod)
    else begin
      { use dithered shading }
      findcolors (Mat, Col, Shade, Color1, Color2);
      Ishade := trunc (Shade * 16.0); { only 16 dither levels }
    end;

    Npts := 0;
    for Vert := 1 to Nvert[Surf]-1 do begin
      Node1 := Konnec (Surf, Vert);
      Node2 := Konnec (Surf, Vert+1);
      storline (round(Xtran[Node1]), round(Ytran[Node1]),
                round(Xtran[Node2]), round(Ytran[Node2]), Xpt, Ypt, Npts);
      if (Npts < 0) then
        badsurf;
    end; { for Vert }

{ One last line to close the polygon }
    Node1 := Konnec (Surf, Nvert[Surf]);                    { last node }
    Node2 := Konnec (Surf, 1);                          { first node }
    storline (round(Xtran[Node1]), round(Ytran[Node1]),
              round(Xtran[Node2]), round(Ytran[Node2]), Xpt, Ypt, Npts);
    if (Npts < 0) then
      badsurf;

{ Sort the line segment points, first by Y, then by X }
    shellpts (Xpt, Ypt, Npts);

{ Now draw the filled surface }
    Nextpt := 1;
    if (Ncolors >= 3) and (Mono) then begin
      { use system's colors as shades of grey }
      while (Nextpt < Npts) do begin
        if (abs(Xpt[Nextpt] - Xpt[Nextpt+1]) > 1) and
           (Ypt[Nextpt] = Ypt[Nextpt+1]) then begin
          shdraw (Xpt[Nextpt],Xpt[Nextpt+1],Ypt[Nextpt],Pcolor,Fmod);
          Nextpt := Nextpt + 2;
        end else begin
          shplot (Xpt[Nextpt], Ypt[Nextpt], Pcolor, Fmod);
          Nextpt := Nextpt + 1;
        end;
      end; { while }
      if (Nextpt = Npts) then
        shplot (Xpt[Nextpt], Ypt[Nextpt], Pcolor, Fmod);
    end else begin
      { use dithered shading }
      while (Nextpt < Npts) do begin
        if (abs(Xpt[Nextpt] - Xpt[Nextpt+1]) > 1) and
           (Ypt[Nextpt] = Ypt[Nextpt+1]) then begin
          dithdraw (Xpt[Nextpt],Xpt[Nextpt+1],Ypt[Nextpt],Ishade,Color1,Color2);
          Nextpt := Nextpt + 2
        end else begin
          dithplot (Xpt[Nextpt],Ypt[Nextpt],Ishade,Color1,Color2);
          Nextpt := Nextpt + 1
        end;
      end; { while }
      if (Nextpt = Npts) then
        dithplot (Xpt[Nextpt],Ypt[Nextpt],Ishade,Color1,Color2);
    end; { if Ncolors... }
  end; { if onscreen }
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure FILLSURF }
