procedure PARAMENU;
{ Parameters menu to change constants, select options, read a new file,
  or save current settings }

var Cmmd: integer;         { user's inputted choice }
    c: char;               { input character }

begin
  repeat
    openwin (13,6,67,21, TRUE);
    gotoXY (19,1);
    writeln ('PARAMETERS MENU');
    writeln; writeln;
    writeln ('1  Change Lighting Parameters');
    writeln ('2  Eye Coordinates (',Xeye:7:2,',',Yeye:7:2,',',Zeye:7:2,')');
    writeln ('3  Focal Point (',Xfocal:7:2,',',Yfocal:7:2,',',Zfocal:7:2,')');
    writeln ('4  Magnification (',Magnify:7:2,')');
    write   ('5  View Type (');
    if (Viewtype = 0) then
      writeln ('Perspective)')
    else if (Viewtype = 1) then
      writeln ('X-Y)')
    else if (Viewtype = 2) then
      writeln ('X-Z)')
    else
      writeln ('Y-Z)');
    writeln ('6  Save Params (', Inifile,')');
    writeln ('0  Return To Main Menu');
    writeln;
    write ('Command: ');
    Cmmd := getkey;
    if (Cmmd < 0) or ((Cmmd > 8) and (Cmmd <> 10)) then
      write(^G)
    else begin
      writeln (Cmmd);
      case Cmmd of
        1: litemenu;
        2: begin
          writeln ('Enter new Eye Coordinates.');
          Xeye := getonereal (Xeye, -99999.0, 99999.0, 'X of Eye');
          Yeye := getonereal (Yeye, -99999.0, 99999.0, 'Y of Eye');
          Zeye := getonereal (Zeye, -99999.0, 99999.0, 'Z of Eye');
          Viewchanged := TRUE;
        end; { 3: }
        3: begin
          writeln ('Enter new Focal Point Coordinates.');
          Xfocal := getonereal (Xfocal, -99999.0, 99999.0, 'X of Focal Point');
          Yfocal := getonereal (Yfocal, -99999.0, 99999.0, 'Y of Focal Point');
          Zfocal := getonereal (Zfocal, -99999.0, 99999.0, 'Z of Focal Point');
          Viewchanged := TRUE;
        end; { 4: }
        4: begin
          Magnify := getonereal(Magnify, 0.0, 99999.0, 'Magnification Factor');
          Viewchanged := TRUE;
        end; { 5: }
        5: begin
          writeln ('A view type of 0 does perspective plotting.');
          writeln ('  1 gives an X-Y plot, 2 gives X-Z, and 3 gives Y-Z.');
          Viewtype := getoneint (Viewtype, 0, 3, 'View Type');
          writeln ('Do you want to show axes (Y/N)? ');
          c := readkey;
          writeln (c);
          if (upcase (c) = 'Y') then
            Showaxes := 1
          else
            Showaxes := 0;
          if (Showaxes > 0) then begin
            writeln ('Enter a real-coordinate length for each axis.');
            Xaxislen := getonereal (Xaxislen, 0.0, 99999.0, 'X Axis Length');
            Yaxislen := getonereal (Yaxislen, 0.0, 99999.0, 'Y Axis Length');
            Zaxislen := getonereal (Zaxislen, 0.0, 99999.0, 'Z Axis Length');
            Axiscolor := getoneint (Axiscolor, 1, Ncolors, 'Axis Color');
          end; { if Showaxes }
          Viewchanged := TRUE;
        end; { 6: }
        6: writecfg;
        10:; { Return to Main Menu }
        0:;  { Return to Main Menu }
      end; { case Cmmd }
    end;
  until (Cmmd = 0) or (Cmmd = 10)
end; { procedure Paramenu }
