	.MODEL  SMALL, C
	.CODE
	PUBLIC  cx_iscyrix

cx_flags_mask           DD      08d5h   ; Mask to isolate the undefined bits
					; masks all but OF, SF, ZF, AF, PF, CF
cx_flags_before         DD      0       ; Flags before div
cx_flags_after          DD      0       ; Flags after div
cx_dividend             DD      0ffffh  ; Dividend
cx_divisor              DD      04h     ; Divisor
cx_result               DD      0       ; Results of flags compare
					; 0=different (Intel), 1=same (Cyrix)

;
;       int cx_iscyrix(void)
;
;       This routine returns 1 if we are running on a 486DLC/SLC CPU.
;       Otherwise, it returns 0.
;

cx_iscyrix      PROC			; The procedure name

	.386P				; Allow 386 prot. instructions

; Use of MASM 5.1 shoud make this unnecessary.
;       push	ebp
;       move	ebp, esp

	pushad                          ; Save processor state
	pushfd

	mov     eax,0                   ; Set flags to known state      
	cmp     eax, eax

	pushfd                          ; Load flags into eax
	pop     eax
	mov     cx_flags_before, eax    ; Save flags to mem

	; Do a div instruction so that the signature of the undefined flags
	; can be observed

	mov     eax, cx_dividend
	mov     edx, 0
	mov     ebx, cx_divisor
	div     ebx

	pushfd                          ; Load flags into eax
	pop     eax

	mov     cx_flags_after, eax     ; Save flags to mem

	; Recall cx_flags_before and clear unwanted bits

	mov     eax, cx_flags_mask
	and     eax, cx_flags_before

	; Recall cx_flags_after and clear unwanted bits

	mov     ebx, cx_flags_mask
	and     ebx, cx_flags_after

	; Compare the signature of the undefined bits before and after

	cmp     eax, ebx
	jnz     cx_not_cyrix
	mov     cx_result, 1            ; Set if flag bits are unchanged
					; Cyrix part found
	jmp     cx_detect_done
cx_not_cyrix:
	mov     cx_result, 0            ; Clear if flag bits are changed
					; Cyrix part not found
cx_detect_done:
	popfd                           ; Restore processor state
	popad

	mov     eax, cx_result          ; Return value

; Again, use of MASM 5.1 should do this when it sees "ENDP" (I hope...)
;       pop     ebp

	ret

cx_iscyrix      ENDP
		END
	
