;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; int15.asm
;
; Function: replace int 15h subfunction 87h, the bios
;    move block function.  This function attempts to enter protected
;    mode, so we emulate it
;
	.386p
include segs.asi
include int15.asi
include emuinter.asi
	public	emuint15h,int15hinit,int15hrundown

SEG386data	segment
	extrn	userIDT : dword
source	dd	?               ; linear source for move
dest	dd	?               ; linear dest for move
count	dd	0               ; length of move
SEG386data	ends

SEG8086	segment
	extrn	chkctrlaltdel : PROC
	assume	cs:dgroup,ds:nothing
;
; Our 8086 block move routine
;
oldint15h	dd	?	; Saved val of old int15h vector
int15h	proc
	cmp	ah,MOVEBLOCK		; Check for moveblock function
	jz	short areemulating	; Branch if emulating
	call	chkctrlaltdel     ; Check for ctrlaltdel
	jmp	cs:[oldint15h]    ; Else just jump to old routine
areemulating:
	push	eax			; Save AX
	mov	eax,es:[si+BLOCKSOURCE]	; Get source
	and	eax,0ffffffh		; Make it 24 bits
	mov	[source],eax		;
	mov	eax,es:[si+BLOCKDEST]	; Get dest
	and	eax,0ffffffh		; Make it 24 bits
	mov	[dest],eax		;
	cmp	cx,8001h		; Limit on movelen
	jnc	badmove			; Branch if so
	shl	ecx,1			; Len is words
	mov	[count],ecx		; Get len.
	mov	al,EMU_BLOCKMOVE	; Set emulator function for move
	out	CONTROLPORT,al		;
	mov	al,EMUP_GENERAL		; Take emulator function
	out	DATAPORT,al		;
	pop	eax			; Restore ax
	xor	ah,ah			; Set flags & error code for success
	iret				; Return to caller
badmove:
	or	al,2			; Using exception error if count
	stc				; overflow
	iret
int15h	endp

SEG8086	ends

SEG386	segment
	assume	cs:dgroup, ds:dgroup,fs:absdata
;
; Routine to init for block move interrupt
;
int15hinit	proc
	pushfd        			; Clear IF
	cli				;
	mov	ebx,[userIDT]		; Get base of IDT table
	add	ebx,15h*4		; + int 15h vector ofs
	mov	eax,fs:[ebx]		; Get old vector
	mov	[oldint15h],eax		;
	mov	ax,DGROUP		; Set new vector in EAX
	shl	eax,16			;
	or	ax,offset DGROUP:int15h	;
	mov	fs:[ebx],eax		; Put vector in int table
	popfd				;
	ret
int15hinit	endp
;
; Routine to run down block move interrupt
;
int15hrundown	proc
	pushfd				; Clear IF
	cli
	mov	eax,[oldint15h]		; Put old vect back in table
	mov	ebx,[userIDT]
	mov	fs:[ebx + 15h*4],eax	; Get base of IDT + int 15h vector ofs
	popfd				;
	ret
int15hrundown	endp
;
; Emulate a block move
;
emuint15h	proc
	cmp	al,EMUP_GENERAL		; Make sure we want to do this
	jnz	emuint15out		; Nope, get out
	mov	esi,[source]		; Get source
	mov	edi,[dest]		; Get dest
	mov	ecx,[count]		; Get count
	push	ds			; Save segs
	push	es			;
	push	fs			; Point segs at absdata
	pop	ds			;
	push	fs			;
	pop	es			;
	mov	ebx,ecx			; Get low two bits of count
	shr	ecx,2			; Set for MOVSD
	rep	movsd			; Do it
	mov	ecx,ebx			; Get low two bits
	and	ecx,3			;
	rep	movsb			; Move the odd bytes
	pop	es			; Restore segs
	pop	ds
emuint15out:
	ret
emuint15h	endp
SEG386	ends
	end