;
; What this program does:
; ----------------------
;
; SENDCODE.COM takes ASCII bytes (in hex) from its command line
; and sends the bytes to STDOUT. Note all the DOS output redirections
; can be used with this program, and the program is case-insensitive.
; The redirections allow sending an arbitrary sequence of bytes
; (max. about 40 ASCIIhex bytes) to be sent, for instance, to the
; printer port to set a desired mode.
;
; EXAMPLE (with ANSI.SYS installed): SENDCODE 1b 5B 32 4a
;		sends the sequence <ESC>[2J to stdout, which clears the screen
;		and leaves the cursor in the home position. Note 'b' == 'B'.
;
; Program History and Attributions:
; --------------------------------
;
;	This MASM version of SENDCODE was derived from a DEBUG script printed
;	in the User-to-User article of the September 27, 1988 issue of
;	PC Magazine. The original submission to the magazine was from Mike S.
;	O'Donnell of Worthington, Ohio. Mr. O'Donnell's program sent bytes
;	directly to the printer port. The author of the magazine article took
;	Mr. O'Donnell's suggestion to use STDOUT instead of PRN, and modified
;	the code, which then became the script printed in the article.
;
;	The DEBUG script author is Salvatore P. Ricciardi.
;	The entire contents of the Sept. 27, 1988 issue of PC Magazine is
;	Copyright (C) 1988 by Ziff-Davis Publishing Co., a division of
;	  Ziff Communications Co.
;
;	This MASM version adds comments, jump labels, and a check for DOS
;	versions earlier than 2.0.
;
; Motivation for using this program:
; ---------------------------------
;
;	I use the installable ANSI device driver so that I can send escape
;	sequences to the console to set the foreground and background colors,
;	and use escape sequences in my DOS command line prompt. My previous
;	method was to create a number of different text files each containing
;	an escape sequence sent to the console using the TYPE command in a
;	batch file. Each text file was no more than about 10 bytes long, which
;	is really a terrible waste of disk space given that my cluster size
;	is 4,096 bytes! (For the uninitiated, a cluster is the smallest unit of
;	disk space allocated by DOS)
;
;	With this program, I can at least bury the sequences in my batch files,
;	which also are much shorter than a cluster. I can essentially reduce
;	the filesystem fragmentation slightly.
;
; The source code for the program:
; -------------------------------
;
CMDLoffs	EQU	81h	; offset into PSP where command line begins
;
CSEG	SEGMENT
	ASSUME CS:CSEG, DS:CSEG
;
	ORG	100h	; use .COM memory layout
;
START:	mov	AH, 30h
	int	21h	; INT 21h service 30h: Get DOS Version Number
	cmp	AL, 2	; Major version returned in AL, Minor in AH
	jb	OLDext	; Exit if not at least Version 2.0
;
	mov	BX, CMDLoffs	; register int BX = CMDLoffs,
	mov	CL, 4		; CL = 4,
	xor	DL, DL		; DL = 0
;
getch:	mov	AL, [BX]	; DS:[BX] points to command line char in PSP
	cmp	AL, 0Dh
	je	fini		; command line is terminated by a <CR> (0Dh)
;
	cmp	AL, 30h
	jb	nextch
	cmp	AL, 39h
	jbe	convt		; char is in [0-9], convert hex nibble
;
	and	AL, 0DFh	; make [A-F, a-f] case-insensitive
;
	cmp	AL, 41h
	jb	nextch
	cmp	AL, 46h
	ja	nextch
;
	sub	AL, 7		; char is in [A-F], shift 'A' to 3Ah.
				; 3Ah == '9' + 1 == 39h + 1
;
convt:	sub	AL, 30h		; convert ASCIIhex digit to nibble
	rol	AL, CL		; advance first digit to upper nibble when
				; CL == 4, otherwise this is a NOP
;
	add	DL, AL		; accumulate nibble
	cmp	CL, 0
	jne	setCL		; get lower nibble if CL == 4
	mov	AH, 02h
	int	21h	;INT 21h service 02h: Output Character to STDOUT
			; character byte is in DL, output to device if
			; output has been redirected (Version 2.0+)
	xor	DL, DL
setCL:	xor	CL, 4		; toggle CL between CL == 0 and CL == 4
;
nextch:	inc	BX		; move pointer to next command line char
	jmp	getch
;
fini:	mov	AX, 4C00h
	int	21h	; INT 21h service 4Ch: Process Terminate
			; AL contains return code which can be examined by
			; using the ERRORLEVEL variable in a batch file.
;
OLDext:	int	20h	; terminate DOS Version 1.x process. Does not allow
			; passing a return code to DOS. Don't trust possibly
			; redirected error message will be seen, so no error
			; message is printed.
;
CSEG	ENDS
;
	END	START

