/********************************************************************
		PopTEST  (c) Copyright 1989 by MSI
		     Author - Ratko V. Tomic
*********************************************************************/

#include "cr.h"
#include "sio.h"

#ifdef PDK1
#include "lm.h"
#include "sr.h"
#else
#define _even_heap() _heap=(char*)(((word)_heap+1)&0xFFFE)
#endif

#include "spawn.h"

#define MK_FP(seg,ofs)	((void far *)(((dword)(seg)<<16)|(word)(ofs)))

/** STARTUP DATA are in XID.C  (discarded in resident mode) **/

extern char loaded_msg[],hello_msg[]; /* Startup messages */
extern char hello_atr[],hello_atr1[];
extern char unloading[],not_loaded[],no_unl[];

extern word init_data_end;	/* Marks end of init-data */
extern word parent_code;	/* Code segment if already loaded */

#define UNL_KEY (M_LC|M_LS|0x16)	/* Ctl-Shift-U */

/********** USED FOR SPAWN ******************************************/
extern char img_file[];		/* Disposable memory swap file name */
extern int img_hndl;		/* Permanent data file/lim handle */
extern word lim_seg;		/* Used only if LIM available */
extern dword lfpos;		/* LIM or file position for graph image*/
extern word MinP,MaxP;		/* Minimum/Maximum paragraphs to use */
extern char prog[],cmd_ln[];	/* Fill in command line and program */
extern char *shell_ptr;		/* Default SHELL */
extern word *scr_buf;		/* Screen buffer */
extern char *tmp_buf;		/* Temporary buffer */
extern word cmd_env;		/* Environment passed to spawn() */
extern char run_it;		/* Set to NZ if no questions asked on F11 */
/*********************************************************************/

/** RESIDENT CODE STACK SPACE **/

#define STK_SZ (128)	  /* Size in words */
word res_stack[STK_SZ+1]; /* Allow allways extra word ! */

extern isr();		/* Interrupt service in X.C */
extern word hk_list[];  /* This is in X.C for use by isr() function */


/** Display Signon screen **/

signon()
{
  int x0,y0,x1,y1;
  char *a=hello_atr;

   if (vid_mode==7)
	a=hello_atr1;
   x0=crs_x=12; y0=crs_y=3;
   vid_atr=7; fil_scr('');
     dspf(hello_msg,a);
   x1=crs_x; y1=crs_y+1;
   vid_atr=7;
   crs_y=y0+1; dsp_ver(0x20,y1-y0);
   crs_x++; crs_y=y0+1; dsp_ver(0x20,y1-y0);
   crs_x=x0+3;crs_y=y1; dsp_hor(0x20,x1-x0-1);
   crs_x=0; crs_y=24;
   vid_atr=7; clr_eol();
   crs_y--; mv_crs();
}

/** PARSE COMMAND LINE **/

char *cpy_tok(char *src,char *dest,int max)
{ register char *s=src,*d=dest;
   while (*s>0x20 && --max>=0) *d++=*s++;
   return(s);
}

parse_cmd_ln()
{ register char *s=cmd_line;
  word n;
  char *endl;
     endl=s+str_len(s);
     while (*s && s<endl && s>=cmd_ln )
	{
	if (*s++!='/') continue;
	if (!*s) continue;
	n=(*s++ | 0x20);
	switch (n) {
	  case 'm':	s=dec2w(s,&n);
			if (n>640 || n<16 ) break;
			MaxP=MinP=n*(1024/16)+1;
			break;
	  case 'q':	run_it|=0x80;
	  case 'g':     run_it|=1;
			break;
	  case 'p':	;
	  case 'f':	s=cpy_tok(s,prog,64); break;
	  case 'c':	strncpy(cmd_ln+2,s,64);
			*(word*)(cmd_ln+str_len(cmd_ln))=0xd;
			return(0);
	  case 'u':	return(n);
	  }
	}
     return(0);
}


extern char cmd_pref[],dflt_shell[];

get_comspec()
{ char far *e;
  register char *s;
  register int n;
  char *sh=dflt_shell;
     n=str_len(cmd_pref);
     e=MK_FP(_env,0);
     do {
	s=_heap;
	do *s=*e++; while (*s++);
	s=_heap;
	if (mem_cmp(s,cmd_pref,n)==n)
	  {
	  sh=s+n; break;
	  }
	}
     while (*e);
     s=shell_ptr=_heap;
     _heap+=str_cp(sh,s)+1;
}

/******* INITIALIZATION *******/


main()
{ int unl_req;
  int h2;		/* Second LIM handle */

  signon();
  unl_req= parse_cmd_ln();	/* Extract memory size & default application */

  if (second_load()) 		/* Check if program already loaded */
	{
	if (unl_req)
	   {
	   if (!remove_tsr())
		{
		dspf(no_unl);	/* Can't unload - other TSR took our */
		return(1);	/* interrupt vector.		     */
		}
#ifdef PDK1
	   h2=*(int far*)MK_FP(parent_code,8); /* Get other LIM handle */
	   if (h2!=-1) lim_dealloc(h2);	       /* Release it if LIM used */
#endif
	   fdelete(img_file);	/* Delete swap file (if found) */
	   dspf(unloading);
	   }
	else dspf(loaded_msg);	/* If so, display error message  */
	return(1);		/* Exit to DOS with errorlevel 1 */
	}
   else if (unl_req) 
	{
	dspf(not_loaded);
	return(1);
	}

/******* ENABLE RESIDENT OPERATION *********************************/

  idata_end=&init_data_end;	/* This enables init data disposal. */
  icode_beg=signon;		/* This enables init code disposal. */

  stay_resident(res_stack,STK_SZ*2);	/* Define TSR stack */
  install_hk(hk_list,isr,STK_SZ*2,3);	/* Enable HOT-KEY services */

/******** INITIALIZE SWAP FILE/LIM FOR SPAWN **************************/

    get_comspec();	/* Extract COMMAND.COM path from Environment */
    tmp_buf=_heap;
    _heap += mouse_size>128 ? mouse_size: 128; /* Reserva Mouse-save area */

    cmd_env=get_master_env();		/* Get ENVIRONMENT TO USE */
    if (!cmd_env) keep_env();		/* Use ours if no master_env */


#ifdef PDK1	/* Acquire LIM pages (requires PDK-1: K1.LIB) */

{ word min_pages,max_pages,nfree,mp;

    if (!lim_present()) goto FileOnly; /* Check if LIM board present */
    move_to_lim(1,1,MOVE_BOTH);		/* Load TSR into LIM as well */
    mp=(mouse_size+0xf)>>4;		/* Space to save mouse state */
    min_pages = 17+((MinP+1)+mp+0x3FF)/0x400;    /* Minimum pages necessary */
    max_pages = 17+((MaxP+1)+mp+0x3FF)/0x400;   /* Maximum pages necessary */
    nfree=lim_nfree();			/* Get # of free pages */
    
    if (lim_error) goto FileOnly;
    if (nfree<min_pages) goto FileOnly;   /* Don't use LIM if too small */
    if (nfree<max_pages) max_pages=nfree; /* Else alloc max possible */
    img_hndl=lim_alloc((int)max_pages);	/* Allocate pages */
    if (lim_error) goto FileOnly;
    lim_seg=lim_window();		/* Enable LIM saving of image */
    lfpos=max_pages-17;
    h2=img_hndl;			/* Used to remove_tsr() */
    if (!lim_error) goto LimOnly;
    lim_dealloc(img_hndl);		/* Release LIM on error */
}
#else	/**** If no PDK-1 reserve 4K for screen save ****/

    _even_heap();
    scr_buf=(word*)_heap;
    _heap+=80*25*2;

#endif

FileOnly:
  h2=-1;			/* Value -1 is used for file swapping */
  lim_seg=0;			/* Disable LIM use */
  img_hndl=fcreate(img_file,0);	/* Create application mem. swap file */
  if (io_error) exit(1);	/* Don't go TSR if bad image file    */
  lfpos=(((dword)MaxP+1)<<4)+mouse_size;/* Init file pos for graphics image */
LimOnly:

  *(int far*)MK_FP(_ccode,8)=h2; /* Save so it can be released later */
				 /* config block ptr in R0.ASM reused */
/*********************************************************************/
  
  return(0);				/* Exit code 0=Ok exit */

}
