/* bm.h -- definitons for bm.c that aren't included elsewhere */

/* types of config file lines that we know how to handle */
#define NONE		0
#define MAXLET		1
#define SMTP		2
#define HOST		3
#define USER		4
#define EDIT		6
#define NAME		7
#define REPLY		8
#define MBOX		9
#define RECORD		10
#define FOLDER		11
#define MQUEUE		12
#define ALIAS		13
#define AUTOEDIT	14
#define ZONE		15
#define PAGER		16
#define ASKSUBJECT	17
#define ASKMSGTYPE	18
#define DELEMPTY	19
#define GATE		20
#define ORGAN		21
#define ASKRECORD	22
#define TMPDIR		23
#define VIA		24
#define ASKVIA		25
#ifdef UNIX
#define MAILEXT		26
#define SYSTEMLOCK	27
#endif

#define RUNCOM	"\\bm.rc"       /* config file */

#define WORK	"*.wrk"         /* work file type */
#define MAXROWS		25	/* number of lines on display */
#define MAXCOL		80	/* number of lines on display */

/* message status */
#define DELETE	1
#define READ	2

#define NLET	300		/* default size of letter array */
#define MAXARGS 16

#define LINELEN		256
#define XLINELEN	300
#define XXLINELEN	600

/* a mailbox list entry */
struct let
{
  long		start;
  long		size;
  int		status;
};

/* address structure */
struct addr
{
  struct addr  *next;
  char	       *user;
  char	       *host;
  int		sent;
};

/* token used for a string and its token */
struct token
{
  char	       *str;
  char		type;
};

/* global definitions */
extern char
	     *hostname,		/* name of this host from rc file */
	     *username,		/* name of this user from rc file */
	     *fullname,		/* name of this user from rc file */
	     *replyto,		/* return address from reply-to */
	     *maildir,		/* default mail directory */
	     *editor,		/* user's favorite editor program */
	     *pager,		/* pager */
	     *gate,		/* gate to send default mail to */
	     *organ,		/* organization name */
	     *savebox,		/* user's mbox for the s command */
	     *record,		/* place to store a copy of snet mail for you */
	     *folder,		/* directory used for save and write commands */
	     *mfilename;	/* for the -f option */

extern unsigned maxlet;		/* max messages */
extern int    current;		/* the current message number */
extern int    nmsgs;		/* number of messages in this mail box */
extern int    newmsgs;		/* number of new messages in mail box */
extern int    change;		/* mail file changed */
extern FILE  *mfile;		/* mail data file pointer */
extern int    tty;		/* is standard in a tty ? */
extern int    fflag;		/* true if current notefile is not an mbox */
extern int    qflag;		/* just queue no headers */
extern int    sflag;		/* ask for subject */
extern int    tflag;		/* ask for msgtype */
extern int    vflag;		/* ask for via route */
extern int    eflag;		/* autoedit */
extern int    rflag;		/* no recording */
extern int    lflag;		/* list to addresses */
extern int    dflag;		/* delete empty notefile */
extern int    novia;		/* don't use via */
extern int    aflag;		/* don't add sender addr to work file */
extern int    recflag;		/* ask for sender copy */
extern int    mlock(  ), rmlock(  );
extern struct addr *make_tolist(  );
extern long   get_msgid(  );
extern char   mailqdir[];
extern char   mailspool[];
extern char  *emname;
extern char   tempdir[];
extern char  *mqueue;
extern char  *tmpdir;
extern char   alias[];
extern char  *aliases;
extern char  *tzone;
extern char  *via;
extern char   notename[];
extern char   unotename[];
extern char   notefile[];
extern char   nomail[];
extern char   nofile[];
extern char   badmsg[];
extern char   badcommand[];
extern char   newmail[];
extern char   nopattern[];
extern char   deadmsg[];
extern struct let *mbox;
extern char  *fgets(  ), *savestr(  );
extern void   exit(  ), perror(	 );
extern int    parse(  ), htype(	 );
extern int    getrch(  ), isnewmail(  );
extern char  *gets(  );

/* Define null object pointer in case stdio.h isn't included */
#ifndef NULL
/* General purpose NULL pointer */
#define NULL (void *)0
#endif
#define NULLCHAR (char *)0	/* Null character pointer */
#define NULLFP	 (int (*)())0	/* Null pointer to function returning int */
#define NULLVFP	 (void (*)())0	/* Null pointer to function returning void */
#define NULLFILE (FILE *)0	/* Null file pointer */
#define NULLADDR (struct addr *)0	/* Null address */
