#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <process.h>
#include "bm.h"

char	      tpgpin[LINELEN];
char	      tpgpout[LINELEN];

void
pgp_ini( void )
{
  strcpy( tpgpin, tmpdir );
  strcat( tpgpin, "\\pgpin.$$$" );
  strcpy( tpgpout, tmpdir );
  strcat( tpgpout, "\\pgpout.$$$" );
}

void
pgp_err( int pgperr )
{
  char	       *s;

  if ( pgperr == 0 )
    return;
  if ( pgperr == -1 )
  {
    switch ( errno )
    {
      case E2BIG:
	s = "Argument list or environment list too big";
      case EINVAL:
	s = "Invalid 'modeflag' argument";
      case ENOENT:
	s = "PGP.EXE not found or PGPPATH variable not set";
      case ENOEXEC:
	s = "PGP.EXE is not an executable file";
      case ENOMEM:
	s = "Not enough memory to run PGP";
    }
    printf( "\r\n%s\r\n", s );
  }
  else
  {
    switch ( pgperr )
    {
      case 0:
	s = "exit ok";
      case 1:
	s = "invalid file";
      case 2:
	s = "file not found";
      case 3:
	s = "unknown file";
      case 4:
	s = "no batch";
      case 5:
	s = "bad argument";
      case 6:
	s = "interrupt";
      case 7:
	s = "out of memory";
/* keyring errors: base value = 10 */
      case 10:
	s = "key generation";
      case 11:
	s = "nonexist key";
      case 12:
	s = "keyring add";
      case 13:
	s = "keyring extract";
      case 14:
	s = "keyring edit";
      case 15:
	s = "keyring view";
      case 16:
	s = "keyring remove";
      case 17:
	s = "keyring check";
      case 18:
	s = "key signature";
      case 19:
	s = "keysig remove";
/* encode errors: base value = 20 */
      case 20:
	s = "signature";
      case 21:
	s = "RSA encryption";
      case 22:
	s = "encrypt";
      case 23:
	s = "compress";
/* decode errors: base value = 30 */
      case 30:
	s = "signature check";
      case 31:
	s = "RSA decryption";
      case 32:
	s = "decrypt";
      case 33:
	s = "decompress";
      default:
	s = "unknown";
    }
    printf( "\r\nPGP has returned a %s error\r\n", s );
  }
  printf( "No encryption/decryption done... press any key\r\n" );
  getch(  );
}

int
send_pgp( char *ln, FILE * fin, FILE * fout, char *user )
{
  FILE	       *fpgp;
  char	       *to_pgp_usr, *s;
  int		pgperr;

  if ( strncmp( ln, "[pgp on", 7 ) == 0 )
  {
    s = ln + 7;
    while ( *s == ' ' || *s == '\t' )
      s++;
    if ( *s == ']' || *s == '\n' )
      to_pgp_usr = strdup( user );
    else
    {
      to_pgp_usr = strdup( s );
      s = to_pgp_usr;
      while ( *s != ' ' && *s != '\t' && *s != ']' && *s != '\n' )
	s++;
      *s = '\0';
    }
    if ( ( fpgp = fopen( tpgpin, "wt" ) ) != NULLFILE )
    {
      while ( ( fgets( ln, XLINELEN, fin ) ) != NULLCHAR )
	if ( strncmp( ln, "[pgp of", 7 ) != 0 )
	  fputs( ln, fpgp );
	else
	  break;
      fclose( fpgp );
      strcpy( ln, getenv( "PGPPATH" ) );
      strcat( ln, "\\pgp.exe" );
      pgperr = spawnl( P_WAIT, ln, "pgp", "-esat",
		       "-o", tpgpout, tpgpin, to_pgp_usr, NULL );
      free( to_pgp_usr );
      if ( pgperr || ( fpgp = fopen( tpgpout, "rt" ) ) == NULLFILE )
	fpgp = fopen( tpgpin, "rt" );
      while ( ( fgets( ln, XLINELEN, fpgp ) ) != NULLCHAR )
	fputs( ln, fout );
      fclose( fpgp );
      pgp_err( pgperr );
      unlink( tpgpin );
      unlink( tpgpout );
    }
  }
  else if ( fputs( ln, fout ) == EOF )
    return 1;
  return 0;
}

int
recv_pgp( char *ln, FILE * fin, FILE * fout, struct let * cmsg )
{
  FILE	       *fpgp;
  int		pgperr;
  char		lstr[LINELEN];
  char	       *s;

  if ( strncmp( ln, "-----BEGIN PGP", 14 ) == 0 )
  {
    if ( ( fpgp = fopen( tpgpin, "wt" ) ) != NULLFILE )
    {
      fputs( ln, fpgp );
      do
      {
	if ( fgets( ln, LINELEN, fin ) == NULLCHAR )
	  break;
	fputs( ln, fpgp );
      } while ( strncmp( ln, "-----END PGP", 12 ) != 0 );
      fclose( fpgp );
      strcpy( lstr, getenv( "PGPPATH" ) );
      strcat( lstr, "\\pgp.exe" );
      pgperr = spawnl( P_WAIT, lstr, "pgp", "-p",
		       "-o", tpgpout, tpgpin, NULL );
      if ( pgperr || ( fpgp = fopen( tpgpout, "rt" ) ) == NULLFILE )
	fpgp = fopen( tpgpin, "rt" );
      if ( !pgperr )
      {
	s = "[pgp on]\n";
	cmsg->size += strlen( s );
	fputs( s, fout );
      }
      while ( fgets( ln, LINELEN, fpgp ) != NULLCHAR )
      {
	cmsg->size += strlen( ln );
	fputs( ln, fout );
      }
      if ( !pgperr )
      {
	s = "[pgp off]\n";
	cmsg->size += strlen( s );
	fputs( s, fout );
      }
      fclose( fpgp );
      change = 1;
      unlink( tpgpin );
      unlink( tpgpout );
      pgp_err( pgperr );
    }
    else
    {
      printf( "Unable to create PGP tmp file\r\n" );
      printf( "Message left encrypted... press any key\r\n" );
      getch(  );
    }
    return 1;
  }
  else
    return 0;
}
