/* Rebuild the history file */

/* Written by Bernie Roehl, May 1990 */

/* Works with the NNTPCLI by Anders Klemets and Bernie Roehl */

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>

char *progname = "HISBUILD";

void main(argc, argv)
int argc;
char *argv[];
	{
	FILE *hist;
	void walk_dirs();
	char buff[100];
	if (argc != 3) {
		printf("%s: Correct usage is 'hisbuild spooldir newsdir'\n", progname);
		exit(2);
		}
	if (mlock(argv[2], "history")) {
		printf("%s: Could not lock history file '%s\\history'\n", progname, argv[2]);
		exit(1);
		}
	sprintf(buff, "%s/history", argv[2]);
	if ((hist = fopen(buff, "w")) == NULL) {
		printf("%s: Could not open history file '%s'\n", progname, buff);
		rmlock(argv[2], "history");
		exit(3);
		}
	walk_dirs(argv[1], hist);
	fclose(hist);
	rmlock(argv[2], "history");
	exit(0);
	}

void walk_dirs(char *dir, FILE *hist)
	{
	char work[100];
	struct ffblk ff;

	sprintf(work, "%s/*.txt", dir);
	if (findfirst(work, &ff, 0) == 0)
		do {
			FILE *tmpf;
			sprintf(work, "%s/%s", dir, ff.ff_name);
			if ((tmpf = fopen(work, "r")) == NULL) {
				printf("%s: Could not open '%s'\n", progname, work);
				continue;
				}
			while (fgets(work, sizeof(work), tmpf))
				if (!strnicmp(work, "Message-ID:", 11)) {
					char *p;
					for (p = &work[11]; *p; ++p)
						if (!isspace(*p))
							break;
					fputs(p, hist);
					}
			fclose(tmpf);
			} while (findnext(&ff) == 0);

	sprintf(work, "%s/*.*", dir);
	if (findfirst(work, &ff, FA_DIREC) == 0)
		do {
			if (ff.ff_name[0] != '.') {
				sprintf(work, "%s/%s", dir, ff.ff_name);
				walk_dirs(work, hist);
				}
			} while(findnext(&ff) == 0);
	}

mlock(char *dir, char *id)  /* from KA9Q */
	{
	char lockname[80];
	int fd;

	/* Try to create the lock file in an atomic operation */
	sprintf(lockname,"%s/%s.lck",dir,id);
#ifdef        AMIGA
	/* don't ask, really, just don't ask... I'd do file locking on
	 * an Amiga much more differently than this.
	 */
	if(access(lockname, 0) == 0)
		return -1;
#endif
	if((fd = open(lockname, O_WRONLY|O_EXCL|O_CREAT,0600)) == -1)
		return -1;
	close(fd);
	return 0;
	}

rmlock(char *dir, char *id)  /* from KA9Q */
	{
	char lockname[80];
	sprintf(lockname,"%s/%s.lck",dir,id);
	return(unlink(lockname));
	}

