{ͻ}
{      -- THIS FILE IS PART OF THE LIVESYSTEMS COMPRESSOR TOOLBOX. --      }
{          ALL RIGHTS RESERVED  (C) COPYRIGHTED G. HOOGTERP 1994           }
{                                                                          }
{             See the documentation for details on the license.            }
{                                                                          }
{ͼ}

Unit FRAME;
Interface
Uses BSC;

Type FRAMEObject = Object(BasicCompressorObject)
       Constructor FRAMEInit;
       Procedure FindFirstEntry;   Virtual;
       Procedure FindNextEntry;    Virtual;
       Procedure CheckProtection;  Virtual;
       Function IsThisTypeFile(Var B ;Size : Word):Boolean; Virtual;
     End; {Object}

     FRAMEPtr = ^FRAMEObject;

Implementation

Var F   : File;
{    Buf : LocalHeader;}

Constructor FRAMEObject.FRAMEInit;
Begin
Init;
Platform:=ID_IBM;
CompressorType:='FRAME';
CompressorName:='';
Magic:=0;  { A unique number within the toolbox. Check the STRUCS.PAS }
End;



Procedure FRAMEObject.FindFirstEntry;
Begin
SetFileMode(ReadOnly+ShareDenyNone);
Assign(F,FileName);
Reset(F,1);
Seek(F,WhereInFile);
{
Find the first entry in the compressed file
}

Close(F);
ResetFileMode;
End;

Procedure FRAMEObject.FindNextEntry;
Var HeaderID : LongInt;
    ExtraTag : Word;
Begin
SetFileMode(ReadOnly+ShareDenyNone);
Assign(F,FileName);
Reset(F,1);
Seek(F,WhereInFile);
{
Go to the next entry in the compressed file
}
Close(F);
ResetFileMode;
End;

Procedure FRAMEObject.CheckProtection;
Var Old : LongInt;
Begin
Old:=WhereInFile;
BeQuick:=True;

FindFirstEntry;
While Not LastEntry Do
 FindNextEntry;

BeQuick:=False;
WhereInFile:=Old;
LastEntry:=False;
End;

Function FRAMEObject.IsThisTypeFile(Var B ;Size : Word):Boolean;
Begin
FRAMEInit;  { Reinit the current object }
IsThisTypeFile:=True;
{
Detect if the current file is of this type by checking the contents of
the buffer.

If The file is an selfextractor, make sure the WhereInFile variable
contains the fileposition where the compressed part of the file starts.
}
IsThisTypeFile:=False;
End;



Var CO          : FramePtr;

Begin
New(CO,FRAMEInit);   { Create an instance of this object                 }
AddToList(CO);       { Add it to the list of available compressorobjects }
End.

