{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Memory/Allocat4.pas              [x] Protected mode

  Memory allocations. This example shows how to duplicate allocations
  into new instances with the same data.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFMEMORY;


var A, B : pAllocation;
    SomeData : string;


begin
     SomeData := 'Duplication of memory allocation succeeded.';

     { Initialize a data allocation and move in some data }
     New ( A, Initialize ( SizeOf(SomeData)) );

     A^.MoveIn (@SomeData, SizeOf(SomeData), 0);

     { Duplicate allocated data into a new data allocation object }
     New ( B, Duplicate (A) );
     A^.Free; { Destruct A }

     WriteLn ( String(B^.Data(0)^) );
     B^.Free; { Destruct B }
end.