{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Search.pas               [x] Protected mode

  Demonstration of EFLIB's built in Knuth-Morris-Pratt search
  algorithm and the filter implemention. KMP is very fast.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

uses EFDEF, EFSTREAM, EFFILE, EFSEARCH;


var Searcher : pSearchFilter;
    F        : pIFile;
    Null     : pNullStream;
    Text     : string;
    I        : word;

begin
     if (ParamStr(1) = '') or (ParamStr(2) = '')
        then begin
             WriteLn ('Syntax: SEARCH <file1> <text>');
             WriteLn ('  Searchs for any text in <file1>. Returns');
             WriteLn ('  last found match and number of occurrences.');
             WriteLn ('  <text> can contain blank spaces.');
             Halt;
             end;

     Text := ParamStr(2); { Permit expressions like "search for me" }
     for I := 3 to ParamCount do
         Text := Text + ' ' + ParamStr(I);

     F        := New (pIFile, Initialize (ParamStr(1), 1024) );
     Searcher := New (pSearchFilter, Initialize (Text[1], Length(Text), F));
     Null     := New (pNullStream, Initialize);

     Searcher^.CopyOut (Null, Searcher^.Size);

     WriteLn ('The text occur ', Searcher^.Occurrences, ' times.');
     if Searcher^.IsFound
        then WriteLn ('Last match at ', Searcher^.LastMatch, '.');

     Searcher^.Free; Null^.Free;
end.