{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/TextSort.pas             [x] Protected mode

  This program demonstrates text file sorting with a ordered list
  ADT and an arbitrary (text) stream.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFFILE, EFADT, EFLIST;


const BufferSize  = 5000; { Buffer size for the data stream }

var TextFile : tFile; Text : string;
    List : tOrderedList;

begin
     if ParamStr(1) = ''
        then begin
             WriteLn ('Syntax: TEXTSORT <filename.txt>');
             WriteLn ('  This program sorts all lines in the specified text file.');
             Halt;
        end;

     { Initialize buffered file stream }
     TextFile.Initialize (ParamStr(1), BufferSize);
                          { Filename }     { Buffer size in bytes }

     { Instantiate an ordered list ADT }
     List.Initialize (SizeOf(Text));
     List.InstallPlug (New (pBoundedKeyPlug, Initialize (NIL, 1, 255)));

     while not TextFile.IsEnd do begin

           { Read text lines from the stream until
             EOL sequence occurr. Then put it into
             the list in sorted order. }

           Text := TextFile.GetLine;
           List.Store (Text);

      end;

      TextFile.Reset; { Go to position 0 }
      TextFile.Truncate; { Delete remaining text }

      while not List.IsEmpty do begin

            with List.FirstNode^.Element^ do
                 CopyOut (@Text, Size, 0);

            List.EraseFirst;
            TextFile.PutLine (Text);

      end;

      List.Intercept; { Intercept list }
      TextFile.Intercept; { Intercept stream (close file) }
end.