
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Portions Copyright (c) 1992 Borland International }

{
  GVGADGET.TXT GVGADGET.DOC GINFO.TXT NEW.TXT GV.VER
}

Unit GVGadget;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}

{ Diese Unit bietet zwei ntzliche Hilfsmittel: Uhr und Freier-Heap-Anzeiger.
}

Interface

{$ifdef Windows}
uses WinDos, Dos, Drivers, Objects, Views, GVViews, GVApp;
{$else}
Uses Dos, Drivers, Objects, Views, GVViews, GVApp;
{$endif Windows}

Type

{ THeapView object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text }

  PHeapView = ^THeapView;
  THeapView = object(TGView)
    OldMem : LongInt;
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
{   procedure DrawVisible; virtual;
    procedure DrawClipped(Clip: PVRect); virtual;}
    procedure Update;
  end;

{ TClockView object }

  { Palette layout }
  { 1 = Background }
  { 2 = Text }

  PClockView = ^TClockView;
  TClockView = object(TGView)
    Refresh: Byte;
    LastTime: DateTime;
    TimeStr: String[10];
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    function FormatTimeStr(H, M, S: Word): String; virtual;
    procedure Update; virtual;
  end;


implementation

{$ifdef Windows}
uses ExtGraph, WinGr;
{$else}
Uses MetaGr, ExtGraph, GVDriver, MyFonts;
{$endif Windows}

(******************************* THeapView object ***************************)

constructor THeapView.Init(var Bounds: TRect);
Begin
  TGView.Init(Bounds);
  OldMem := 0;
End;

procedure THeapView.Draw;
var
  S: String;
Begin
  Str(OldMem, S);
  SetFillStyle (SolidFill, GetColor (8));
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetTextParams(ftSystem, 0, GetColor(2), false);
  SetTextJustify(CenterText, CenterText);
  OutTextXY(Size.X div 2, Size.Y div 2, S);
  SetColor (Black);
  Rectangle (0, 0, Size.X-1, Size.Y-1);
End;

procedure THeapView.Update;
Begin
  If (OldMem <> MemAvail) then begin
    OldMem := MemAvail;
    DrawView
  end
End;

(******************************* TClockView object **************************)

function LeadingZero(w: Word): String;
var s: String;
begin
  Str(w:0, s);
  LeadingZero := Copy('00', 1, 2 - Length(s)) + s;
end;

constructor TClockView.Init(var Bounds: TRect);
Begin
  TGView.Init(Bounds);
  FillChar(LastTime, SizeOf(LastTime), #$FF);
  TimeStr := '';
  Refresh := 1;
End;

procedure TClockView.Draw;
Begin
  SetFillStyle (SolidFill, GetColor (8));
  Bar (0, 0, Size.X-1, Size.Y-1);
  SetTextParams(ftSystem, 0, GetColor(2), false);
  SetTextJustify(CenterText, CenterText);
  OutTextXY(Size.X div 2, Size.Y div 2, TimeStr);
  SetColor (Black);
  RectAngle (0,0,Size.X-1,Size.Y-1);
End;

procedure TClockView.Update;
var h,m,s,hund: word;
Begin
  GetTime(h,m,s,hund);
  If Abs(s - LastTime.sec) >= Refresh then
  Begin
    With LastTime do
    Begin
      Hour := h;
      Min := m;
      Sec := s;
    End;
    TimeStr := FormatTimeStr(h, m, s);
    DrawView;
  End;
End;

function TClockView.FormatTimeStr(H, M, S: Word): String;
Begin
  FormatTimeStr := LeadingZero(h)+ ':'+ LeadingZero(m) +
    ':' + LeadingZero(s);
End;

END.
