{ CVTLIB.PAS : string <-> integer conversion routine library

  Title   : CVTLIB
  Version : 5.0
  Language: Borland Pascal 7.0 (all targets), Delphi 1.0
  Date    : Nov 09,1996
  Author  : J.R. Ferguson
  Usage   : Unit
}

{$DEFINE USEASM}  { if defined: use assembler routines }

UNIT CvtLib;

INTERFACE
uses DefLib, ChrLib;


function AtoI(s: StpTyp): integer;
{ Read signed decimal integer from string s }

function AtoIB(s: StpTyp; g: integer): integer;
{ Read unsigned integer with base g (1<g<37) from string s }


function AtoL(s: StpTyp): longint;
{ Read signed decimal longint from string s }

function AtoLB(s: StpTyp; g: integer): longint;
{ Read unsigned longint with base g (1<g<37) from string s }


procedure ItoA(n: integer; var s: StpTyp);
{ Convert signed decimal integer n to string s }

procedure ItoAB(n: integer; var s: StpTyp; g: integer);
{ Convert unsigned integer n with base g (1<g<37) to string s }

procedure ItoABL(n: integer; var s: StpTyp; g,l: integer);
{ Like ItoAB, with fixed field length l, using leading zeroes }

procedure ItoABLS(n: integer; var s: StpTyp; g,l: integer);
{ Like ItoAB, with fixed field length l, using leading spaces }


procedure LtoA(n: longint; var s: StpTyp);
{ Convert signed decimal longint n to string s }

procedure LtoAB(n: longint; var s: StpTyp; g: integer);
{ Convert unsigned longint n with base g (1<g<37) to string s }

procedure LtoABL(n: longint; var s: StpTyp; g,l: integer);
{ Like LtoAB, with fixed field length l, using leading zeroes }

procedure LtoABLS(n: longint; var s: StpTyp; g,l: integer);
{ Like LtoAB, with fixed field length l, using leading spaces }



IMPLEMENTATION

{ --- Local routines --- }

function CvtDigChr(i: integer): char;
begin if i>9 then CvtDigChr:= chr(i+55) else CvtDigChr:= chr(i+48) end;

procedure CvtUDiv(t,n: integer; var q,r: integer); { n <> 0 }
{$IFDEF USEASM}
begin asm
	mov	ax,t	{ DX:AX = t }
	xor	dx,dx
	div	n	{ divide t/n, quotient in AX, remainder in DX }
	les	di,q
	mov	[es:di],ax
	les	di,r
	mov	[es:di],dx
end; end;
{$ELSE}
var i : 0..15;
begin
  r:= 0; q:= t;
  for i:= 0 to 15 do begin
    r:= r shl 1; if q<0 then Inc(r); q:= q shl 1;
    if r>=n then begin Dec(r,n); Inc(q); end
  end
end;
{$ENDIF}

procedure CvtULDiv(    t: longint;     { numerator }
                       n: integer;     { denominator  <> 0 }
                   var q: longint;     { quotient  }
                   var r: integer);    { renainder }
{$IFDEF USEASM}
begin asm
	xor	bx,bx		{ BX   =r := 0; }
	mov	ax,word(t)	{ DX:AX=q := t; }
	mov	dx,word(t+2)
	mov	di,n		{ DI   =n }

	mov	cx,32		{ for i:= 0 to 31 do begin }
@1:	shl	bx,1		{   r:= r shl 1; }
	and	dx,dx		{   if q < 0 then }
	jns	@2
	inc	bx		{     Inc(r); }
@2:     shl	ax,1		{   q:= q shl 1; }
	rcl	dx,1
	cmp	bx,di		{   if r >= n then begin }
	jb	@3
	sub	bx,di		{     Dec(r,n); }
	add	ax,1		{     Inx(q); }
	adc	dx,0
@3:				{   end; }
	loop	@1		{ end; }

	les	di,q
	mov	[es:di],ax
	mov	[es:di+2],dx
	les	di,r
	mov	[es:di],bx
end; end;
{$ELSE}
var i : 0..31;
begin
  r:= 0; q:= t;
  for i:= 0 to 31 do begin
    r:= r shl 1; if q<0 then Inc(r); q:= q shl 1;
    if r>=n then begin Dec(r,n); Inc(q) end
  end
end;
{$ENDIF}


{ --- Library routines --- }


function AtoL(s: StpTyp): longint;
var c   : char;
    i   : StpInd;
    l   : StpInd absolute s;
    n   : longint;
    plus: boolean;

  function NxtChr(var c: char): char;
  const NULL: char = ^@;
  begin if i=l then c:= NULL else begin i:= i+1; c:= s[i] end; NxtChr:= c end;

begin {AtoL}
  i:= 0; n:= 0; plus:= true;
  while IsSpace(NxtChr(c)) do ;
  if c in ['+','-'] then begin plus:= c='+'; c:= NxtChr(c) end;
  while IsDigit(c) do begin n:= 10*n-(ord(c)-48); c:= NxtChr(c) end;
  if plus then AtoL:= -n else AtoL:= n
end;

function AtoLB(s: StpTyp; g: integer): longint;
var c : char;
    i : StpInd;
    l : StpInd absolute s;
    d : integer;
    n : longint;

  function NxtChr(var c: char): char;
  const NULL: char = ^@;
  begin if i=l then c:=NULL else begin i:=i+1; c:=s[i] end; NxtChr:=c end;

  function DigVal(c:char; var d: integer): boolean;
  begin
    if IsXDigit(c) then begin
      if c > '9' then d:= ord(UpCase(c))-55 else d:= ord(c) - 48;
      DigVal:= d < g
    end
    else DigVal:= false
  end;

begin {AtoLB}
  if (g>1) and (g<37) then begin
    i:= 0; n:= 0;
    while IsSpace(NxtChr(c)) do ;
    while DigVal(c,d) do begin n:= g*n + d; c:= NxtChr(c) end;
    AtoLB:= n;
  end
  else AtoLB:= 0;
end;

procedure LtoAB(n: longint; var s: StpTyp; g: integer);
var r: integer;
begin
  s:= '';
  if (g>1) and (g<37) then repeat
    CvtULDiv(n,g,n,r); Insert(CvtDigChr(r),s,1);
  until n=0;
end;

procedure LtoABL(n: longint; var s: StpTyp; g,l: integer);
var r: integer;
begin
  s:= '';
  if (g>1) and (g<37) then while l>0 do begin
    CvtULDiv(n,g,n,r); Insert(CvtDigChr(r),s,1); Dec(l);
  end;
end;

procedure LtoABLS(n: longint; var s: StpTyp; g,l: integer);
var i: StpInd;
begin
  LtoABL(n,s,g,l);
  i:= 1;
  while (i < l) and (s[i] = '0') do begin s[i]:= ' '; Inc(i); end;
end;

procedure LtoA(n: longint; var s: StpTyp);
begin
  if n<0 then begin LtoAB(-n,s,10); Insert('-',s,1) end else LtoAB(n,s,10)
end;



function AtoI(s: StpTyp): integer;
begin AtoI:= integer(AtoL(s) and $FFFF) end;

function AtoIB(s: StpTyp; g: integer): integer;
begin AtoIB:= integer(AtoLB(s,g) and $FFFF) end;

procedure ItoAB(n: integer; var s: StpTyp; g: integer);
var r: integer;
begin
  s:= '';
  if (g>1) and (g<37) then repeat
    CvtUDiv(n,g,n,r); Insert(CvtDigChr(r),s,1);
  until n=0;
end;

procedure ItoABL(n: integer; var s: StpTyp; g,l: integer);
var r: integer;
begin
  s:= '';
  if (g>1) and (g<37) then while l>0 do begin
    CvtUDiv(n,g,n,r); Insert(CvtDigChr(r),s,1); l:= l-1;
  end;
end;

procedure ItoABLS(n: integer; var s: StpTyp; g,l: integer);
var i: StpInd;
begin
  ItoABL(n,s,g,l);
  i:= 1;
  while (i < l) and (s[i] = '0') do begin s[i]:= ' '; Inc(i); end;
end;

procedure ItoA(n: integer; var s: StpTyp);
begin
  if n<0 then begin ItoAB(-n,s,10); Insert('-',s,1) end else ItoAB(n,s,10)
end;

END.
