; Title 	: MNUL86.ASM
; Version	: 6.0
; Date  	: Nov 09,1996
; Author	: J R Ferguson
; Language	: Intel 8068/8088 assembler
; O.S.		: MS-DOS v3.2
; Assembler	: Borland Turbo Assmebler v1.0, Ideal Mode
; Usage		: Routine library for .ASM programs generated with MNUGEN

	ideal
	model	small
	%pagesize 72,132


BS	equ	08h	;bakckspace
CR	equ	0dh	;carriage return
LF	equ	0ah	;line feed

	dataseg

crtxt	db	' CR:',0

	codeseg

public	Mnu_ClrScr
;
;Clear screen
;
proc	Mnu_ClrScr
	mov	ax,0600h	;BIOS clear screen
	mov	bh,07h		;display attribute
	mov	cx,0000h	;start row 00,col 00
	mov	dx,184Fh	;end   row 24,col 79
	int	10h
	mov	dx,0000h	;set cursor row 0,col 0
;proceed with Mnu_SetCur


public	Mnu_SetCur
;
;Set cursor to row DH, col DL
;
label	Mnu_SetCur proc
	mov	ah,02h		;BIOS set cursor
	mov	bh,0		;video page 0
	int	10h
	ret
endp


public	Mnu_PutChr
;
;Output character in AL to TTY (adding LF after CR)
;
proc	Mnu_PutChr
	mov	ah,0Eh		;BIOS TTY out char
	mov	bx,0007h	;page 0, normal attrib
	int	10h
	cmp	al,CR		;add LF after CR
	jne	putc1
	push	ax
	mov	al,LF
	int	10h
	pop	ax
putc1:	ret
endp


public	Mnu_PutTxt
;
;Output ASCIIZ string DS:SI to TTY
;
proc	Mnu_PutTxt
	cld			;direction upward
putt1:	lodsb			;get character
	cmp	al,0		;check for end of text
	je	putt2
	call	Mnu_PutChr
	jmp	short putt1	;next character
putt2:	ret
endp


public	Mnu_GetChr
;
;Get keyboard character in AL
;
proc	Mnu_GetChr
getc1:	mov	ah,00h		;BIOS read keyboard
	int	16h
	cmp	al,0		;ignore extended codes
	je	getc1
	cmp	al,'a'		;make upper case
	jb	getc2
	cmp	al,'z'
	ja	getc2
	sub	al,'a'-'A'
getc2:	ret
endp


public	Mnu_GetChrEch
;
;Get keyboard character in AL, echo if printable
;
proc	Mnu_GetChrEch
	call	Mnu_GetChr
	cmp	al,' '		;check if printable
	jb	getce1;
	cmp	al,'~';
	ja	getce1;
	push	ax;
	call	Mnu_PutChr;	;echo character
	mov	al,BS;		;plus backspace
	call	Mnu_PutChr;
	pop	ax;
getce1:	ret
endp


public	Mnu_WaitCR
;
;Wait for Carriage Return
;
proc	Mnu_WaitCR
	mov	si,offset crtxt
	call	Mnu_PutTxt
wait1:	call	Mnu_GetChr
	cmp	al,CR
	jne	wait1
	call	Mnu_PutChr
	ret
endp

	end
