{ͻ
                                   SETUP                                    
 ͹
                           MOS INSTALL SHIELD v3.1                          
 ͹
  Coded by Zuul as BouFFtou as Cheveau Frdric.                            
  Source Turbo Pascal v7.00 generated by MRE (MOS Resource Editor) v2.8.    
  Contact us on MOS Home's Page - http://www.multimania.com/mos             
 ͼ}

{$M 65500,0,365520}                     {*Stack And Heap*}

Program SETUP;                          {*Program Name*}

Uses Dos,                               {*BP7 Unit DOS*}
     MOS_VESA,MOS_DEB,
     MOS_STR, MOS_BLK,
     MOS_CRT, MOS_BAS,                  {*Manage Initialisations and CRT*}
     MOS_ASM, MOS_MSE,                  {*Manage Assembler and Mouse*}
     MOS_IPX, MOS_XMS,                  {*Manage Networks and XMS Memory*}
     MOS_TOO, MOS_GAD,                  {*Manage Tools and Gadgets*}
     MOS_GFX, MOS_BMP,                  {*Manage Graphics and BMP*}
     MOS_WIN, MOS_MEN,                  {*Manage Windows and Menus*}
     MOS_WAV, MOS_VAR,                  {*Manage WAV Sounds*}
     MOS_DIR, MOS_SYS,                  {*Manage Disk and System*}
     MOS_TSK, MOS_LIS,
     MOS_EZR, MOS_GPH,
     MOS_KBD, MOS_DSK,
     MOS_COL, MOS_OCG,
     MOS_REQ, MOS_FIL,
     MOS_SWAP;                          {*Manage Requesters and Swap Disk*}

{============================================================================}

Const
    S_INIT        =13;                  {*Automate States*}
    S_LANGUAGE    =0;
    S_WELCOME     =1;
    S_REGISTER    =2;
    S_COMPONENTS  =3;
    S_PROTECT     =4;
    S_TYPEINSTALL =5;
    S_DIRECTORY   =6;
    S_FREEPLACE   =7;
    S_INSTALL     =8;
    S_README      =9;
    S_EXECUTE     =10;
    S_ERROR       =11;
    S_END         =12;

    OBLIGATORY    =0;                   {*Data Section Type*}
    OPTIONAL      =1;

    MODE_INSTALL  =0;
    MODE_UNINSTALL=1;

    MAX_STATES    =13;                  {*Maximumn of defined states*}

Var FName               :String;        {*Data Filename*}
    AppName             :String;        {*Application Name*}
    AppVersion          :String;        {*Application Version*}
    AppNameVer          :String;        {*Application Name + Version*}
    InstallPath         :String;        {*Installation Path*}
    OldFName            :String;        {*For Components Searching*}
    AIcon:Array[1..3] Of String[12];    {*Icons Array for Installation Type*}
    AState:Array[0..Max_States] Of Boolean;      {*Section has been done*}
    ASize:Array[1..3] Of Longint;       {*Size of each Installation Type*}
    InstallSize         :Longint;       {*Size for the selected installation*}
    LineRead            :Longint;       {*Current line readed*}
    QttLines            :Integer;       {*Number of lines read for a text*}
    State               :Integer;       {*Pour automate d'tat*}
    SetupMode           :Integer;       {*0=Installation, 1=UnInstall*}
    QttAuthorisations   :Integer;       {*Define number of authorisations*}
    AuthorisationCode   :String;        {*Protection : Authorisation Code*}
    Pwd1,Pwd2           :String;        {*Password Part 1 and 2*}
    InstallType         :Integer;       {*Type d'installation slectionn*}
    InstallationType    :Word;          {*Type d'installation autoriss (Bits)*}
    OldAction           :Byte;          {*Actions pour Select Install Type*}
    OldVersionsSearched :Boolean;       {*Anciennes versions recherches*}
    OldVersionsFound    :Boolean;       {*Old versions found*}
    OldDisk             :String[2];     {*Old Disk found*}
    SetInDirectory      :Boolean;       {*Exit in Program Directory*}
    DisplayCode         :Boolean;       {*Display Autentification Code*}
    PwdFound            :Boolean;       {*Password has been found*}
    Installed           :Boolean;       {*On viens de l'installer ou pas...*}
    CopyQuantity        :Integer;       {*Nombre de copie  excuter*}
    W1                  :TWindow;       {*Windows for the Process Parts*}
    LM                  :TList;
    But5                :TButton;       {*Stop Process dans Search Component*}
    StopProc            :Boolean;       {*Stop to scan disks*}
    SizeX               :Integer;       {*Taille de la fentre -190-20*}

{============================================================================}

{ͻ
                            RECOGNISED ACTIONS                              
 ͼ}

                { Display a BMP (MGF) image }
Procedure Action_DisplayBMP(St:String);
Var BMPFile:String;
    X1,Y1,Code:Integer;
    Id:Word;
Begin
Val(Str_Get(St,1,','),X1,Code);
Val(Str_Get(St,2,','),Y1,Code);
If Pos('BMPPAL',Upper(Str_Get(St,3,',')))>0 Then Id:=$00A0 Else Id:=$0080;
BMPFile:=Str_Get(St,4,',');
If Test_BMP(BMPFile) Then Show_BMP(X1,Y1,VESA_GetMaxX,VESA_GetMaxY, 0,0,BMPFile,Id);
End;

                { Display a shade }
Procedure Action_DisplayShade(St:String);
Var X1,Y1,X2,Y2,C1,C2,Sens,Code:Integer;
Begin
Val(Str_Get(St,1,','),X1,Code);
Val(Str_Get(St,2,','),Y1,Code);
Val(Str_Get(St,3,','),X2,Code);
If Code<>0 Then If Pos('GETMAXX',Upper(Str_Get(St,3,',')))>0 Then X2:=VESA_GetMaxX;
Val(Str_Get(St,4,','),Y2,Code);
If Code<>0 Then If Pos('GETMAXY',Upper(Str_Get(St,4,',')))>0 Then Y2:=VESA_GetMaxY;
Val(Str_Get(St,5,','),C1,Code);
Val(Str_Get(St,6,','),C2,Code);
If Pos('VERTICAL',Upper(Str_Get(St,7,',')))>0 Then Sens:=1 Else Sens:=0;
Display_Colors(X1,Y1,X2,Y2,C1,C2,Sens);
End;

                { Build a shade between 2 colors }
Procedure Action_BuildShade(St:String);
Var C1,C2,Code:Integer;
Begin
Val(Str_Get(St,1,','),C1,Code);
Val(Str_Get(St,2,','),C2,Code);
Col_BuildShade(C1,C2);
End;

                { Define a RGB Color }
Procedure Action_SetRGBPalette(St:String);
Var C1,R,G,B,Code:Integer;
Begin
Val(Str_Get(St,1,','),C1,Code);
Val(Str_Get(St,2,','),R, Code);
Val(Str_Get(St,3,','),G, Code);
Val(Str_Get(St,4,','),B, Code);
VESA_SetRGBPalette(C1,R,G,B);
End;

                { Define Application Name }
Procedure Action_CopyQuantity(St:String);
Var Code:Integer;
Begin
Val(St,CopyQuantity,Code);
End;

                { Define Application Name }
Procedure Action_SetAppName(St:String);
Begin
AppName:=St;
End;

                { XCopy Files }
Procedure Action_ReqXCopy(St:String);
Begin
If Installed Then Exit;
Req_XCopy(110,79,$0000,Loc(1709), Str_Get(St,1,','), Str_CorrectPath(InstallPath+'\'+Str_Get(St,2,',')));
End;

                { XAttrib on Files }
Procedure Action_XAttrib(St:String);
Var V:String;
    VAttr:Word;
Begin
If Installed Then Exit;
V:=Str_Get(St,1,',');
If Upper(V)='ARCHIVE'  Then VAttr:=Archive;
If Upper(V)='HIDDEN'   Then VAttr:=Hidden;
If Upper(V)='READONLY' Then VAttr:=ReadOnly;
If Upper(V)='SYSFILE'  Then VAttr:=SysFile;

{gotoxy(1,1); writeln(InstallPath+'\*.*'); readkey;}
File_XAttrib(InstallPath+'\*.*',VAttr);
End;

                { Execute a Program }
Procedure Action_Execute(St:String);
Var Show:Boolean;                       {*Affiche car bonne langue*}
Begin
If Not File_TestExist(Str_Get(St,2,',')) Then Exit;
Show:=FALSE;
If (Upper(Str_Get(St,1,','))='EN') And (Locale_Lan=1) Then Show:=TRUE;
If (Upper(Str_Get(St,1,','))='FR') And (Locale_Lan=2) Then Show:=TRUE;
If (Upper(Str_Get(St,1,','))='SP') And (Locale_Lan=3) Then Show:=TRUE;
If Not Show Then Exit;

Execute(Str_Get(St,2,','), Str_Get(St,3,','),$41FF);
End;

                { MOS Inner Displaying }
Procedure Action_MOSDisplay(St:String);
Var Show:Boolean;                       {*Affiche car bonne langue*}
Begin
If Not File_TestExist(Str_Get(St,2,',')) Then Exit;
Show:=FALSE;
If (Upper(Str_Get(St,1,','))='EN') And (Locale_Lan=1) Then Show:=TRUE;
If (Upper(Str_Get(St,1,','))='FR') And (Locale_Lan=2) Then Show:=TRUE;
If (Upper(Str_Get(St,1,','))='SP') And (Locale_Lan=3) Then Show:=TRUE;
If Not Show Then Exit;

Req_List(100,50,$0003,'INFORMATION','',';',Str_Get(St,2,','));
End;

                { Define Application Version }
Procedure Action_SetAppVersion(St:String);
Begin
AppVersion:=St;
End;

                { Define Install Path }
Procedure Action_SetInstallPath(St:String);
Begin
InstallPath:=St;
End;

                { Call System Configuration }
Procedure Action_SetSystemConfiguration(St:String);
Begin
System_Request(100,30,St);
Save_Config(InstallPath+'\'+St);
End;

                { Save Configuration As... }
Procedure Action_SaveConfigAs(St:String);
Begin
Save_Config(InstallPath+'\'+St);
End;

                { Define SetupMode }
Procedure Action_SetupMode(St:String);
Begin
If Upper(St)='INSTALLATION' Then SetupMode:=MODE_INSTALL
                            Else SetupMode:=MODE_UNINSTALL;
End;

                { Define Number of Authorisations }
Procedure Action_NumberOfAuthorisations(St:String);
Var N,Code:Integer;
Begin
Val(Str_Get(St,1,','),N,Code);
If Code=0 Then QttAuthorisations:=N;
If QttAuthorisations<1 Then QttAuthorisations:=1;
End;

                { Define Authorisation Code }
Procedure Action_AuthorisationCode(St:String);
Begin
AuthorisationCode:=St;
End;

                { Define Display Code }
Procedure Action_DisplayCode(St:String);
Begin
If Upper(St)='YES' Then DisplayCode:=TRUE Else DisplayCode:=FALSE;
End;

                { Enable Installation Types }
Procedure Action_EnableInstallationTypes(St:String);
Var N1,N2,N3,Code:Integer;
Begin
InstallationType:=$0000;
Val(Str_Get(St,1,','),N1,Code);
If Code=0 Then BSET(InstallationType,N1);
Val(Str_Get(St,2,','),N2,Code);
If Code=0 Then BSET(InstallationType,N2);
Val(Str_Get(St,3,','),N3,Code);
If Code=0 Then BSET(InstallationType,N3);
End;

                { Define new Language }
Procedure Action_SetLanguage(St:String);
Begin
If Upper(St)='EN' Then Change_Language(1);
If Upper(St)='FR' Then Change_Language(2);
If Upper(St)='SP' Then Change_Language(3);
End;

                { Define Icon for Installation Type }
Procedure Action_SetInstallIcon(St:String);
Var Num,Code:Integer;
Begin
Val(Str_Get(St,1,','),Num,Code);
If (Num>=1) And (Num<=3) Then AIcon[Num]:=Str_Get(St,2,',');
End;

                { Define Size for Installation Type }
Procedure Action_SetInstallSize(St:String);
Var Num,Size,Code:Integer;
Begin
Val(Str_Get(St,1,','),Num,Code);
Val(Str_Get(St,2,','),Size,Code);
If (Num>=1) And (Num<=3) Then ASize[Num]:=Size;
End;

                { Display Msg }
Procedure Action_DisplayMsg(St:String; X,Y:Integer);
Var Line:String;                        {*Ligne pure...*}
    P1,P2,Code:Integer;
    Show:Boolean;                       {*Affiche car bonne langue*}
    Fin:Boolean;                        {*Fin de l'affichage*}
    FntType:String[12];                 {*Fonts Management*}
    FntSize:Byte;
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Show:=FALSE; Fin:=FALSE;
If (Upper(Str_Get(St,1,','))='EN') And (Locale_Lan=1) Then Show:=TRUE;
If (Upper(Str_Get(St,1,','))='FR') And (Locale_Lan=2) Then Show:=TRUE;
If (Upper(Str_Get(St,1,','))='SP') And (Locale_Lan=3) Then Show:=TRUE;
FntType:=Str_Get(St,2,',');
Val(Str_Get(St,3,','),FntSize, Code);

Set_Font(FntType,FntSize);
Repeat
   Inc(LineRead); If Show Then Inc(QttLines);
   If QttLines>=24 Then Exit;           {*Trop de lignes*}
   Line:=File_GetLine(FName,LineRead);
   P1:=Pos('{',Line); If P1>0 Then Begin Delete(Line,P1,1); End;
   P2:=Pos('}',Line); If P2>0 Then Begin Delete(Line,P2,1); Fin:=TRUE; End;
   If Show Then Display(X,Y+HaF*(QttLines-1),-1,0,Line);
Until Fin;
Set_Font('LITT.CHR',4);
End;

{ͻ
                          Search a String Position                          
 ͼ}

Function Set_Position(Position:String; Mode:Byte):Longint;
Var Res:Longint;
    Num:Integer;

Begin
Res:=File_TestString(FName,Position,0); {*Get Line Number*}
Set_Position:=Res;                      {*Return Result...*}

If (Res=0) And (Mode=OBLIGATORY) Then   {*If fatal Error !*}
   Begin
   Num:=1;
   Req_Dialog(Loc(214),Loc(215)+Position+Loc(216)+Loc(217),'   _OK   ',Num);
   State:=S_END;
   End;
End;

{ͻ
                           Ask to Exit Confirmation                         
 ͼ}

Function CONFIRM_EXIT:Boolean;
Var Num:Integer;
Begin
Num:=3;
Req_Dialog(Loc(218),Loc(219)+AppName+Loc(220),Loc(1675),Num);
If Num=1 Then Begin State:=S_END; CONFIRM_EXIT:=TRUE; End Else CONFIRM_EXIT:=FALSE;
End;

{ͻ
                             Display End Message                            
 ͼ}

Procedure Action_DisplayMSGEnd;
Var Num:Integer;
Begin
Num:=4;
Req_Dialog(Loc(1676),Loc(1677)+AppNameVer+Loc(1678)+Loc(1679),Loc(1680),Num);
End;

{ͻ
         Search the previous free state that has been previously done       
 ͼ}

Function Get_PreviousState(Num:Integer):Integer;
Var A:Integer;
Begin
For A:=Num-1 DownTo 0 do
   Begin
   If AState[A]=TRUE Then Begin
      Get_PreviousState:=A;
      Exit;
      End;
   End;
Get_PreviousState:=-1;
End;

{ͻ
                         Display Process Progression                        
 ͼ}

Procedure Draw_Process(Num:Integer);
Const MaxProcess=10;

Var BaseX,BaseY,A,Cl,Cp:Integer;
    Id:Word;                            {*Id du Display_Attr*}
    Tpn:Array[1..MaxProcess] of String;

Begin
AState[NUM]:=TRUE;                      {*This section has been done...*}

For A:=1 to MaxProcess do Tpn[A]:=Str_Get(Loc(1681),A,'|'); {*Fill Array*}

BaseX:=25; BaseY:=40;
TitleBox(15,20,175,220, 7,Loc(1691),$0046);
For A:=1 to MaxProcess do
   Begin
   Set_Font('LITT.CHR',4);
   If A<=MaxProcess Then Begin Cl:=14; Cp:=00; Id:=$0000; End;
   If A=Num         Then Begin Cl:=13; Cp:=12; Id:=$0001; Set_Font('MODN.CHR',4); End;
   If A<=Num-1      Then Begin Cl:=10; Cp:=15; Id:=$0001; End;
   BevelBox(BaseX, BaseY+(A-1)*17, BaseX+20, BaseY+15+(A-1)*17,1,Cl,TRUE,TRUE);
   Display_Attr(BaseX+25, BaseY+(A-1)*17+1,-1,Cp,Id,Tpn[A]);
   End;
End;

{ͻ
                    Display Window Title for Process Parts                  
 ͼ}

Procedure Display_InstallTitle(St:String);
Var A,Qtt,BaseY:Integer;
Begin
SizeX:=W1.X2-W1.X1-190-20;              {*Calcule la taille X*}
If (SizeX Div 2)*2<>SizeX Then Inc(SizeX);
Display_Colors(190, 10, 190+(SizeX Div 2), 50, Fade_Col, Fade_Col+Fade_QttCol-1,0);
Display_Colors(190+(SizeX Div 2), 10, 190+SizeX, 50, Fade_Col+Fade_QttCol-1, Fade_Col,0);

Qtt:=Str_Count(St,'|'); BaseY:=30-(Qtt-1)*5;
Set_Font('MODN.CHR',4);
For A:=1 to Qtt do
   Display_Attr(190+(SizeX Div 2)-VESA_TextWidth(Str_Get(St,A,'|')) Div 2,
                BaseY+(A-1)*HaF, -1,15,$0009,Str_Get(St,A,'|'));
Set_Font('LITT.CHR',4);
Tool_Line(190+(SizeX Div 2)-50, 15+6, 190+(SizeX Div 2)+50, 15+6,0,0);
Tool_Line(190+(SizeX Div 2)-50, 45+6, 190+(SizeX Div 2)+50, 45+6,0,0);
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
                             FUNCTION BATCH_INIT                            
 ͼ}

Function BATCH_INIT:Boolean;
Var LineTemp:Longint;
    FnD:DirStr;
    FnN:NameStr;
    FnE:ExtStr;
    Num:Integer;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp,StVal:String;
    P1,P2:Integer;                      {*Position "(" et ")"*}
    A:Integer;

Begin
FSplit(FExpand(ParamStr(0)),FnD,FnN,FnE); {*Build Datas Filename*}
FName:=FnN+'.LST';
AppName:='UNKNOWN';
AppVersion:='v1.0';
InstallPath:='C:\MOS';
InstallationType:=$0001;
SetupMode:=MODE_INSTALL;
OldVersionsFound:=FALSE;
SetInDirectory:=FALSE;
DisplayCode:=TRUE;
PwdFound:=FALSE;
Pwd1:=''; Pwd2:='';
LineRead:=0;
Installed:=FALSE;                       {*App pas encore installe*}
CopyQuantity:=1;

For A:=1 to 3 do AIcon[A]:='I_INFORM.ICO';
For A:=1 to 3 do ASize[A]:=-1;
For A:=0 to Max_States do AState[A]:=FALSE;
Dsk_ChDir(FnD);                         {*Se met dans le directory de SETUP*}

BATCH_INIT:=TRUE;

If File_TestString(FName,'MOS Setup v1.0',0)=0 Then
   Begin                                {*Pas bonne version ?*}
   Num:=1;
   Req_Dialog(Loc(1692),Loc(1693)+FnN+'.EXE"','   _OK   ',Num);
   BATCH_INIT:=FALSE;
   Exit;
   End;

LineTemp:=Set_Position('[Initialisations]',OBLIGATORY);
If LineTemp=0 Then                      {*Recherche des Initialisations*}
   Begin BATCH_INIT:=FALSE; Exit; End;

LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('SETUPMODE',         StUp)>0 Then Action_SetupMode(StVal);
      If Pos('DISPLAYBMP',        StUp)>0 Then Action_DisplayBMP(StVal);
      If Pos('BUILDSHADE',        StUp)>0 Then Action_BuildShade(StVal);
      If Pos('DISPLAYSHADE',      StUp)>0 Then Action_DisplayShade(StVal);
      If Pos('SETRGBPALETTE',     StUp)>0 Then Action_SetRGBPalette(StVal);
      If Pos('APPLICATIONNAME',   StUp)>0 Then Action_SetAppName(StVal);
      If Pos('APPLICATIONVERSION',StUp)>0 Then Action_SetAppVersion(StVal);
      If Pos('SETINSTALLPATH',    StUp)>0 Then Action_SetInstallPath(StVal);
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

AppNameVer:=AppName+' '+AppVersion;     {*Build Version and Name*}
State:=S_LANGUAGE;                      {*Go to Etat N2*}
End;

{ͻ
                          FUNCTION BATCH_LANGUAGE                           
 ͼ}

Function BATCH_LANGUAGE:Boolean;
Var LineTemp:Longint;
    Fin,Fin2:Boolean;
    Skip:Boolean;
    St,StUp,StVal:String;
    P1,P2:Integer;                      {*Position "(" et ")"*}
    Res:Byte;

Begin
BATCH_LANGUAGE:=TRUE;
LineTemp:=Set_Position('[Language]',OPTIONAL);

LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('SETLANGUAGE',StUp)>0 Then Action_SetLanguage(StVal);
      If Pos('SELECTLANGUAGE',StUp)>0 Then
         Begin
         AState[S_LANGUAGE]:=TRUE;      {*This section has been done...*}
         Fin2:=FALSE;
            Repeat
            Res:=DefSys_Locale(210,100);
            Change_Language(Locale_Lan);{*Set New Language*}
            If Res=0 Then Begin
                     If CONFIRM_EXIT Then Exit
                     End
                     Else Fin2:=TRUE;
            Until Fin2;
         End;
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

State:=S_WELCOME;                       {*Go to Etat N3*}
End;

{ͻ
                          FUNCTION BATCH_WELCOME                            
 ͼ}

Function BATCH_WELCOME:Boolean;
Var LineTemp:Longint;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp,StVal:String;
    P1,P2:Integer;
    Even          :Byte;                {*Get Windows Evens*}
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3:TButton;             {*Buttons structure*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}

LineTemp:=Set_Position('[Welcome]',OBLIGATORY);
If State=S_END Then Exit;               {*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;
QttLines:=0;                            {*0 Lines Read*}
AState[S_WELCOME]:=TRUE;                {*This section has been done...*}

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('DISPLAYBMP',   StUp)>0 Then Action_DisplayBMP(StVal);
      If Pos('DISPLAYMSG',   StUp)>0 Then Action_DisplayMSG(StVal,170,80);
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button( WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button( WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170,But2,Str_Get(Loc(1694),2,'|'));
Button( WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);

Set_Font('TSCR.CHR',1);
Display_Attr(170,20,-1,0,$0002,Str_Get(Loc(1695),1,'|'));
Display_Attr(170,40,-1,0,$0002,AppName+Str_Get(Loc(1695),2,'|'));
Set_Font('LITT.CHR',4);

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_WELCOME:=TRUE;
LineTemp:=Set_Position('[Welcome]',OBLIGATORY);
If LineTemp=0 Then Begin BATCH_WELCOME:=FALSE; Exit; End;{*Section Not Found !*}

Win_Init(100,50,VESA_GetMaxX-100,100+330,$51D9,AppNameVer+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

REDRAW_FRAME;                           {*Display Window Content*}
XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}

Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End; 
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

If XPrev Then State:=Get_PreviousState(S_WELCOME);
If XNext Then State:=S_REGISTER;        {*Change Automate State...*}
End;

{ͻ
                          FUNCTION BATCH_REGISTER                           
 ͼ}

Function BATCH_REGISTER:Boolean;
Var LineTemp:Longint;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp,StVal:String;
    P1,P2:Integer;                      {*Position "(" et ")"*}

Begin
BATCH_REGISTER:=TRUE;
LineTemp:=Set_Position('[Register]',OPTIONAL);
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('DISPLAYMOSREGISTER',StUp)>0 Then
         Begin
         Win_Init(0,0,VESA_GetMaxX,VESA_GetMaxY,$1411,'',W1);
         Win_Sup(0,0,0,0,0,0,0,0,0,15,$0A50,W1);
         If NError<>0 Then Exit;        {*Initialisations Errors ?*}
         Win_Draw(W1);                  {*Display Window*}
         Req_Register;
         Win_Kill(W1);
         End;
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

State:=S_COMPONENTS;                     {*Go to Next State*}
End;

{****************************************************************************}

Procedure SEARCH_MOS(S:PathStr);Far;    {*Search for the MOS Versions*}
Var FD :DirStr;
    FN :NameStr;
    FE :ExtStr;
    Com1:TInputText;
    St:String;

Begin
FSplit(S,FD,FN,FE);                     {*Split into components...*}
Win_Clip(On,W1);

If Button_GetMsg(But5,1) Then Begin     {*Stop Process...*}
   StopProc:=TRUE;
   File_FindBreak;
   End;

If OldFName<>FD Then                    {*New Drawer*}
   Begin
   Com1.Cin:=FD;
   If OldDisk<>Copy(Fd,1,2) Then Begin  {*Display New disk label*}
      Display(192,70,-1,0,Loc(1683)+Copy(FD,1,2));
      OldDisk:=Copy(FD,1,2);
      End;
   InputText(190,90, SizeX,255,09,12,1,$0026,Com1,Com1.Cin);
   OldFName:=FD;
   End;

If FN+FE='VERSION.TXT' Then             {*Recherche le fichier "VERSION.TXT"*}
   If Pos('MOS v',File_GetLine(S,1))>0 Then
      Begin                             {*Add MOS version dans la liste*}
      St:=FD+';'+File_GetLine(S,1);
      OldVersionsFound:=TRUE;
      List_AddItem(LM,St,Insert_Append);
      If List_GetQttItems(LM)=1 Then List_Show(LM)
                                Else List_Refresh(LM);
      End;
Win_Clip(Off,W1);
End;

{ͻ
                          FUNCTION BATCH_COMPONENTS                         
 ͼ}

Function BATCH_COMPONENTS:Boolean;
Var LineTemp      :Longint;
    Fin           :Boolean;
    Skip          :Boolean;
    St,StUp       :String;
    Even          :Byte;                {*Get Windows Evens*}
    A             :Integer;
    IdP           :Word;
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3,But4:TButton;        {*Buttons structure*}
    Com1          :TInputText;

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_DELETEBUTTON;
Begin
Win_Clip(On,W1);
If LM.Qtt_Tagged_Items>0 Then IdP:=$0000 Else IdP:=$0002;
Button (190, 204, LaF*30,-1, 0, 7,$0060+IdP,But4,Loc(1684));
End;

Procedure REDRAW_RESULT;
Begin
Win_Clip(On,W1);
Display  (192,70,-1,0,Loc(1685));
Com1.Cin:='';
InputText(190,90, SizeX,255,09,12,1,$0026,Com1,Com1.Cin);
If OldVersionsFound Then Begin
   List_Show(LM);
   REDRAW_DELETEBUTTON;
   End
   Else Begin
   Set_Font('MODN.CHR',4);
   Display (192,120,-1,0,Loc(1724));
   Set_Font('LITT.CHR',4);
   End;
Win_Clip(Off,W1);
End;

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170,But2,Str_Get(Loc(1694),2,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Button (WSx-LaF*34, 204, LaF*15,-1, 0, 7,$0010,But5,'S_TOP');
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_COMPONENTS);             {*Display Process Progression*}

Display_InstallTitle(Str_Get(Loc(1686),1,'|')+AppName+Str_Get(Loc(1686),2,'|'));

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}

If OldVersionsSearched Then REDRAW_RESULT;
End;

{*************************** DELETE OLD VERSION *****************************}

Procedure ASK_TOCONFIRMDELETION;
Var Num,A:Integer;
    SourceToDelete:String;

Begin
Num:=3;
Req_Dialog(Loc(218),Loc(1687),Loc(1688),Num);
If Num=1 Then Begin
   For A:=1 to List_GetQttItems(LM) do
      Begin
      If List_TestTaggedItem(LM,A)>0 Then Begin
         SourceToDelete:=List_GetStringCell(LM,A,1);
         SourceToDelete:=Copy(SourceToDelete,1,Pos('MOS',SourceToDelete))+'OS\';
         File_Deltree(SourceToDelete);  {*Deltree MOS Versions*}
         End;
      End;
   Repeat                               {*Supprime les Items*}
      For A:=1 to List_GetQttItems(LM) do
         If List_TestTaggedItem(LM,A)>0 Then List_DeleteItem(LM,A);
   Until LM.Qtt_Tagged_Items=0;

   Win_Clip(On,W1);
   List_Refresh(LM);                    {*Raffiche la liste*}
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_COMPONENTS:=TRUE;
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;
StopProc:=FALSE;
QttLines:=0;                            {*0 Lines Read*}

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNameVer+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}
REDRAW_FRAME;                           {*Display Window Content*}

If Not OldVersionsSearched Then         {*Recherche Old Versions...*}
   Begin
   Mse_SetPointer(P_Busy);
   Win_Clip(On,W1);                     {*Clipping Window*}
   List_Define(LM,Loc(1689),';',190,115,190+SizeX,192,100, 15,12,$3FAD);
   List_SetIdMore(LM,$0008);
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   For A:=67 to 90 do                   {*Search for the MOS Versions*}
      If (Dsk_TestDeviceExist(Chr(A))) And (Dsk_TestWritableDrive(Chr(A))) Then
         Begin
         If StopProc Then Begin {write(#7); }Break; End;
         File_Find(Chr(A)+':\*.*',TRUE,SEARCH_MOS);
         End;
   Mse_SetPointer(P_Current);
   List_SetColumnAttr(LM,1,230,Text_OnLeft);
   OldVersionsSearched:=TRUE;           {*Disks are now Scanned...*}
   End;

REDRAW_RESULT;                          {*Display Result Scanning*}

XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}
Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
{   If Button_GetMsg(But5,1) Then Begin StopProc:=TRUE; write(#7);File_FindBreak; End; {*Stop Process...*}
   If OldVersionsFound Then Begin
      If List_Test(LM)<>0 Then REDRAW_DELETEBUTTON;
      If Button_GetMsg(But4,1) Then Begin
         ASK_TOCONFIRMDELETION;
         REDRAW_DELETEBUTTON;
         End;
      End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

If XPrev Then State:=Get_PreviousState(S_COMPONENTS);
If XNext Then State:=S_PROTECT;         {*Change Automate State...*}
End;

{ͻ
                           FUNCTION BATCH_PROTECT                           
 ͼ}

Function BATCH_PROTECT:Boolean;
Var LineTemp:Longint;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp,StVal :String;
    P1,P2:Integer;                      {*Position "(" et ")"*}
    IdBut         :Word;                {*Id Bouton "NEXT"*}
    QttTry        :Word;                {*Qtt d'essais*}
    Active        :Word;                {*InputText Activation*}
    Even          :Byte;                {*Get Windows Evens*}
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3:TButton;             {*Buttons structure*}
    Com1,Com2,Com3:TInputText;          {*InputText Structure*}
    Rad1          :TRadioBox;           {*RadioBox Structure*}

{************************* DISPLAY INPUTTEXT GADGETS ************************}

Procedure REDRAW_COMMANDS;
Var Id:Word;
Begin
If Rad1.Status Then Id:=$0080 Else Id:=$0000;
Win_Clip(On,W1);                        {*Clipping Window*}
InputText(190,90, 24, 100,09,12,0,$66+Id,Com1,Com1.Cin);
InputText(240,90, 80, 100,09,12,0,$36+Id+Active,Com2,Com2.Cin);
InputText(347,90, 80, 100,09,12,0,$3E+Id,Com3,Com3.Cin);
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
Active:=$0000;
End;

Procedure REDRAW_NEXT;
Var WSx,WSy:Integer;                    {*Window Size X,Y*}
Begin
WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Win_Clip(On,W1);                        {*Clipping Window*}
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170+IdBut,But2,Str_Get(Loc(1694),2,'|'));
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{******************* TEST IF THE CODE IS TOTALLY ENTERED ********************}

Procedure Test_EnableNext;
Begin
If PwdFound Then Exit;                  {*Password found yet !*}
If (Length(Com2.Cin)=12) And (Length(Com3.Cin)=12) Then
   Begin
   IdBut:=$0000;
   REDRAW_NEXT;                         {*Display Button "NEXT"*}
   End
   Else
   If IdBut=$0000 Then Begin
      IdBut:=$0002;
      REDRAW_NEXT;                      {*Display Button "NEXT"*}
      End;
End;

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}

LineTemp:=Set_Position('[Protection]',OPTIONAL);
If State=S_END Then Exit;               {*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('NUMBEROFAUTHORISATIONS',StUp)>0 Then Action_NumberOfAuthorisations(StVal);
      If Pos('AUTHORISATIONCODE',     StUp)>0 Then Action_AuthorisationCode(StVal);
      If Pos('DISPLAYCODE',           StUp)>0 Then Action_DisplayCode(StVal);
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_PROTECT);                {*Display Process Progression*}

Display_InstallTitle(Loc(1690));
Display  (219,91,-1,0,'MOS');
Display  (325,91,-1,0,'OEM');
Set_Font('MODN.CHR',4);
If PwdFound Then Display(190,70,-1,0,Str_Get(Loc(1696),1,'|'))
            Else Display(190,70,-1,0,Str_Get(Loc(1696),2,'|'));
Set_Font('ITAL.CHR',4);
RadioBox (190,111,1,$10,0,0,Rad1.Status,Rad1,Str_Get(Loc(1696),3,'|'));
Set_Font('LITT.CHR',4);

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}

REDRAW_NEXT;                            {*Display Button "NEXT"*}
REDRAW_COMMANDS;                        {*Display InputText*}
End;

{***************************** VERIFY PASSWORD ******************************}

Function TEST_PWD:Integer;
Var Pwd:String;
    A:Integer;
Begin
TEST_PWD:=State;                        {*Return Current State*}
Pwd1:=Com2.Cin; Pwd2:=Com3.Cin;
If PwdFound Then Begin XNext:=TRUE; Exit; End; {*Password found yet !*}

Pwd:=Com1.Cin+'MOS'+Com2.Cin+'OEM'+Com3.Cin;
For A:=1 to Length(Pwd) do Pwd[A]:=Chr(Ord(Pwd[A]) XOR 3);
If Pwd=AuthorisationCode Then Begin PwdFound:=TRUE; XNext:=TRUE; End
   Else Begin
   Inc(QttTry);                         {*1 More Try*}
   If QttTry>=QttAuthorisations Then
      Begin
      A:=2;
      Req_Dialog(Loc(1676),Loc(1697)+AppNameVer+Loc(1698),'   _OK   ',A);
      TEST_PWD:=S_END;
      XCancel:=TRUE;                    {*Pwd Failed => EXIT*}
      Exit;
      End;
   A:=1;
   Req_Dialog(Loc(1676),Loc(1699),'   _OK   ',A);
   Active:=$0001;
   REDRAW_COMMANDS;                     {*Display InputText*}
   End;
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_PROTECT:=TRUE;
LineTemp:=Set_Position('[Protection]',OPTIONAL);
If State=S_END Then Begin BATCH_PROTECT:=FALSE; Exit; End;{*Section Not Found !*}
If LineTemp=0  Then Begin State:=S_TYPEINSTALL; Exit; End;{*Section Not Found !*}

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNameVer+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

Com1.Cin:='000'; Com2.Cin:=Pwd1; Com3.Cin:=Pwd2;
Rad1.Status:=Not DisplayCode;
Active:=$0001;                          {*First Display = Activation*}
If PwdFound Then IdBut:=$0000 Else IdBut:=$0002;
QttTry:=0;
REDRAW_FRAME;                           {*Display Window Content*}
XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}

Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then State:=TEST_PWD;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
   If InputText_GetMsg(Com2,Com2.Cin) Then Test_EnableNext;
   If InputText_GetMsg(Com3,Com3.Cin) Then Test_EnableNext;
   If RadioBox_GetMsg(Rad1,1) Then REDRAW_COMMANDS;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

DisplayCode:=Not Rad1.Status;           {*Display or no Autentification Code*}
Win_Kill(W1);                           {*Kill Windows*}

If XPrev Then State:=Get_PreviousState(S_PROTECT);
If XNext Then State:=S_TYPEINSTALL;     {*Change Automate State...*}
End;

{ͻ
                          FUNCTION BATCH_TYPEINSTALL                        
 ͼ}

Function BATCH_TYPEINSTALL:Boolean;
Var LineTemp:Longint;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp,StVal :String;
    P1,P2,A:Integer;                    {*Position "(" et ")"*}
    Even          :Byte;                {*Get Windows Evens*}
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3,
    But4,But5,But6:TButton;             {*Buttons structure*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}

LineTemp:=Set_Position('[Install Type]',OPTIONAL);
If State=S_END Then Exit;               {*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('SETINSTALLICON',StUp)>0 Then Action_SetInstallIcon(StVal);
      If Pos('SETINSTALLSIZE',StUp)>0 Then Action_SetInstallSize(StVal);
      If Pos('ENABLEINSTALLATIONTYPES',StUp)>0 Then Action_EnableInstallationTypes(StVal);
      If (Pos('DEFINEINSTALL1',StUp)>0) And (BTST(InstallationType,1)) Then Begin
         If OldAction<>1 Then QttLines:=0; OldAction:=1; Action_DisplayMSG(StVal,250,70); End;
      If (Pos('DEFINEINSTALL2',StUp)>0) And (BTST(InstallationType,2)) Then Begin
         If OldAction<>2 Then QttLines:=0; OldAction:=2; Action_DisplayMSG(StVal,250,120); End;
      If (Pos('DEFINEINSTALL3',StUp)>0) And (BTST(InstallationType,3)) Then Begin
         If OldAction<>3 Then QttLines:=0; OldAction:=3; Action_DisplayMSG(StVal,250,170); End;
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0072,But2,Str_Get(Loc(1694),2,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_TYPEINSTALL);            {*Display Process Progression*}

Display_InstallTitle(Loc(1706));
If BTST(InstallationType,1) Then Button (190,70, 40,40, 15,9,$0158,But4,Get_SystemPath(SP_ICONS)+AIcon[1]);
If BTST(InstallationType,2) Then Button (190,120,40,40, 15,9,$0058,But5,Get_SystemPath(SP_ICONS)+AIcon[2]);
If BTST(InstallationType,3) Then Button (190,170,40,40, 15,9,$0058,But6,Get_SystemPath(SP_ICONS)+AIcon[3]);

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_TYPEINSTALL:=TRUE;
LineTemp:=Set_Position('[Install Type]',OPTIONAL);
If State=S_END Then Begin BATCH_TYPEINSTALL:=FALSE; Exit; End;{*Section Not Found !*}

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNameVer+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

REDRAW_FRAME;                           {*Display Window Content*}
XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}

Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;

   If (BTST(InstallationType,1)) And (Button_GetMsg(But4,1)) Then Begin XNext:=TRUE; InstallType:=1; End;
   If (BTST(InstallationType,2)) And (Button_GetMsg(But5,1)) Then Begin XNext:=TRUE; InstallType:=2; End;
   If (BTST(InstallationType,3)) And (Button_GetMsg(But6,1)) Then Begin XNext:=TRUE; InstallType:=3; End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

InstallSize:=ASize[InstallType];        {*Get the Install Size*}

If XPrev Then State:=Get_PreviousState(S_TYPEINSTALL);
If XNext Then State:=S_DIRECTORY;       {*Change Automate State...*}
End;

{ͻ
                          FUNCTION BATCH_DIRECTORY                          
 ͼ}

Function BATCH_DIRECTORY:Boolean;
Var LineTemp:Longint;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp       :String;
    Even          :Byte;                {*Get Windows Evens*}
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3,
    But4          :TButton;             {*Buttons structure*}
    Com1          :TInputText;
    DirSel,FilSel :String;
    FSize         :Longint;
    OkToFollow    :Boolean;             {*Follow to display Window*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_COMMAND;               {*Define Command*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
InputText (190,90, SizeX,255,09,12,0,$0427,Com1,InstallPath);
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170,But2,Str_Get(Loc(1694),2,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_DIRECTORY);              {*Display Process Progression*}

Button (190,70, LaF*35,-1, 0,7,$0060,But4,Str_Get(Loc(1700),1,'|'));
Display_InstallTitle(Str_Get(Loc(1700),2,'|')+AppNameVer);

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}

REDRAW_COMMAND;                         {*Define Command*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_DIRECTORY:=TRUE;
LineTemp:=Set_Position('[Directory]',OPTIONAL);
If State=S_END Then Begin BATCH_DIRECTORY:=FALSE; Exit; End;{*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE; OkToFollow:=FALSE;
QttLines:=0;                            {*0 Lines Read*}
{$I-}
If Dsk_TestDirectory(InstallPath) Then ;{Rmdir(InstallPath);{*Remove directory if Previous...*}
{$I+}

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('ASKFORINSTALLPATH',StUp)>0 Then OkToFollow:=TRUE;
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

If Not OkToFollow Then Begin State:=S_END; Exit; End;

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNamever+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

DirSel:=InstallPath; FilSel:='';

REDRAW_FRAME;                           {*Display Window Content*}
XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}

Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
   If Button_GetMsg(But4,1) Then Begin
      Req_FileManager(W1.X1+20,W1.Y1+30,282,Loc(1701),'_OK','*.*',0,DirSel,FilSel,FSize);
      If DirSel<>'' Then InstallPath:=Upper(DirSel);
      REDRAW_COMMAND;
      End;
   If InputText_GetMsg(Com1,InstallPath) Then ;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

If XNext Then Dsk_CreateDirectory(InstallPath);{*Create directory*}
If XPrev Then State:=Get_PreviousState(S_DIRECTORY);
If XNext Then State:=S_FREEPLACE;       {*Change Automate State...*}
End;

{ͻ
                          FUNCTION BATCH_FREEPLACE                          
 ͼ}

Function BATCH_FREEPLACE:Boolean;
Var Num           :Integer;
    Size          :Longint;

{************************* DISPLAY WINDOW CONTENT ***************************}

Begin
BATCH_FREEPLACE:=TRUE;                  {*Get the size in Kb*}
Size:=(DiskFree(Ord(InstallPath[1])-64)) Div 1024;
If Size<=InstallSize Then
   Begin
   Num:=1;
   Req_Dialog(Str_Get(Loc(1702),1,'|'),Str_Get(Loc(1702),2,'|')+AppNameVer,Loc(1703),Num);
   If Num=1  Then State:=S_DIRECTORY;
   If Num<>1 Then State:=S_END;
   Exit;
   End;

State:=S_INSTALL;                       {*Next State*}
End;

{ͻ
                           FUNCTION BATCH_INSTALL                           
 ͼ}

Function BATCH_INSTALL:Boolean;
Var LineTemp:Longint;
    Fin:Boolean;
    Skip:Boolean;
    St,StUp,StVal :String;
    P1,P2,Code    :Integer;
    InsType       :String;              {*Selected Installation Type*}
    Even          :Byte;                {*Get Windows Evens*}
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3:TButton;             {*Buttons structure*}
    WSx,WSy       :Integer;             {*Window Size X,Y*}
    CopyDone      :Integer;             {*Nombre de copies faite  l'instant*}

{********************* BARRE DE PROGRESSION PRINCIPALE **********************}

Procedure REDRAW_MAINPROGRESS;
Var Percent:Integer;
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Percent:=Round((CopyDone*100) Div CopyQuantity);
Bar_Progress(190,196,190+SizeX,214, 12,Percent,$0001);{*Draw a Progress Bar*}
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170,But2,Str_Get(Loc(1694),2,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_INSTALL);                {*Display Process Progression*}

Display_InstallTitle(AppNameVer+Loc(1682));
Set_Font('MODN.CHR',4);
If Installed Then Display(193,186,-1,0,Loc(1707))
             Else Display(193,186,-1,0,Loc(1708));
Set_Font('LITT.CHR',4);

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}

REDRAW_MAINPROGRESS;                    {*Progression gnrale*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_INSTALL:=TRUE;
Case InstallType of
   1 : InsType:='[Install Default]';
   2 : InsType:='[Install Minimum]';
   3 : InsType:='[Install Custom]';
   End;
LineTemp:=Set_Position(InsType,OBLIGATORY);
If State=S_END Then Begin BATCH_INSTALL:=FALSE; Exit; End;{*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
Fin:=FALSE;
QttLines:=0;                            {*0 Lines Read*}
CopyDone:=0;                            {*Pas de copies faites pour l'instant*}

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNamever+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

REDRAW_FRAME;                           {*Display Window Content*}
XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('UPDATEINI',    StUp)>0 Then ;
      If Pos('XCOPY',        StUp)>0 Then
         Begin
         Inc(CopyDone);
         Action_ReqXCopy(StVal);
         REDRAW_MAINPROGRESS;           {*Progression gnrale*}
         End;
      If Pos('COPY QUANTITY',StUp)>0 Then Action_CopyQuantity(StVal);
      If Pos('XATTRIB',      StUp)>0 Then Begin
         Inc(CopyDone);
         Mse_SetPointer(P_Busy);
         Action_XAttrib(StVal);
         Mse_SetPointer(P_Current);
         REDRAW_MAINPROGRESS;           {*Progression gnrale*}
         End;
      If Pos('EXECUTE',      StUp)>0 Then
         Begin If File_TestExist(StVal) Then Execute(StVal,'',$41FF); End;
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

Installed:=TRUE;                        {*L'installation  t effectue*}
REDRAW_FRAME;

Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

If XPrev Then State:=Get_PreviousState(S_INSTALL);
If XNext Then State:=S_README;          {*Change Automate State...*}
End;

{ͻ
                            FUNCTION BATCH_README                           
 ͼ}

Function BATCH_README:Boolean;
Var LineTemp      :Longint;
    Fin           :Boolean;
    Skip          :Boolean;
    St,StUp,StVal :String;
    Even          :Byte;                {*Get Windows Evens*}
    P1,P2,Code    :Integer;
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3:TButton;             {*Buttons structure*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170,But2,Str_Get(Loc(1694),2,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_README);                 {*Display Process Progression*}

Display_InstallTitle(Loc(1704));

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_README:=TRUE;
LineTemp:=Set_Position('[Readme]',OPTIONAL);
If State=S_END Then Begin BATCH_README:=FALSE; Exit; End;{*Section Not Found !*}
If LineTemp=0  Then Begin State:=S_END; Exit; End;{*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
QttLines:=0;                            {*0 Lines Read*}
Fin:=FALSE;

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNameVer+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

REDRAW_FRAME;                           {*Display Window Content*}

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If Pos('DISPLAYMSG',StUp)>0 Then Action_DisplayMSG(StVal,200,70);
      If Pos('MOSDISPLAY',StUp)>0 Then Action_MOSDisplay(StVal);
      If Pos('EXECUTE',   StUp)>0 Then Action_Execute(StVal);
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}
Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

If XPrev Then State:=Get_PreviousState(S_README);
If XNext Then State:=S_EXECUTE;         {*Change Automate State...*}
End;

{ͻ
                           FUNCTION BATCH_EXECUTE                           
 ͼ}

Function BATCH_EXECUTE:Boolean;
Var LineTemp      :Longint;
    Fin           :Boolean;
    Skip          :Boolean;
    St,StUp,StVal :String;
    Even          :Byte;                {*Get Windows Evens*}
    P1,P2,Code    :Integer;
    XNext,XPrev,XCancel:Boolean;        {*Exit Flags*}
    But1,But2,But3:TButton;             {*Buttons structure*}
    ExecDone      :Boolean;
    E,D           :Boolean;

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var WSx,WSy:Integer;                    {*Window Size X,Y*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}

WSx:=W1.X2-W1.X1; WSy:=W1.Y2-W1.Y1;
Button (WSx-LaF*51, WSy-HaF*4, LaF*15,-1, 0, 7,$0070,But1,Str_Get(Loc(1694),1,'|'));
Button (WSx-LaF*34, WSy-HaF*4, LaF*15,-1, 0, 7,$0170,But2,Str_Get(Loc(1705),1,'|'));
Button (WSx-LaF*17, WSy-HaF*4, LaF*15,-1, 15,9,$0010,But3,Loc(13));
Show_BMP(10,WSy-HaF*4-5,VESA_GetMaxX,VESA_GetMaxY, 0,0,'SETUP_M1.BMP',$0080);
Tool_Line(WSx,WSy-HaF*5+1,0,WSy-HaF*5+1,0,1);
Draw_Process(S_EXECUTE);                {*Display Process Progression*}

Display_InstallTitle(Str_Get(Loc(1705),2,'|'));

LineTemp:=Set_Position('[Execute]',OPTIONAL);
If State=S_END Then Exit;               {*Section Not Found !*}
LineRead:=LineTemp+1;                   {*Set Dbut de la lecture*}
QttLines:=0;                            {*0 Lines Read*}
Fin:=FALSE;
E:=FALSE;

   Repeat                               {*Parcours toutes les lignes d'Initialisation*}
   St:=File_GetLine(FName,LineRead);
   StUp:=Upper(St);
   If Pos('[',St)>0 Then Fin:=TRUE;     {*Next Paragraph*}
   P1:=Pos('(',St); P2:=Pos(')',St);
   StVal:=Copy(St,P1+1,P2-P1-1);
   Skip:=FALSE;
   If Copy(StUp,1,3)='REM' Then Skip:=TRUE;{*Ligne en REM*}
   If (Not Fin) And (Not Skip) Then Begin
      If (Pos('EXECUTE',      StUp)>0) And (Not ExecDone) Then
         Begin E:=TRUE; If File_TestExist(StVal) Then Execute(StVal,'',$41FF); End;
      If (Pos('EXECUTEMOS',   StUp)>0) And (Not ExecDone) Then
         Begin E:=TRUE; If File_TestExist(StVal) Then Execute_MOS(StVal,''); End;
      If Pos('DISPLAYMSG',    StUp)>0 Then Action_DisplayMSG(StVal,200,70);
      If (Pos('DISPLAYENDMESSAGE',StUp)>0) And (Not D) Then Begin D:=TRUE; Action_DisplayMSGEnd; End;
      If Pos('SETINDIRECTORY',StUp)>0 Then SetInDirectory:=TRUE;
      If Pos('EXIT',          StUp)>0 Then Begin State:=S_END; End;
      If Pos('SETSYSTEMCONFIGURATION',StUp)>0 Then Action_SetSystemConfiguration(StVal);
      If Pos('SAVECONFIGAS',  StUp)>0 Then Action_SaveConfigAs(StVal);
      End;
   Inc(LineRead);                       {*Next Line...*}
   Until Fin;

If E Then ExecDone:=TRUE;

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
BATCH_EXECUTE:=TRUE;
LineTemp:=Set_Position('[Execute]',OPTIONAL);
If State=S_END Then Begin BATCH_EXECUTE:=FALSE; Exit; End;{*Section Not Found !*}
If LineTemp=0  Then Begin State:=S_END; Exit; End;{*Section Not Found !*}

Win_Init(50,100,VESA_GetMaxX-50,100+280,$51D9,AppNameVer+Loc(1682),W1);
Win_Sup(0,0,0,0,0,0,0,0,0,7,$0AD0,W1);  {*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}
ExecDone:=FALSE; D:=FALSE;

REDRAW_FRAME;                           {*Display Window Content*}

XPrev:=No; XNext:=No; XCancel:=No;      {*Init Exit Flags*}
Repeat;
If State=S_END Then XCancel:=TRUE;      {*Section Not Found !*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then XPrev:=TRUE;
   If Button_GetMsg(But2,1) Then XNext:=TRUE;
   If Button_GetMsg(But3,1) Then Begin XCancel:=CONFIRM_EXIT; End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then                          {*Window Closed   => Exit*}
   Begin XCancel:=TRUE; CONFIRM_EXIT; End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until (XNext) Or (XPrev) Or (XCancel);  {*Exit Flags*}

Win_Kill(W1);                           {*Kill Windows*}

If XPrev Then State:=Get_PreviousState(S_EXECUTE);
If XNext Then State:=S_END;             {*Change Automate State...*}
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
                               PROCEDURE Main                               
 ͼ}

Procedure Main;
Var Win           :TWindow;             {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    Ok            :Boolean;             {*Errors*}

{***************************** MAIN PROCEDURE *******************************}

Begin
Win_Init(0,0,VESA_GetMaxX,VESA_GetMaxY,$3411,'',Win);
Win_Sup(0,0,0,0,0,0,0,0,0,15,$0A50,Win);{*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(Win);                          {*Display Window*}
State:=S_INIT;                          {*First State*}

Repeat
   Case State of
   S_INIT        : Ok:=BATCH_INIT;        {*Initialise le look*}
   S_LANGUAGE    : Ok:=BATCH_LANGUAGE;    {*Select Language*}
   S_WELCOME     : Ok:=BATCH_WELCOME;     {*Display Welcome Window*}
   S_REGISTER    : Ok:=BATCH_REGISTER;    {*Display Register Request*}
   S_COMPONENTS  : Ok:=BATCH_COMPONENTS;  {*Search for Old Version*}
   S_PROTECT     : Ok:=BATCH_PROTECT;     {*Protection in Software*}
   S_TYPEINSTALL : Ok:=BATCH_TYPEINSTALL; {*Determine Which version to Install*}
   S_DIRECTORY   : Ok:=BATCH_DIRECTORY;   {*Define Installation Directory*}
   S_FREEPLACE   : Ok:=BATCH_FREEPLACE;   {*Verify free Place*}
   S_INSTALL     : Ok:=BATCH_INSTALL;     {*Install Software*}
   S_README      : Ok:=BATCH_README;      {*Display final information*}
   S_EXECUTE     : Ok:=BATCH_EXECUTE;     {*Execute external program*}
   End;
If Not Ok Then State:=S_END;            {*Error Occured !*}
Until State=S_END;

Win_Kill(Win);                          {*Close Window if Needs*}
If OldVersionsSearched Then List_Kill(LM); {*Kill the Old MOS Versions List*}
If SetInDirectory Then Dsk_ChDir(InstallPath); {*Exit in Directory*}
End;

{ͻ
                         MAIN PROGRAM (INITIALISATIONS)                     
 ͼ}

Begin
{Directvideo:=FALSE;}
{INIT_DEBUG;}

INIT_BASE;                              {*Initialise Hardware*}
INIT_SCREEN;                            {*Initialise Screen*}
INIT_MOUSE;                             {*Initialise Mouse*}

Oldexit:=ExitProc;                      {*Intercept Errors*}
SetJump(MyAddr);
ExitProc:=@ENTRY_INT24;

If Not Test_HigherVersion('v3.10') Then {*System too old !*}
   Begin
   NError:=685;
   Main_Task;
   Close_MOS;
   End;

MAIN;                                   {*Call Main Procedure*}

DONE_MOUSE;                             {*Restore Mouse*}
DONE_SCREEN;                            {*Restore Screen*}
DONE_BASE;                              {*Restore Hardware*}
{DONE_DEBUG;}
End.
