(* This file was mangled by Mangler 1.40 (c) Copyright 1993-1994 by Berend de Boer *)
{ Created : From BBUTIL.PAS for Turbo Pascal 5.5

Last changes :
93-02-27  Added procedure Discard, mainly an idea of Pete Roth, posted in
          COMP.LANG.PASCAL
93-09-22  Copied TSItem from Dialogs to BBUtil so units will be less
          tv dependent. Renamed it to TSLink.
          Renamed DisposeSItem to DisposeSLink. DisposeSItem is removed
          in this regard. It's now added to BBDlg
93-09-23  Copied FormatStr from Drivers. It still needs FORMAT.OBJ to
          link properly
93-12-04  Added GetLogicalAddr, moved from TDInfo
          Procedures HorizLine, CalcCents and IncTotaal deleted
93-12-07  Moved GetLogicalAddr to BBError
93-12-08  Procedure Beep removed
93-12-09  Added TByteArray with MaxWord entries
93-12-13  Removed Crt from uses clause
94-01-01  Added function ScasW
94-02-15  Added function Min which returns the minimum of two longints
94-04-15  Removed array Maanden to BBDate
94-05-16  Adapted to the Windows environment
94-08-31  Added function ValHex
94-10-06  Moved function DateValid as DateStrValid to BBDate
94-10-12  Added function HexB to return a byte in hex format
95-04-06  Added function NextPos which returns the position of a certain
          character in a string starting the search at a given position
95-09-15  Added GetPStr, synonym for GetStr which should be considered
          obsolete
95-10-10  'Ported' to Delphi, you need the /delphi/source/rtl70 in your
          path. Procedure FreeStr is now longer available.
          GetDateStr might behave a bit different than previously, because it
          now uses your settings to return a formatted date.


Remarks:
function FreeStr should be considered obsolete
}


{$IFDEF MsDos}
{$F+,O+,D-}
{$ENDIF}

{$R-,Q-,I-,S-,X+}
unit BBUtil;

interface

uses
{$IFDEF Ver80}
  SysUtils,
{$ENDIF}
  Objects;


{$IFDEF Ver80}
{ some types to make Delphi compile this unit }
type
  PtrRec = record
    Ofs,
    Seg: word;
  end;
{$ENDIF}


const
  CR = #13;
  LF = #10;
  FF = #12;
  FormFeed = #12;

const
  prnLineFeed  = #10;
  prnFormFeed  = #12;
  prnCR        = #13;
  prnNL        = #13#10;      {* advance to next line and give a CR *}
  prnLargeOn   = #27+'W'+#1;  {* Shift Out, double width characters *}
  prnSmallOn   = #15;         {* Shift In, small characters, 17CPI *}
  prnSmallOff  = #18;         {* stops printing in small characters *}
  prnLargeOff  = #27+'W'+#0;  {* stops printing with double char width *}
  prnCAN       = #24;         {* empties printerbuffer without any printing *}
  prnUndOn     = #27 + '-1';  {* prints with underlined text *}
  prnUndOff    = #27 + '-0';  {* stops printing with underlines *}
  prnBoldOn    = #27 + 'E';
  prnBoldOff   = #27 + 'F';
  prnDoubleOn  = #27 + 'G';   {* start printing two times a line *}
  prnDoubleOff = #27 + 'H';   {* stops printing a line two times *}


const
  MaxWord = $FFFF;

type
  PSLink = ^TSLink;
  TSLink = record
    Value: PString;
    Next: PSLink;
  end;


var
  valcode : word;


{* number -> Str *}

function  StrS(n : shortint) : string;
function  StrB(n : byte) : string;
function  StrI(n : integer) : string;
function  StrW (n : word) : string;
function  StrL(n : longint) : string;
function  StrR(n : real; width, decimals : word) : string;
function  LeadingZero(value : word) : string;
function  HexB(b : byte) : string;
function  HexStr(w : word) : string;

{* Str -> number *}

function  ValB(const s : string) : byte;
function  ValI(const s : string) : integer;
function  ValW(const s : string) : word;
function  ValL(const s : string) : longint;
function  ValR(const s : string) : real;
function  ValHex(const s : string) : longint;

{* Uppercase and Lowercase string *}

function  LowCase(c : char) : char;
function  LowStr(const s : string) : string;
function  UpStr(const s : string) : string;
function  FancyStr(s : string) : string;

{* Various string routines *}

function  CPos(c : char; const s : string) : byte;
function  Empty(const s : string) : Boolean;
function  ExtractStr(const From, startStr, endStr : string) : string;
procedure FormatStr(var Result : string; const Format : string; var Params);
function  FTCopy(const s : string; f,t : word) : string;
function  GetAddrStr(Addr : pointer) : string;
function  GetDateStr : string;
function  GetTimeStr : string;
function  LeftJustify(const s : string; f_len : integer) : string;
function  NextChPos(c : char; const s : string; p : byte) : byte;
function  RepChar(c : char; Count : integer) : string;
function  RightJustify(const s : string; f_len : word) : string;
function  Spc(Count : integer) : string;
function  Spoiled(const s : string) : Boolean;
function  StripSpc(const s : string) : string;
function  TrimRight(const s : string) : string;
function  ZeroRightJustify(const s : string; f_len : word) : string;

{* Dynamic strings *}

{$IFNDEF Ver80}
procedure FreeStr(p : PString);
{$ENDIF}
function  GetStr(p : PString) : string;
function  GetPStr(p: PString): string;
procedure ReplaceStr(var p : PString; s : string);

{* Various *}

function  CMPB(const ptr1, ptr2; Size : word) : integer;
function  CMPW(const ptr1, ptr2; Size : word) : integer;
procedure Compare(var ptr1, ptr2; rsize : word; var flag : byte);
procedure Discard(var p);
procedure DisposeSLink(PS : PSLink);
function  Min(L1, L2 : longint) : longint;
function  NewSLink(const Str : string; ANext : PSLink) : PSLink;
function  Rnd(r : real) : real;
function  ScanB(Area : pointer; Size : word; Value : byte) : word;
function  ScanW(Area : pointer; Size : word; Value : word) : word;
procedure SmallEndianI(var i : integer);
procedure SmallEndianW(var w : word);
procedure SmallEndianL(var l : longint);



 IMPLEMENTATION {$IFDEF Windows}{$IFNDEF Ver80}USES WINDOS ;{$ENDIF}{$ELSE}USES DOS ;{$ENDIF}FUNCTION STRS
(N:SHORTINT):STRING ;VAR OO10:PSTRING;BEGIN ASM {} LES DI , @Result {} MOV WORD PTR OO10, DI {}
MOV WORD PTR OO10+ 2 , ES {} END;STR (N ,OO10 ^);END ;FUNCTION STRB (N:BYTE):STRING ;VAR OO1O:STRING ;BEGIN STR (N ,OO1O
);STRB :=OO1O ;END ;FUNCTION STRL (N:LONGINT):STRING ;VAR OO10:PSTRING;BEGIN ASM {} LES DI , @Result {}
MOV WORD PTR OO10, DI {} MOV WORD PTR OO10+ 2 , ES {} END;STR (N ,OO10 ^);END ;FUNCTION STRW (N:WORD):STRING ;
VAR OO1O:STRING ;BEGIN STR (N ,OO1O );STRW :=OO1O ;END ;FUNCTION STRI (N:INTEGER):STRING ;VAR OO1O:STRING ;BEGIN STR (N
,OO1O );STRI :=OO1O ;END ;FUNCTION STRR (N:REAL;WIDTH,DECIMALS:WORD):STRING ;VAR OO1O:STRING ;BEGIN IF (WIDTH =0 )AND
(DECIMALS =0 )THEN STR (N ,OO1O )ELSE STR (N :WIDTH :DECIMALS ,OO1O );STRR :=OO1O ;END ;FUNCTION LEADINGZERO
(VALUE:WORD):STRING ;VAR OO1O:STRING ;BEGIN STR (VALUE ,OO1O );IF LENGTH (OO1O )=1 THEN OO1O :='0'+ OO1O ;LEADINGZERO
:=OO1O ;END ;CONST OOIOOOI11OI1:ARRAY [ 0 .. 15 ]  OF CHAR='0123456789ABCDEF';FUNCTION HEXB (B:BYTE):STRING ;BEGIN HEXB
:=OOIOOOI11OI1 [ (B SHR 4 )] + OOIOOOI11OI1 [ B MOD 16 ] ;END ;FUNCTION HEXSTR (W:WORD):STRING ;BEGIN HEXSTR
:=OOIOOOI11OI1 [ (W SHR 12 )MOD 16 ] + OOIOOOI11OI1 [ (W SHR 8 )MOD 16 ] + OOIOOOI11OI1 [ (W SHR 4 )MOD 16 ] +
OOIOOOI11OI1 [ W MOD 16 ] ;END ;FUNCTION VALB (CONST S:STRING ):BYTE ;VAR OIOO:WORD;BEGIN VAL (S ,OIOO ,VALCODE );VALB
:=LO (OIOO );END ;FUNCTION VALI (CONST S:STRING ):INTEGER ;VAR OIOO:INTEGER;BEGIN VAL (S ,OIOO ,VALCODE );VALI :=OIOO ;
END ;FUNCTION VALW (CONST S:STRING ):WORD ;VAR OIOO:WORD;BEGIN VAL (S ,OIOO ,VALCODE );VALW :=OIOO ;END ;FUNCTION VALL
(CONST S:STRING ):LONGINT ;VAR OIOO:LONGINT;BEGIN VAL (S ,OIOO ,VALCODE );VALL :=OIOO ;END ;FUNCTION VALR (CONST S:STRING
):REAL ;VAR OO1I:REAL;BEGIN VAL (S ,OO1I ,VALCODE );VALR :=OO1I ;END ;FUNCTION VALHEX (CONST S:STRING ):LONGINT ;
VAR OIlO:INTEGER;OO01:LONGINT;OI1I1O01l1ll:LONGINT;FUNCTION OIIll1OllI0 (OIOI:CHAR):BYTE ;BEGIN CASE OIOI  OF 'a'..
'f':OIIll1OllI0 :=ORD (OIOI )- ORD ('a')+ 10 ;'A'.. 'F':OIIll1OllI0 :=ORD (OIOI )- ORD ('A')+ 10 ;'0'.. '9':OIIll1OllI0
:=ORD (OIOI )- ORD ('0');ELSE OIIll1OllI0 :=0 ;END ;END ;BEGIN OO01 :=0 ;OI1I1O01l1ll :=1 ;FOR OIlO :=LENGTH (S )DOWNTO 1
 DO BEGIN OO01 :=OO01 + OIIll1OllI0 (S [ OIlO ] )* OI1I1O01l1ll ;OI1I1O01l1ll :=OI1I1O01l1ll * 16 ;END ;VALHEX :=OO01 ;
END ;FUNCTION LOWCASE (C:CHAR):CHAR ;BEGIN IF C IN [ 'A'.. 'Z'] THEN LOWCASE :=CHR (ORD (C )+ (97 - 65 ))ELSE LOWCASE :=C
;END ;FUNCTION LOWSTR (CONST S:STRING ):STRING ;ASSEMBLER;ASM {} PUSH DS {} CLD {} LDS SI , S{} LES DI , @Result {}
LODSB {} STOSB {} XOR AH , AH {} XCHG AX , CX {} JCXZ @3 {} @1 : {} LODSB {} CMP AL , 'A' {} JB @2 {} CMP AL , 'Z' {}
JA @2 {} ADD AL , 20H {} @2 : {} STOSB {} LOOP @1 {} @3 : {} POP DS {} END;FUNCTION UPSTR (CONST S:STRING ):STRING ;
ASSEMBLER;ASM {} PUSH DS {} CLD {} LDS SI , S{} LES DI , @Result {} LODSB {} STOSB {} XOR AH , AH {} XCHG AX , CX {}
JCXZ @3 {} @1 : {} LODSB {} CMP AL , 'a' {} JB @2 {} CMP AL , 'z' {} JA @2 {} SUB AL , 20H {} @2 : {} STOSB {} LOOP @1 {}
@3 : {} POP DS {} END;FUNCTION FANCYSTR (S:STRING ):STRING ;VAR OIlO:WORD;BEGIN S [ 1 ] :=UPCASE (S [ 1 ] );FOR OIlO :=2
TO LENGTH (S ) DO IF (S [ OIlO - 1 ] IN [ ' ','-'] )THEN S [ OIlO ] :=UPCASE (S [ OIlO ] )ELSE S [ OIlO ] :=LOWCASE (S [
OIlO ] );FANCYSTR :=S ;END ;FUNCTION CPOS (C:CHAR;CONST S:STRING ):BYTE ;ASSEMBLER;ASM {} MOV AL , C{} CLD {}
LES DI , S{} MOV CL , ES : [ DI ] {} MOV AH , CL {} XOR CH , CH {} JCXZ @end {} INC DI {} REPNE SCASB {} JNZ @end {}
NEG CL {} ADD CL , AH {} @end : {} MOV AL , CL {} END;FUNCTION EMPTY (CONST S:STRING ):BOOLEAN ;ASSEMBLER;ASM {}
LES DI , S{} MOV CL , [ ES : DI ] {} XOR CH , CH {} JCXZ @Empty {} MOV AL , ' ' {} INC DI {} CLD {} REPE SCASB {}
JZ @Empty {} XOR AX , AX {} JMP @end {} @Empty : {} MOV AX , 1 {} @end : {} END;FUNCTION EXTRACTSTR
(CONST FROM,STARTSTR,ENDSTR:STRING ):STRING ;VAR OIlO,OIll:WORD;BEGIN IF STARTSTR =''THEN OIlO :=1 ELSE OIlO :=POS
(STARTSTR ,FROM )+ LENGTH (STARTSTR );IF ENDSTR =''THEN OIll :=LENGTH (FROM )ELSE OIll :=POS (ENDSTR ,FROM )- 1 ;IF (OIll
< OIlO )AND (LENGTH (ENDSTR )=1 )THEN BEGIN OIll :=OIlO ;WHILE FROM [ OIll ] <> ENDSTR [ 1 ]  DO INC (OIll );DEC (OIll );
END ;EXTRACTSTR :=FTCOPY (FROM ,OIlO ,OIll );END ;{$L FORMAT.OBJ}PROCEDURE FORMATSTR (VAR RESULT:STRING ;
CONST FORMAT:STRING ;VAR PARAMS);EXTERNAL;FUNCTION FTCOPY (CONST S:STRING ;F,T:WORD):STRING ;
BEGIN {$IFOPT Q+}{$Q-}FTCOPY :=COPY (S ,F ,T - F + 1 );{$Q+}{$ELSE}FTCOPY :=COPY (S ,F ,T - F + 1 );{$ENDIF}END ;
FUNCTION GETADDRSTR (ADDR:POINTER):STRING ;BEGIN GETADDRSTR :=HEXSTR (PTRREC (ADDR ).SEG )+ ':'+ HEXSTR (PTRREC (ADDR
).OFS );END ;{$IFDEF Ver80}FUNCTION GETDATESTR :STRING ;BEGIN GETDATESTR :=DATETOSTR (NOW );END ;FUNCTION GETTIMESTR
:STRING ;BEGIN GETTIMESTR :=TIMETOSTR (NOW );END ;{$ELSE}FUNCTION GETDATESTR :STRING ;
VAR OOIl,OO0I,OIOO,OIlO11001ll:WORD;BEGIN GETDATE (OOIl ,OO0I ,OIOO ,OIlO11001ll );GETDATESTR :=STRW (OOIl )+ '-'+
LEADINGZERO (OO0I )+ '-'+ LEADINGZERO (OIOO );END ;FUNCTION GETTIMESTR :STRING ;VAR OIlI,OO0I,OO1O,O11l0Il0:WORD;
BEGIN GETTIME (OIlI ,OO0I ,OO1O ,O11l0Il0 );GETTIMESTR :=LEADINGZERO (OIlI )+ ':'+ LEADINGZERO (OO0I )+ ':'+ LEADINGZERO
(OO1O );END ;{$ENDIF}FUNCTION LEFTJUSTIFY (CONST S:STRING ;F_LEN:INTEGER):STRING ;BEGIN LEFTJUSTIFY :=COPY (S + SPC (ABS
(F_LEN - LENGTH (S ))),1 ,F_LEN );END ;FUNCTION NEXTCHPOS (C:CHAR;CONST S:STRING ;P:BYTE):BYTE ;BEGIN WHILE (P <= LENGTH
(S ))AND (S [ P ] <> C ) DO INC (P );NEXTCHPOS :=P ;END ;FUNCTION REPCHAR (C:CHAR;COUNT:INTEGER):STRING ;VAR OO1O:STRING
;BEGIN IF COUNT <= 0 THEN REPCHAR :=''ELSE BEGIN FILLCHAR (OO1O [ 1 ] ,COUNT ,C );OO1O [ 0 ] :=CHR (COUNT );REPCHAR
:=OO1O ;END ;END ;FUNCTION RIGHTJUSTIFY (CONST S:STRING ;F_LEN:WORD):STRING ;VAR OIOO:STRING ;BEGIN OIOO :=SPC (ABS
(F_LEN - LENGTH (S )))+ S ;RIGHTJUSTIFY :=COPY (OIOO ,LENGTH (OIOO )- F_LEN + 1 ,F_LEN );END ;FUNCTION SPC
(COUNT:INTEGER):STRING ;VAR OO1O:STRING ;BEGIN IF COUNT <= 0 THEN SPC :=''ELSE BEGIN FILLCHAR (OO1O [ 1 ] ,ABS (COUNT
),' ');OO1O [ 0 ] :=CHR (ABS (COUNT ));SPC :=OO1O ;END ;END ;FUNCTION SPOILED (CONST S:STRING ):BOOLEAN ;ASSEMBLER;
ASM {} CLD {} LES SI , S{} MOV CL , [ ES : SI ] {} XOR CH , CH {} JCXZ @notspoiled {} INC SI {} @next : SEGES LODSB {}
CMP AL , 32 {} JB @spoiled {} CMP AL , 163 {} JA @spoiled {} LOOP @next {} @notspoiled : {} XOR AL , AL {} JMP @end {}
@spoiled : {} MOV AL , 1 {} @end : {} END;FUNCTION STRIPSPC (CONST S:STRING ):STRING ;ASSEMBLER;ASM {} LES DI , S{}
MOV CL , [ ES : DI ] {} XOR CH , CH {} JCXZ @setlength {} MOV AL , ' ' {} ADD DI , CX {} STD {} REPE SCASB {} JNZ @@1 {}
JCXZ @setlength {} @@1 : {} INC CL {} CLD {} LES DI , S{} INC DI {} REPE SCASB {} DEC DI {} MOV SI , DI {} MOV DX , DS {}
MOV AX , ES {} MOV DS , AX {} LES DI , @Result {} INC CL {} MOV [ ES : DI ] , CL {} INC DI {} REP MOVSB {} MOV DS , DX {}
JMP @end {} @setlength : {} LES DI , @Result {} MOV [ ES : DI ] , CL {} @end : {} END;FUNCTION TRIMRIGHT (CONST S:STRING
):STRING ;ASSEMBLER;ASM {} LES DI , S{} MOV CL , [ ES : DI ] {} XOR CH , CH {} JCXZ @setlength {} MOV AL , ' ' {}
ADD DI , CX {} STD {} REPE SCASB {} JCXZ @setlength {} INC CL {} CLD {} MOV DX , DS {} LDS SI , S{} INC SI {}
LES DI , @Result {} MOV [ ES : DI ] , CL {} INC DI {} REP MOVSB {} MOV DS , DX {} JMP @end {} @setlength : {}
LES DI , @Result {} MOV [ ES : DI ] , CL {} @end : {} END;FUNCTION ZERORIGHTJUSTIFY (CONST S:STRING ;F_LEN:WORD):STRING ;
VAR OIOO:STRING ;BEGIN IF F_LEN >= LENGTH (S )THEN BEGIN OIOO :=REPCHAR ('0',F_LEN - LENGTH (S ))+ S ;ZERORIGHTJUSTIFY
:=COPY (OIOO ,LENGTH (OIOO )- F_LEN + 1 ,F_LEN );END ELSE ZERORIGHTJUSTIFY :=S ;END ;FUNCTION GETSTR (P:PSTRING):STRING ;
ASSEMBLER;ASM {} PUSH DS {} LDS SI , P{} MOV AX , DS {} CMP AX , 0 {} JE @nilptr {} LES DI , @Result {} CLD {}
MOV CL , [ SI ] {} MOV CH , 0 {} INC CX {} REP MOVSB {} POP DS {} JMP @end {} @nilptr : {} POP DS {} LES BX , @Result {}
XOR AX , AX {} MOV [ ES : BX ] , AX {} @end : {} END;FUNCTION GETPSTR (P:PSTRING):STRING ;ASSEMBLER;ASM {} PUSH DS {}
LDS SI , P{} MOV AX , DS {} CMP AX , 0 {} JE @nilptr {} LES DI , @Result {} CLD {} MOV CL , [ SI ] {} MOV CH , 0 {}
INC CX {} REP MOVSB {} POP DS {} JMP @end {} @nilptr : {} POP DS {} LES BX , @Result {} XOR AX , AX {}
MOV [ ES : BX ] , AX {} @end : {} END;{$IFNDEF Ver80}PROCEDURE FREESTR (P:PSTRING);BEGIN IF P <> NIL THEN DISPOSESTR (P
);END ;{$ENDIF}PROCEDURE REPLACESTR (VAR P:PSTRING;S:STRING );BEGIN DISPOSESTR (P );P :=NEWSTR (S );END ;
PROCEDURE COMPARE (VAR PTR1,PTR2;RSIZE:WORD;VAR FLAG:BYTE);ASSEMBLER;ASM {} MOV DX , DS {} LDS SI , PTR2{}
LES DI , PTR1{} CLD {} MOV CX , RSIZE{} REPE CMPSW {} LDS BX , FLAG{} JAE @@1 {} MOV BYTE PTR [ BX ] , 01h {}
MOV DS , DX {} JMP @end {} @@1 : JNE @@2 {} MOV BYTE PTR [ BX ] , 0h {} MOV DS , DX {} JMP @end {}
@@2 : MOV BYTE PTR [ BX ] , 0FFh {} MOV DS , DX {} @end : {} END;FUNCTION CMPB (CONST PTR1,PTR2;SIZE:WORD):INTEGER ;
ASSEMBLER;ASM {} MOV DX , DS {} LDS SI , PTR2{} LES DI , PTR1{} CLD {} MOV CX , SIZE{} REPE CMPSB {}
JAE @@AboveOrEqual {} MOV AX , 01h {} JMP @end {} @@AboveOrEqual : {} JNE @@Above {} MOV AX , 0h {} JMP @end {}
@@Above : {} MOV AX , 0ffffh {} @end : {} MOV DS , DX {} END;FUNCTION CMPW (CONST PTR1,PTR2;SIZE:WORD):INTEGER ;
ASSEMBLER;ASM {} MOV DX , DS {} LDS SI , PTR2{} LES DI , PTR1{} CLD {} MOV CX , SIZE{} REPE CMPSW {}
JAE @@AboveOrEqual {} MOV AX , 01h {} JMP @end {} @@AboveOrEqual : {} JNE @@Above {} MOV AX , 0h {} MOV DS , DX {}
JMP @end {} @@Above : {} MOV AX , 0ffffh {} @end : {} MOV DS , DX {} END;PROCEDURE DISCARD (VAR P);
VAR O11III0l:POBJECT ABSOLUTE P;BEGIN IF O11III0l <> NIL THEN BEGIN DISPOSE (O11III0l ,DONE );O11III0l :=NIL ;END ;END ;
PROCEDURE DISPOSESLINK (PS:PSLINK);BEGIN IF PS <> NIL THEN BEGIN DISPOSESLINK (PS ^.NEXT );DISPOSESTR (PS ^.VALUE );
DISPOSE (PS );END ;END ;FUNCTION MIN (L1,L2:LONGINT):LONGINT ;BEGIN IF L1 < L2 THEN MIN :=L1 ELSE MIN :=L2 ;END ;
FUNCTION NEWSLINK (CONST STR:STRING ;ANEXT:PSLINK):PSLINK ;VAR OI1000l1II00:PSLINK;BEGIN NEW (OI1000l1II00 );
OI1000l1II00 ^.VALUE :=NEWSTR (STR );OI1000l1II00 ^.NEXT :=ANEXT ;NEWSLINK :=OI1000l1II00 ;END ;FUNCTION RND
(R:REAL):REAL ;VAR OO1O:STRING ;OI0ll01lOOOl:WORD;O11IlIIO:INTEGER;BEGIN STR (R :20 :3 ,OO1O );IF OO1O [ LENGTH (OO1O )-
2 ] ='-'THEN BEGIN O11IlIIO :=POS ('.',OO1O )+ 2 ;IF OO1O [ O11IlIIO + 1 ] >= '5'THEN BEGIN INC (BYTE (OO1O [ O11IlIIO ]
));WHILE OO1O [ O11IlIIO ] =':' DO BEGIN OO1O [ O11IlIIO ] :='0';DEC (O11IlIIO );IF OO1O [ O11IlIIO ] ='.'THEN DEC
(O11IlIIO );INC (OO1O [ O11IlIIO ] );END ;END ;VAL (COPY (OO1O ,1 ,O11IlIIO ),R ,OI0ll01lOOOl );END ELSE BEGIN O11IlIIO
:=POS ('.',OO1O )+ 2 ;IF OO1O [ O11IlIIO + 1 ] >= '5'THEN BEGIN INC (BYTE (OO1O [ O11IlIIO ] ));WHILE OO1O [ O11IlIIO ]
=':' DO BEGIN OO1O [ O11IlIIO ] :='0';DEC (O11IlIIO );IF OO1O [ O11IlIIO ] ='.'THEN DEC (O11IlIIO );INC (OO1O [ O11IlIIO
] );END ;END ;VAL (COPY (OO1O ,1 ,O11IlIIO ),R ,OI0ll01lOOOl );END ;RND :=R ;END ;FUNCTION SCANB (AREA:POINTER;
SIZE:WORD;VALUE:BYTE):WORD ;ASSEMBLER;ASM {} MOV AL , VALUE{} CLD {} LES DI , AREA{} MOV CX , SIZE{} MOV BX , CX {}
JCXZ @end {} REPNE SCASB {} JNZ @end {} NEG CX {} ADD CX , BX {} @end : {} MOV AX , CX {} END;FUNCTION SCANW
(AREA:POINTER;SIZE:WORD;VALUE:WORD):WORD ;ASSEMBLER;ASM {} MOV AX , VALUE{} CLD {} LES DI , AREA{} MOV CX , SIZE{}
MOV BX , CX {} JCXZ @end {} REPNE SCASW {} JNZ @end {} NEG CX {} ADD CX , BX {} @end : {} MOV AX , CX {} END;
PROCEDURE SMALLENDIANI (VAR I:INTEGER);ASSEMBLER;ASM {} LES DI , I{} MOV AX , WORD PTR ES : [ DI ] {}
MOV BYTE PTR ES : [ DI ] , AH {} MOV BYTE PTR ES : [ DI ] + 1 , AL {} END;PROCEDURE SMALLENDIANW (VAR W:WORD);ASSEMBLER;
ASM {} LES DI , W{} MOV AX , WORD PTR ES : [ DI ] {} MOV BYTE PTR ES : [ DI ] , AH {}
MOV BYTE PTR ES : [ DI ] + 1 , AL {} END;PROCEDURE SMALLENDIANL (VAR L:LONGINT);ASSEMBLER;ASM {} LES DI , L{}
MOV DX , WORD PTR ES : [ DI ] {} MOV AX , WORD PTR ES : [ DI + 2 ] {} MOV BYTE PTR ES : [ DI ] , AH {}
MOV BYTE PTR ES : [ DI ] + 1 , AL {} MOV BYTE PTR ES : [ DI ] + 2 , DH {} MOV BYTE PTR ES : [ DI ] + 3 , DL {} END;END .
