program LZ;
{$IFDEF WINDOWS}
	{$M 8192,32000}
{$ELSE}
	{$IFDEF DPMI}
	{$M 1024}

	{$ELSE}
	{$M 1024,60000,60000}

	{$ENDIF}
{$ENDIF}


uses
	{$ifdef windows}
	windos,wincrt,
	{$else}
	crt,dos,

	{$endif}

	LZH;


var
	infile,outfile: file;
	s: String[60];
	Hufmode : boolean;

procedure Error (msg: String);
begin
	writeln(msg);
	HALT(1)
end;

{$F+}

  procedure ReadNextBlock; {This routine handles reading of input data}

  begin

	If Hufmode then write('.'{LZHMem^.textsize,#13});
	{    LZHMem^.inptr:= 0;  }
	BlockRead(infile,LZHMem^.inbuf,sizeof(LZHMem^.inbuf),LZHMem^.inend);
	if IoResult>0 then Error('! Error reading input file');
  end;

  procedure WriteNextBlock; {This routine handles reading of output data}
  var
	wr: word;
	x,y	: byte;
  begin

	BlockWrite(outfile,LZHMem^.outbuf,LZHMem^.outptr,wr);
	If Not Hufmode then write('o');
	if (IoResult>0) or (wr<LZHMem^.outptr) then Error('! Error writing output file');
	end;

procedure OpenInput (fn: String);
var
	ior :word;
begin
	assign(infile,fn);reset(infile,1);
	if IoResult>0 then Error('! Can''t open input file :');
end;

  procedure OpenOutput (fn: String);
  begin

    assign(outfile,fn); rewrite(outfile,1);
    if IoResult>0 then Error('! Can''t open output file');
    LZHMem^.outend:= sizeof(LZHMem^.Outbuf);
  end;

Var
   test : Word;
   RData  : Byte;

begin
	{$ifdef WINDOWS}
	Initwincrt;
	{$endif}
	 Hufmode := false;
	 Writeln ('Huffman Compression Engine v',EngineVer);

	 if ParamCount<>3 then begin
		writeln('Usage: lz e(ncode)|d(ecode) infile outfile');
		Writeln ('Press any key to exit.');
		readkey;
		{$ifdef WINDOWS}
		donewincrt;
		{$endif}
		HALT(1);
	 end;
	 WriteFromBuffer:= WriteNextBlock;
	 ReadToBuffer:= ReadNextBlock;
	 InitLZH;    {This routine should be called before any LZHMem calls}

	 OpenInput(ParamStr(2));
	 OpenOutput(ParamStr(3));
	 s:= ParamStr(1);
	 case s[1] of
		  'e','E': Begin
						Hufmode := true;
						LZHMem^.Ebytes:= filesize(infile);
						Writeln (LZHMem^.Ebytes);
						Encode;     {Call black box routine to compress}
						Writeln (#13,#10,'input:  ', LZHMem^.textsize, ' bytes');
						Writeln ('output: ', LZHMem^.codesize, ' bytes');
						Writeln ('relative output: ', LZHMem^.codesize*100 div LZHMem^.textsize, '%');

						End;
	 'd','D': Decode   {Call routine to decompress}
   else
	 Error('! Use [D] for Decode or [E] for Encode')
   end;
   close(infile); if IoResult>0 then Error('! Error closing input file');
   close(outfile); if IoResult>0 then Error('! Error closing output file');

   DInitLZH;

   {$ifdef WINDOWS}
   donewincrt;
   {$endif}

end.
