unit      MagicDlg;

{ Magic Dialogs by Edwin Groothuis

  Gives you the possibility to create a dialog with a hot key.
  If this key is pressed, you get an other text in the dialogbox,
  just like the about-boxes in TP6/TP7/BP7/BC2/BC3 etc.

  For usage please see the files DLGTEST.PAS.

  There are two different Magic Dialog boxes:
  1. A dialogbox with a static text. This text will be placed there
     when the hotkey is pressed.
     type      PStaticMagicDialog=^TStaticMagicDialog;
               TStaticMagicDialog=object(TMagicDialog)
                               constructor Init(R:TRect;S:String;Key:word);
                               procedure HandleEvent(var E:TEvent);virtual;
                               procedure Draw;virtual;
                               function  GetMagicText(i:word):string;virtual;
                               function  GetNormalText(i:word):string;virtual;
                               function  NumberOfLines:word;virtual;
                               function  FreeLines:word;virtual;
                             end;
     Init: key is the keycode as returned from GetAltChar or GetCtrlChar.
     GetMagicText: returns the MAGIC text on the i-th line (starts from 0)
     GetNormalText: returns the NORMAL text on the i-th line (starts from 0)
                    note: this one can't be longer than the number of
                          freelines!
     NumberOfLines: returns the maximum of the number of lines in the
                    text.
     FreeLines: returns the number of available lines in the dialogbox.


  2. A dialogbox with a moving text. This text will scroll until the last
     line is reached and restarts from the beginning.
     type      PMovingMagicDialog=^TMovingMagicDialog;
               TMovingMagicDialog=object(TMagicDialog)
                               PrevSec:word;
                               Tick:byte;
                               constructor Init(R:TRect;S:String;Key:word);
                               procedure HandleEvent(var E:TEvent);virtual;
                               procedure Draw;virtual;
                               function  GetMagicText(i:word):string;virtual;
                               function  GetNormalText(i:word):string;virtual;
                               function  NumberOfLines:word;virtual;
                               function  FreeLines:word;virtual;
                             end;
     Init: key is the keycode as returned from GetAltChar or GetCtrlChar.
     GetMagicText: returns the MAGIC text on the i-th line (starts from 0)
     GetNormalText: returns the NORMAL text on the i-th line (starts from 0)
                    note: this one can't be longer than the number of
                          freelines!
     NumberOfLines: returns the maximum of the number of lines in the
                    text.
     FreeLines: returns the number of available lines in the dialogbox.

  Note: You always have to override the methods Gettext, NumberOfLines and
        FreeLines. If you don't you'll get runtime error 211 (Call to
        abstract method).

  Questions etc. to S89405079@hsepm1.hse.nl (internet)
                 or 2:284/205.1 (fidonet)

}
interface

uses      Dialogs,Objects,Drivers;

type      PMagicDialog=^TMagicDialog;
          TMagicDialog=object(TDialog)
                         Magic:boolean;
                         MagicKey:word;
                         constructor Init(R:TRect;S:String;Key:word);

{ Note:    }             function  GetMagicText(i:word):string;virtual;
{ Override }             function  GetNormalText(i:word):string;virtual;
{ these    }             function  NumberOfLines:word;virtual;
{ ALWAYS!  }             function  FreeLines:word;virtual;
                       end;
type      PStaticMagicDialog=^TStaticMagicDialog;
          TStaticMagicDialog=object(TMagicDialog)
                               constructor Init(R:TRect;S:String;Key:word);
                               procedure HandleEvent(var E:TEvent);virtual;
                               procedure Draw;virtual;
{ Note:    }                   function  GetMagicText(i:word):string;virtual;
{ Override }                   function  GetNormalText(i:word):string;virtual;
{ these    }                   function  NumberOfLines:word;virtual;
{ ALWAYS!  }                   function  FreeLines:word;virtual;
                             end;
type      PMovingMagicDialog=^TMovingMagicDialog;
          TMovingMagicDialog=object(TMagicDialog)
                               PrevSec:word;
                               Tick:byte;
                               constructor Init(R:TRect;S:String;Key:word);
                               procedure HandleEvent(var E:TEvent);virtual;
                               procedure Draw;virtual;
{ Note:    }                   function  GetMagicText(i:word):string;virtual;
{ Override }                   function  GetNormalText(i:word):string;virtual;
{ these    }                   function  NumberOfLines:word;virtual;
{ ALWAYS!  }                   function  FreeLines:word;virtual;
                             end;

implementation

uses      Views,Dos;


{ ---------- MagicDialog ---------- }


constructor TMagicDialog.Init(R:TRect;S:String;key:word);
begin
  Magic:=false;
  MagicKey:=key;
  Inherited Init(R,S);
end;

function  TMagicDialog.GetMagicText(i:word):string;
begin
  Abstract;
end;
function  TMagicDialog.GetNormalText(i:word):string;
begin
  Abstract;
end;
function  TMagicDialog.NumberOfLines:word;
begin
  Abstract;
end;
function  TMagicDialog.FreeLines:word;
begin
  Abstract;
end;


{ ---------- MovingMagicDialog ---------- }



constructor TMovingMagicDialog.Init(R:TRect;S:String;key:word);
begin
  PrevSec:=0;
  Inherited Init(R,S,key);
  MagicKey:=key;
end;

procedure TMovingMagicDialog.HandleEvent(var E:TEvent);
var       hour,min,sec,sec100:word;
begin
  if E.What=evKeyDown then
  begin
    if E.KeyCode=MagicKey then
    begin
      magic:=true;
      GetTime(hour,min,sec,sec100);
      PrevSec:=sec;
      repeat GetTime(hour,min,sec,sec100);until sec<>PrevSec;
      PrevSec:=sec;
      Tick:=0;
      Draw;
    end else Inherited HandleEvent(E);
  end else begin
    if E.What=evNothing then
    begin
      if magic then
      begin
        GetTime(hour,min,sec,sec100);
        if sec<>PrevSec then
        begin
          PrevSec:=sec;
          tick:=(tick+1) mod NumberOfLines;
          Draw;
        end;
      end;
    end;
    Inherited HandleEvent(E);
  end;
end;

procedure TMovingMagicDialog.Draw;
var       B:TDrawBuffer;
          i:byte;
begin
  Inherited Draw;
  for i:=0 to FreeLines-1 do
  begin
    MoveChar(B,' ',GetColor(1),Size.X-1);
    if magic then
      MoveStr(B,GetMagicText((tick+i) mod NumberOfLines),GetColor(1))
    else
      MoveStr(B,GetNormalText((tick+i) mod NumberOfLines),GetColor(1));
    WriteLine(1,i+1,Size.X-2,1,B);
  end;
end;

function  TMovingMagicDialog.GetMagicText(i:word):string;
begin
  Abstract;
end;
function  TMovingMagicDialog.GetNormalText(i:word):string;
begin
  Abstract;
end;
function  TMovingMagicDialog.NumberOfLines:word;
begin
  Abstract;
end;
function  TMovingMagicDialog.FreeLines:word;
begin
  Abstract;
end;

{ ---------- StaticMagicDialog ---------- }

constructor TStaticMagicDialog.Init(R:TRect;S:String;key:word);
begin
  Inherited Init(R,S,key);
  MagicKey:=key;
end;

procedure TStaticMagicDialog.HandleEvent(var E:TEvent);
begin
  if E.What=evKeyDown then
  begin
    if E.KeyCode=MagicKey then
    begin
      magic:=true;
      Draw;
    end else Inherited HandleEvent(E);
  end else Inherited HandleEvent(E);
end;

procedure TStaticMagicDialog.Draw;
var       B:TDrawBuffer;
          i:byte;
begin
  Inherited Draw;
  for i:=0 to NumberOfLines-1 do
  begin
    MoveChar(B,' ',GetColor(1),Size.X-1);
    if magic then
      MoveStr(B,GetMagicText(i),GetColor(1))
    else
      MoveStr(B,GetNormalText(i),GetColor(1));
    WriteLine(1,i+1,Size.X-2,1,B);
  end;
end;

function  TStaticMagicDialog.GetMagicText(i:word):string;
begin
  Abstract;
end;
function  TStaticMagicDialog.GetNormalText(i:word):string;
begin
  Abstract;
end;
function  TStaticMagicDialog.NumberOfLines:word;
begin
  Abstract;
end;
function  TStaticMagicDialog.FreeLines:word;
begin
  Abstract;
end;



end.