#if !defined( __VESA_H)
#define __VESA_H

#include <tv.h>
#include "video.h"

typedef char VesaSignature[4];
typedef
  struct {
    int supported    : 1;
    int optionalInfo : 1;
    int biosOutput   : 1;
    int color        : 1;
    int graphics     : 1;
  } VesaModeAttr;

typedef
  struct {
    VesaSignature vesaSignature;
    ushort    vesaVersion;
    char     *oemStringPtr;
    uchar     capabilities[4];
    ushort   *videoModePtr;
    uchar     fill[266-0x18];
  } VesaInfoBlock;

typedef
  struct {
    VesaModeAttr  attr;
    uchar         fill1[0x11];
    ushort        width;
    ushort        height;
    uchar         charWidth;
    uchar         charHeight;
    uchar         fill2[266-0x18];
  } VesaModeInfo;


extern ushort vesaVersion;
extern Boolean vesaScanningSupported;
extern Boolean standardInfoAvailable;


Boolean getVesaInfo(VesaInfoBlock* vesaInfo);
Boolean getVesaModeInfo(ushort mode, VesaModeInfo* buffer);
void setVesaMode(ushort mode);
ushort getVesaMode();
void detectVesaVersion();
void scanVesaModes(AddModeProc addMode);
Boolean vesaScanningPossible();

#endif
