//-------------------------------------------------------
//
//   modedlg.h: Header file for modedlg.cpp
//
//-------------------------------------------------------

#if !defined( __MODEDLG_H )

#define __MODEDLG_H

#define Uses_TButton
#define Uses_TEvent
#define Uses_TDialog
#define Uses_TLabel
#define Uses_TListBox
#define Uses_TRect
#define Uses_TScrollBar
#define Uses_TStreamable
#define Uses_TStreamableClass
#define Uses_TStringCollection

#include <tv.h>
#include "toycfg.h"

#if !defined(__TListBoxRec)
  #define __TListBoxRec
  struct TListBoxRec
  {
      TCollection* collection;
      short focused;
  };
#endif


class TSelectVideoModeDialog : public TDialog
{

public:

    TSelectVideoModeDialog( );
    TSelectVideoModeDialog( StreamableInit ) :
           TDialog (streamableInit),
           TWindowInit(TSelectVideoModeDialog::initFrame) {};
    virtual void handleEvent( TEvent& );

    TListBox *videoListBox;


private:

    virtual const char *streamableName() const
        { return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TSelectVideoModeDialog& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TSelectVideoModeDialog*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TSelectVideoModeDialog& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TSelectVideoModeDialog* cl )
    { return os << (TStreamable *)cl; }



typedef
  struct {
    ushort  mode;
    uchar   columns;
    uchar   rows;
    uchar   charHeight;
    Boolean color;
  } ModeDataRec;


class TVideoList : TStreamable
{

protected:

   TVideoList(StreamableInit streamableInit) {};

public:

   static int count;
   static Boolean hasToScan;
   static ModeDataRec modes[maxVideoModes];
   // addMode adds new lines of video mode information to videoList
   static TStringCollection *list;

   static void setup();
   static void far addMode(ushort mode, ushort rows, ushort columns,
                 ushort charHeight, Boolean color);

   static ushort findSimilarVideoMode(uchar columns, uchar rows, Boolean color);

private:

    virtual const char *streamableName() const
        { return name; }

protected:

    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TVideoList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TVideoList*& cl )
    { return is >> (void *&)cl; }
inline opstream& operator << ( opstream& os, TVideoList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TVideoList* cl )
    { return os << (TStreamable *)cl; }



void wait(ushort ticks);

void selectVideoModeDialog();
void selectVideoMode(TSelectVideoModeDialog *d);


#endif  // __MODEDLG_H

