/* screen.h		SCREEN library
 * Description:
 *      Screen operations.
 * Portability: ANSI
 *                                      (c) erdy 1992
 * $Header: $
 */
#ifndef _SCREEN_H_
#       define _SCREEN_H_
#ifndef _VGAPREFIX_H_
#       include "vgaprefx.h"
#endif  _VGAPREFIX_H_
#include "image.h"              /* Include image definition */

typedef char color_t;

/*
 * Constants, options, ...
 */
/*#define ZC_PREPARED             /* Option: format of putZCompact args */
#define ZC_CMAPSIZE 64
#define ER_OUTOFMEM 1
#define ER_OUTOFMAP 2

/* Sizes of RAM animation buffer, for decoding Z4Planes image into. */
/*#ifndef Z4P_RAMWIDTH    /* Width, MUST be N*4 */
/*#ifndef Z4P_RAMHEIGHT   /* Height */

/*
 * Types:
 * ------
 */
/* Request for blocked drawings. */
typedef struct {
        unsigned        dr_seg;            /* Limb segment */
        unsigned        dr_imageo;         /* Image offset */
        int             dr_offset;         /* VRAM offset */
        int             dr_plane;          /* staring plane */
        int             dr_rows;           /* rows in image */
} draw_request;

/*
 * Globals:
 */
extern int scerror;
extern int screen_xband;   /* Horizontal screen band (hor scrolling) */
extern int screen_x;       /* Current x offset of screen frame in screen band */

/*
 * Functions:
 */
#ifdef VGA_UNCHAINED
#       define putZCompact UputZCompact
#       define getZCompact UgetZCompact
#       define getZ4Planes UgetZ4Planes
#       define putZ4Planes UputZ4Planes
#       define getZPacked  UgetZPacked
#       define putZPacked  UputZPacked
#else  VGA_UNCHAINED
#       define putZCompact CputZCompact
#       define getZCompact CgetZCompact
#       define getZ4Planes CgetZ4Planes
#       define putZ4Planes CputZ4Planes
#       define getZPacked  CgetZPacked
#       define putZPacked  CputZPacked
#endif VGA_UNCHAINED

#ifdef ZC_PREPARED
        void UputZCompact(char far *image, int mask, int offset, int rows);
        void CputZCompact(char far *image, int mask, int offset, int rows);
#else
        void UputZCompact(char far *image, int x, int y, int rows);
        void CputZCompact(char far *image, int x, int y, int rows);
#endif ZC_PREPARED

#ifndef Z4P_RAMWIDTH
void MputZ4Planes(char far *image,int rows,unsigned segment,unsigned offset,
                unsigned planewidth, unsigned char planeintl);
#else   Z4P_RAMWIDTH
void MputZ4Planes(char far *image, int rows, unsigned segment, unsigned offset);
#endif  Z4P_RAMWIDTH

Image far *CgetZCompact(unsigned int x, unsigned int y, int nc, int nr, int backcolor);
Image far *UgetZCompact(unsigned int x, unsigned int y, int nc, int nr, int backcolor);
void UputZ4Planes(char far *image, unsigned x, unsigned y, int rows);
void CputZ4Planes(char far *image, unsigned x, unsigned y, int rows);
Image far *CgetZ4Planes(unsigned int x, unsigned int y, unsigned int nc, unsigned int nr, int backcolor);
void UZ4PRequest(draw_request *dp, int nreq);
Image far *CdifZ4Planes(unsigned int x, unsigned int y,
                        unsigned int nc, unsigned int nr, char far *ptr_prim);
void CputZPacked(char far *image, unsigned x, unsigned y, int rows);
Image far *CgetZPacked(unsigned int x, unsigned int y, unsigned int nc, unsigned int nr, int backcolor);
Image far *CdifZPacked(unsigned int x, unsigned int y,
                        unsigned int nc, unsigned int nr, char far *ptr_prim);
void setPalette(char far *p);
void setPartPalette(char far *p, int first, int count);
char far *loadPalette(char *filename);
int palette(char *filename);
int storeImage(int d, Image far *Ip);
Image far * restoreImage(int d);
Image far * readZfile(char *name);
int writeZfile(char *name, Image far *);
void putImage(Image far *ip, int x, int y);
char getPixel(unsigned int x, unsigned int y);
void putPixel(unsigned int x, unsigned int y, char color);
void copyBlock(unsigned int sseg,unsigned int soff,unsigned int dseg,unsigned int doff,
        int width, int height,unsigned int ramwidth, unsigned int ramheight);
void drawRectangle(unsigned int left, unsigned int top,
                unsigned int width, unsigned int height, char color);
void fillRectangle(unsigned int left, unsigned int top,
                unsigned int width, unsigned int height, char color);
void drawHline(unsigned int left, unsigned int top, unsigned int width, char color);
void drawVline(unsigned int left, unsigned int top, unsigned int height, char color);
void hscroll(int shift);
void hscrollinit(void);
void grswitch(int);
void screenMode(int);
void copyScPage(unsigned int);
void clearScPage(unsigned int, color_t);
void screenOff(void), screenOn(void);

/* Other functions: */
void far *regetmem(void far *, unsigned long sz);
void far *getmem(unsigned long sz);
void retmem(void far *p);
long querymem(void);
#if defined(__SMALL__) || defined(__TINY__) || defined(__MEDIUM__)
int _fread(int, void far *, unsigned int);
int _fwrite(int, void far *, unsigned int);
#else
#include <io.h>
#define _fread _read
#define _fwrite _write
#endif
int _lfread(int d, void far *p, unsigned long size);
int _lfwrite(int d, void far *p, unsigned long size);
int readDump(char *filename);
void getOrigin(int *xp, int *yp, int *wp, int *hp, char bg);
extern int Scsignal;
extern int Scmode;
#endif _SCREEN_H_