/*===========================================================================
SOLAR :: Common module mailup.c
Original Author : Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This source code has been placed into the public domain.

History:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
         KJH  Created.
01/02/95 KJS  Changed fprintf() to RPrintf() for FOSSIL support.
08/02/95 KJH  Fixed; was unlinking files in current directory, not the
              user's home directory.
===========================================================================*/
/*
Function: int mail_update()
Purpose : Remove mail files from user's directory.
Return  : zero.
*/

#include <dir.h>
#include <string.h>
#include <stdio.h>
#include "..\common\fossil.h"

extern char user_path[MAXPATH];
extern char waffle_version[5];

int mail_update(char *username)
{
  char token_path[MAXPATH];
  char unlink_path[MAXPATH];
  struct ffblk ffblk;
  int done;

  if (strcmp(waffle_version,"1.64") == 0)
  {
    /* Single mail file per message named username.# */

    strcpy(token_path,user_path);
    strcat(token_path,"\\");
    strcat(token_path,username);
    strcat(token_path,".*");
  }
  else
	{
    /* Single mail file */

    strcpy(token_path,user_path);
    strcat(token_path,"\\");
    strcat(token_path,"mailbox.*");
  }

  done = findfirst(token_path,&ffblk,0);
  while (!done)
  {
    strcpy(unlink_path,user_path);
    strcat(unlink_path,"\\");
    strcat(unlink_path,ffblk.ff_name);
    unlink(unlink_path);
    done = findnext(&ffblk);   /* Get the next mailbox file */
  }
  RPrintf("Updated mailbox files %s",token_path);
  return 0;
}

