    Tough Phones 3.02
    RLW mods 16 Mar 91
::
::  -= A lean and mean platform for Pro-YAM and ZComm by Bob Willoughby =-
::
::    (...leaner and meaner if you decide to eliminate the cribsheet...)
::
::
::  This script is a plain ASCII text file, so you can edit or view it.  It
::  does require minor editing prior to use.  If that idea gives you the
::  willies, get started with Michael Ash's excellent PHOMAST.T script and
::  come back to Tough Phones for other ideas later.  Please go to the bottom
::  of this file for additional remarks.
::
::  Note:  To use this 'tuf_fons.t' script be sure to include the DOS command
::  'set phones=[path]\tuf_fons.t' in your autoexec.bat file to tell YAM or
::  ZComm where to find the script.  I actively use both YAM and ZComm, so I
::  put YAM into c:\yam and ZComm into c:\zcomm; and, I use a subdirectory
::  called \tmp in both of those directories which are used to store the log
::  files that I have YAM and ZComm maintain.
::  
::  Don't be concerned with menu and function key differences between
::  tuf_fons.t and phomast.t when you run them -- they differ because Mike
::  and I have different approaches to telecommunications.  That is an
::  important point - Pro-YAM and ZComm let you assign your function keys to
::  do whatever you want them to do, and it is surprisingly easy.  So, one
::  of the reasons this small script is tossed into the pot is to provide
::  additional examples of script writing which you can plagiarize.
::
::  A comment about comments -- after you understand this script, all lines
::  that begin with a double colon "::" may be deleted to save space and
::  speed things up (...faster load time and less sifting for Pro-YAM or
::  ZComm to do).  Also, you can scrub the cribsheet menu when you no longer
::  need that sort of quick reference crutch.  Then you can use the F3 key
::  for some other purpose.
::
::  "Commenting out" a line is simply placing a colon at the beginning of the
::  line so the comm program will not "read" that line in the script and do
::  what it says to do.  "Uncommenting" a line is just the opposite - it
::  involves deleting the colon at the beginning of the line so the script
::  can read the command(s) on that line and use them to run the program.
::
::  Well, lets get on with the actual script that does the work...

setup   port 1          :for COM1
        : port 2        :for COM2
        ena -d          :suppress the Carrier Lost msg during setup
        pv-1            :Verbose OFF (-1 shows none; 50 shows all)
        pa10000         :works fine with a 386SX at 16mhz

set:    putw "ATE0X1V1 S7=20 S11=55 S0=0\r"    :a typical modem setup string
        
        : putw "ATZ0\r"                :set Hayes 2400b stored config profile 0
        : putw "AT E1 M1 S9=07 S10=15 S11=55 S25=5\r"    :Hayes 2400b parms, RLW
        : putw "AT L0 V1 X4\r"             :set Hayes 2400 external modem, RLW
        : putw "AT V1\r"                   :set Hayes 1200 external modem, RLW

        pd1                     : turn on time stamping
        pi40                    : set redial for 40 seconds
        set mprefix ATDT        : Tone Dial
        : set mprefix ATDT1170, : Tone Dial plus call wait defeat, San Antonio
        set l "1"; set m "1"
        set quitcmd \003\336off\r       :press Alt-Q to set up auto log off
                                        :when a long file xfr is finished

    ::  Note:  I like the following color setup with EGA/VGA color monitors,
    ::         so I just uncomment the color setup and the display warpdrive
    ::         lines below as well as comment out the monochrome line when
    ::         I use a VGA monitor.  I reverse the foregoing procedure when I
    ::         use a gas plasma screen.

        : if dc p*15 p@79 pn31 pr30 pu15 ps14       :color setup
        : display warpdrive               :if CGA monitor, leave this line
                                          :commented out

        if dc pn7 pr112 pu15 ps7 p*7 p@7       :for monochrome monitor

        set disks "abcdefghijk"

    ::  If you decide to rename your phones files use the example DOS
    ::  commands below to tell YAM or ZComm where to find them...
    ::    
    ::                    set phones=c:\yam\phones.t
    ::               or   set phones=c:\zcomm\phodir.t
    ::
    ::  Defining the DOS environment variable is the most flexible method
    ::  to use, because that provides relative pathing to test other scripts.
    ::  In YAM and registered copies of ZComm you can define the location and
    ::  names of your scripts when you install the serial number password.

        display bell=visual    :Comment this line out if you like to be nagged!
                               :: (commenting out line above turns on the beep)

        echo "Resetting Function Keys"; reskeys

        set f3 "@gosub qref"            ::Call Quick Reference Screen
        set f4 "@kermit rb"             ::receive Super Kermit download
        set f5 "@accept s1 Send_ASCII_Msg: f -p %s1"
        set f6 "@accept s2 Send_Z: sz -Z /yam/%s2" :send file in /yam dir
                  : above line for use w/YAM - Comment it out if using ZComm
        : set f6 "@accept s2 Send_Z: sz -Z /zcomm/%s2" :send file in /zcomm dir
                  : Uncomment above line if using ZComm
        set f7 "@accept s3 Receive_CRCX: rc %s3"
        set f8 "@accept s4 Send_CRCX: sx %s4"
        set f9 "@keys"                   ::display func key assignments
        set helpfile "@!yhp \yam\umanh.hlp main"; set f10 "@help"
                  : above line for use w/YAM - Comment it out if using ZComm
        : set helpfile "@!yhp \zcomm\zmanh.hlp zmain"; set f10 "@help"
                  : Uncomment above line if using ZComm
        set fa5 "@kill; call -40 omen24"
        set fa6 "@kill; call -40 buerg_1"
        set fa7 "@kill; call -40 mb_1"
        set fa8 "@kill; call -40 mb_2"
        set fa9 "@kill; call -40 stump24"
        set fa10 "@kill; call -40 olde24"

        set calllog /yam/tmp/calllog  :Comment out this line if using ZComm
        set rxlog /yam/tmp/rxlog      :Comment out this line if using ZComm
        set txlog /yam/tmp/txlog      :Comment out this line if using ZComm
        set tmp /yam/tmp              :Comment out this line if using ZComm
        : set calllog /zcomm/tmp/calllog  :Uncomment this line if using ZComm
        : set rxlog /zcomm/tmp/rxlog      :Uncomment this line if using ZComm
        : set txlog /zcomm/tmp/txlog      :Uncomment this line if using ZComm
        : set tmp /zcomm/tmp              :Uncomment this line if using ZComm

        set adlopts rm     : makes Zmodem AutoDownload xfrs use the "r"
                           : (resume/Crash Recovery) option along with
                           : MobyTurbo mode of Zmodem.

::            This is an opening msg re the quick reference cribsheet.
::            Comment out the next six lines to skip the opening msg.
 echo ""
 echo ""
 echo "                    Press F3 for Quick Reference                       "
 echo ""
 echo ""
 return

qref  cls      :subroutine for quick reference "cribsheet" screen
 echo "                                                                       "
 echo "                   Bob's Pro-YAM/ZComm Cribsheet                       "
 echo "                                                                       "
 echo "F1  Exit Circular Buffer            F2  Enter Circular Buffer          "
 echo "F3  This Cribsheet                  F4  Receive Kermit Download        "
 echo "F5  Send ASCII Text                 F6  Send Zmodem Upload             "
 echo "F7  Receive CrcXmodem Download      F8  Send CrcXmodem Upload          "
 echo "F9  Show All Key Assignments        F10  Flashup Help Processor        "
 echo "Alt-1  Get DOS Command prompt       Alt-2  Get YAM Command prompt      "
 echo "                                                                       "
 echo "                                                                       "
 echo "              Most Often Called Bulletin Board Systems                 "
 echo "                   [Assigned to Alt_Function Keys]                     "
 echo "                                                                       "
 echo "aF5  Telegodzilla..Chuck Forsberg   aF6  VOR BBS          ...Vern Buerg"
 echo "aF7  Motherboard #1 ..Julie Buerg   aF8  Motherboard #2  ...Julie Buerg"
 echo "aF9  Commando Spt  ...Shane Stump   aF10  Olde Guard    ...Dick Fochler"
 echo "                                                                       "
 echo "                                                                       "
 echo ""
  return

::
::                  --- PHONE DIRECTORY ENTRIES ---
::
omen24          speed 2400  %l-503-621-3746 ena -E;t -8g :Omen Technology
omen12          speed 1200  %l-503-621-3746 ena -E;t -8g : (Telegodzilla)
: omen-voice    %l-503-621-3406\;
olde24  	speed 2400  1-512-684-4470 ena -E;t -8g  :Olde Guard
olde12  	speed 1200  1-512-684-4470 ena -E;t -8g  :Olde Guard
buerg_1         speed 2400  1-707-778-8944 ena -E;t -8g  :VOR BBS, public
buerg_112       speed 1200  1-707-778-8944 ena -E;t -8g  :VOR BBS, public
mb_1            speed 2400  1-707-778-8841 ena -E;t -8g  :Motherboard node 1
mb_2            speed 2400  1-707-778-8743 ena -E;t -8g  :Motherboard node 2
mb_112          speed 1200  1-707-778-8841 ena -E;t -8g
mb_212          speed 1200  1-707-778-8743 ena -E;t -8g
stump24         speed 2400  1-512-670-0954 ena -E;t -8g
stump12         speed 1200  1-512-670-0954 ena -E;t -8g
blacher24       speed 2400  1-202-547-2008 ena -E;t -8g  :Robert Blacher
blacher12       speed 1200  1-202-547-2008 ena -E;t -8g
::
::                  -= END OF PHONE DIRECTORY =-

::
::  Some remarks about my Tough Phones Script follow:
::
::  I use a pared down version of Tough Phones every day that is a big,
::  bad 100 or so lines and about 5,200 bytes long (I modify it all the
::  time, so the size varies a little).  Thats it -- all of it, the whole
::  enchilada!  It dispenses with the memory kicker Cheatsheet menu included
::  with this script, all commenting was eliminated, and I even sent this
::  philosophical remarks section (timeless prose though it is) to the
::  big bit bin in the sky.  All that remains in my little script is the
::  setup section, a few function key assignments, and my phone directory --
::  it does not call any external subroutine scripts and like this Tough
::  Phones Script, it has no automated features.  And, it is FAST!!
::
::  Incidentally, I would use automated logon subroutines if I had accounts
::  with CompuServe or the other timesharing outfits.
::
::  I have examined and written Pro-YAM and ZComm scripts for several
::  years and I finally decided that all I really want a script to do is
::  to fire up YAM with a few basic parameters and a phone directory.
::  Then I just light YAM's afterburners and take manual control with
::  YAM's rich command set.  I get a lot of enjoyment out of direct
::  interaction with YAM and ZComm because they are marvelously flexible --
::  I don't need or crave any more than that.  So my trimmed down version
::  of this Tough Phones Script serves my individual needs quite well.  Yes,
::  it is a Spartan approach to telecommunications, but that is the way I
::  like it.  If you want a little bedrock to use as a starting point for
::  your more sophisticated script routines, be my guest.  That is why
::  I am making Tough Phones available.
::
::  Please understand that Tough Phones is a purely personal working script
::   -- it was not designed to teach script writing or to "cover all the
::  bases" for beginners.  If you want to kickstart YAM or ZComm and burn
::  rubber right out of the blocks, you need to get things up and running
::  with Michael Ash's excellent PHOMAST.T script which is distributed
::  with Pro-YAM and ZComm or available separately as PHOMAST6.ZIP.
::
::  Writing scripts is a lot of fun and it is very satisfying.  Many examples
::  are available in SCRIPTS.ZOO which you can download from Chuck Forsberg's
::  Telegodzilla - it is in the /scripts subdirectory.
::
::  For more information, I strongly urge you to bite the bullet -- study
::  the Professional YAM manual that is furnished when you register either
::  Pro-YAM or ZComm.  Or at least read the shareware ZCOMMDOC.ZIP file
::  <..gasp..>!  You have to come to grips with the manual if you really
::  want to get the maximum benefit and power out of Pro-YAM or ZComm.  Yeah,
::  thats right...  you *know* deep down inside that is what you have to do.
::
::  In addition, you might want to subscribe to the Olde Guard (512-654-7817),
::  a bulletin board system in San Antonio, Texas that is a hangout for
::  several skillful Pro-YAM and ZComm users who enjoy swapping YAM yummies,
::  helping each other solve problems, and telling tall tales about tele-
::  communications ...<grin>.  Have a good day...
::
::                                  ...Bob
::
::++++++++++++++++++++++++++++ Thats All Folks! ++++++++++++++++++++++++++++::
