VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "DiskSort Test Utility   jerry@iss.u-net.com"
   ClientHeight    =   4230
   ClientLeft      =   1095
   ClientTop       =   1515
   ClientWidth     =   6720
   Height          =   4635
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   4230
   ScaleWidth      =   6720
   Top             =   1170
   Width           =   6840
   Begin VB.CommandButton cmdZapFile 
      Caption         =   "Zap File"
      Height          =   375
      Left            =   4800
      TabIndex        =   10
      Top             =   2760
      Width           =   1455
   End
   Begin VB.CommandButton cmdRigorousCheck 
      Caption         =   "Rigorous Check"
      Height          =   375
      Left            =   4800
      TabIndex        =   9
      Top             =   2160
      Width           =   1455
   End
   Begin VB.CommandButton cmdCheckFile 
      Caption         =   "Check File"
      Height          =   375
      Left            =   4800
      TabIndex        =   8
      Top             =   1560
      Width           =   1455
   End
   Begin VB.CommandButton cmdMakeFile 
      Caption         =   "Make Test File"
      Height          =   375
      Left            =   4800
      TabIndex        =   7
      Top             =   960
      Width           =   1455
   End
   Begin VB.CommandButton cmdSort 
      Caption         =   "Sort File Now"
      Height          =   495
      Left            =   1920
      TabIndex        =   6
      Top             =   3000
      Width           =   1575
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   1920
      TabIndex        =   2
      Text            =   "20000"
      Top             =   2250
      Width           =   1215
   End
   Begin VB.TextBox Text2 
      Height          =   285
      Left            =   1920
      TabIndex        =   1
      Text            =   "20"
      Top             =   1650
      Width           =   735
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   1920
      TabIndex        =   0
      Text            =   "TEST.DAT"
      Top             =   960
      Width           =   2175
   End
   Begin VB.Label lblTiming 
      Height          =   255
      Left            =   1920
      TabIndex        =   11
      Top             =   3840
      Width           =   1575
   End
   Begin VB.Label Label3 
      Caption         =   "No Of Records"
      Height          =   255
      Left            =   360
      TabIndex        =   5
      Top             =   2280
      Width           =   1455
   End
   Begin VB.Label Label2 
      Caption         =   "Record Length"
      Height          =   255
      Left            =   360
      TabIndex        =   4
      Top             =   1680
      Width           =   1335
   End
   Begin VB.Label Label1 
      Caption         =   "File Name"
      Height          =   255
      Left            =   360
      TabIndex        =   3
      Top             =   960
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
' ########################################################################
'
'
'
Function FileExists(Fle$) As Boolean
    
    FileExists = False
    On Local Error GoTo LAB1
    FileLen (Fle$)
    FileExists = True
LAB1:
    On Local Error GoTo 0

End Function

' ########################################################################
'
' Check that each key is => to previous key
' See Rigorous check for checking that keys are Unique
'
Private Sub cmdCheckFile_Click()

    Dim Fle$, RecLen%, Records&, Fld$, HFld$, L9&, ER%, H$
    Dim Channel, HCap$, StatCount%
    
    H$ = cmdCheckFile.Caption
    cmdCheckFile.Caption = "Checking ...."
    
    HCap$ = Caption
    
    Fle$ = Text1.Text
    RecLen = Val(Text2.Text)
    Records = Val(Text3.Text)
    Channel = FreeFile
    
    HFld$ = String(RecLen, 0)

    Open Fle$ For Input Access Read As Channel
    For L9 = 1 To Records
        Fld$ = Input(RecLen, #Channel)
        If Fld$ < HFld$ Then
           MsgBox ("Problem with record " + Str$(L9&) _
                   + Chr$(13) _
                   + "This Rec :" + Fld$ _
                   + Chr$(13) _
                   + "Prev Rec :" + HFld$)
           ER = 1
           Exit For
        End If
        
        LSet HFld$ = Fld$
        
        StatCount = StatCount + 1
        If StatCount = 1000 Then
           StatCount = 0
           Caption = Str$(L9&) + " /" + Str$(Records)
           DoEvents
        End If
    
    Next
    Close #Channel
    
    Caption = HCap$
    cmdCheckFile.Caption = H$
    
    If ER = 0 Then
       MsgBox ("File is OK")
    End If
    
End Sub

' ########################################################################
'
' Make a file of descending unique keys  999, 998, 997
'
'
Private Sub cmdMakeFile_Click()
    
    Dim Fle$, RecLen%, Records&, Fld$, Channel%, L9&, Count&, H$
    Dim StatCount%, HCap$
    
    Fle$ = Text1.Text
    RecLen = Val(Text2.Text)
    Records = Val(Text3.Text)
    Channel = FreeFile
    
    If RecLen < 4 Then
       MsgBox ("Record Length - minimum of 4 Please as we put <CRLF> on it" _
               + Chr$(13) + "(DiskSort will sort down to 1 Byte Fields)")
       Exit Sub
    End If
    
    H$ = cmdMakeFile.Caption
    cmdMakeFile.Caption = "Working..."
    
    HCap$ = Caption
    
    Open Fle$ For Output Access Write As Channel
    Fld$ = Space$(RecLen - 2)
    Count& = Records
    For L9 = 1 To Records
        RSet Fld$ = Str$(Count)
        Print #Channel, Fld$
        Count = Count - 1
        StatCount = StatCount + 1
        If StatCount = 1000 Then
           StatCount = 0
           Caption = Str$(L9&) + " /" + Str$(Records)
           DoEvents
        End If
        
        
    Next
    Close #Channel
    
    cmdMakeFile.Caption = H$
    Caption = HCap$
    
    MsgBox (Fle$ + " has been created")

End Sub
' ########################################################################
'
' Rigorous Check - Make sure all keys are > than previous
' This will (correctly) fail if the sort file contains duplicate keys
'
Private Sub cmdRigorousCheck_Click()
    Dim Fle$, RecLen%, Records&, Fld$, HFld$, L9&, ER%, H$
    Dim Channel, HCap$, StatCount%
    
    H$ = cmdCheckFile.Caption
    cmdCheckFile.Caption = "Checking ...."
    
    HCap$ = Caption
    
    Fle$ = Text1.Text
    RecLen = Val(Text2.Text)
    Records = Val(Text3.Text)
    Channel = FreeFile
    
    HFld$ = String(RecLen, 0)

    Open Fle$ For Input Access Read As Channel
    For L9 = 1 To Records
        Fld$ = Input(RecLen, #Channel)
        If Fld$ <= HFld$ Then
           MsgBox ("Problem with record " + Str$(L9&) _
                   + Chr$(13) _
                   + "This Rec :" + Fld$ _
                   + Chr$(13) _
                   + "Prev Rec :" + HFld$)
           ER = 1
           Exit For
        End If
        
        LSet HFld$ = Fld$
        
        StatCount = StatCount + 1
        If StatCount = 1000 Then
           StatCount = 0
           Caption = Str$(L9&) + " /" + Str$(Records)
           DoEvents
        End If
    
    Next
    Close #Channel
    
    Caption = HCap$
    cmdCheckFile.Caption = H$
    
    If ER = 0 Then
       MsgBox ("File is OK")
    End If

End Sub

' ########################################################################
'
' Sort the File - see SUPPORT.BAS for the DLL definition
'
Private Sub cmdSort_Click()

    Dim Fle$, RecLen%, Records&, ER%, HTime&
    
    
    
    Fle$ = Text1.Text
    RecLen = Val(Text2.Text)
    Records = Val(Text3.Text)
    
    ' #### Check the File Exists ####
    
    If FileExists(Fle$) = False Then
       MsgBox ("Actually there is no File to Sort : " + Fle$)
    End If
    
    ' #### Now Call Disk Sort ####
    
    HTime = Timer
    Call DiskSort(Fle$, RecLen, Records, ER)
    
    If ER = -1 Then
       MsgBox ("Sort Aborted by User")
    End If
    
    If ER > 0 Then
       MsgBox ("Error Returned from DiskSort ")
    End If
    
    If ER = 0 Then
       HTime = Timer - HTime
       lblTiming.Caption = Str$(HTime \ 60) + " mins " _
                           + Str$(HTime Mod 60) + " Secs"
    End If
       
End Sub

Private Sub cmdZapFile_Click()

    Dim Fle$
    
    Fle$ = Text1.Text
    If FileExists(Fle$) Then
       Kill (Fle$)
    End If

End Sub
