/***********************************************************************

                       CSA Library, Free Evaluation Version 2.0.5 
                                       Release: January 22th 1997 

       String class.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __csSTR_H
#define __csSTR_H


#include "stdlib.h"
#include "string.h"
#include "cstools.h"


////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
// It is valid to manipulate the string by optaining a pointer
// to the allocated space. E.g.: you can write a '0' (a zero)  somewhere
// in the string to make it shorter. The length() function and the
// allocation functions won't go astray.
//
// Of course, you cannot extend string in this way.

class csSTR
{
protected:

   csCHAR *s;
   int al_len;             // Number of bytes allocated (including the 0 )

public:
   int  length(void)        { return strlen(s); }
   int  xstricmp(csCHAR *s1,csCHAR *s2);

//////////////////// String manipulation ///////////////////////

   void trim(void)          { trim_string(s);     }
   void upper(void)         { str_upper(s);       }
   void lower(void)         { str_lower(s);       }
   void strip(csCHAR *f)    { str_strip(s,f);     }
   void filter(csCHAR *f)   { filter_string(s,f); }
   void replace_one(csCHAR *d,csCHAR *r) { string_replace_ones(s,d,r); }
   int  replace_all(csCHAR *d,csCHAR *r) { return string_replace(s,d,r); }
   csCHAR *find_sub(csCHAR *sub)
        {
           return strstr((csCHAR *)s,(csCHAR *)sub);
        }
   int  find_pos(csCHAR *sub)
        {
           csCHAR *p=strstr((csCHAR *)s,(csCHAR *)sub);
           return (p==NULL) ? -1: (int)(p-s);
        }

///////////////////// Constructors  ///////////////////////////
   csSTR( csSTR&);
   csSTR(uchar *);
   csSTR(csCHAR *);
   csSTR(int len);
   csSTR(void);


///////////////////// Destructor  /////////////////////////////
   virtual ~csSTR(void);


////////////////////// Operator overloading /////////////////////
   friend csSTR operator+( csSTR &s1, csSTR &s2);

   csSTR operator+( csSTR &s1);

   csCHAR & operator[](int i);  // First byte is at position 0.

   int operator!=(csCHAR *str){ return xstricmp(str,s);   }
   int operator!=( csSTR &str)  { return xstricmp(str.s,s); }
   int operator==(csCHAR *str){ return !xstricmp(str,s);   }
   int operator==( csSTR &str)  { return !xstricmp(str.s,s); }
   int operator<( csSTR &str)   { return (xstricmp(s,str.s)<0); }
   int operator<=( csSTR &str)  { return (xstricmp(s,str.s)<=0); }
   int operator>( csSTR &str)   { return (xstricmp(s,str.s)>0); }
   int operator>=( csSTR &str)  { return (xstricmp(s,str.s)>=0); }



   csSTR&  operator+=( csSTR &);
   csSTR&  operator+=( csCHAR *);
   csSTR&  operator+=( csCHAR c);
   csSTR&  operator=(uchar *);
   csSTR&  operator=(csCHAR *p)  { return operator=((uchar *)p); }
   csSTR&  operator=(uchar &);
   csSTR&  operator=(int &);
   csSTR&  operator=(long &);
   csSTR&  operator=(float &);
   csSTR&  operator=(double &);
   csSTR&  operator=( csSTR &);


////////////////////// Type casting  /////////////////////////////

   operator uchar*()   { return (uchar *)s; }
   operator csCHAR*()  { return (csCHAR *)s; }
   operator uchar()    { return *s; }
   operator int()      { return atoi(s); }
   operator long()     { return atol(s); }
   operator float()    { return (float)atof(s); }
   operator double()   { return atof(s); }



////////////////////// Allocation ///////////////////////////////

protected:
    void m_alloc(int n);      // Allocating
    void m_free(void);        // Freeing allocated memory

public:
    void alloc_min(void);     // Minimizes the amount of allocated
                              // RAM (with respect to the string length).
                              // No data is lost.
    void alloc_adjust(int l); // Adjust the allocated amount of
                              // RAM to amount l, or to the (string length +1)
                              // whatever is more.
                              // No data is lost.
    void alloc_new(int n);    // Throws away the old string and the
                              // allocated memory.
                              // Allocates n new bytes without
                              // initializing!
                              // ALL DATA IS LOST.
    void alloc_max(int n);    // Allocates n bytes if not already
                              // available.
                              // No data is lost.
    void alloc_new_max(int n);// Allocates n bytes if not already
                              // available.
                              // ALL DATA IS LOST.

};


#endif
