/*

    ExSimEck 1.4b - Extracting SIMION(tm) pa files (see below)
    Copyright (C) 1999 by Rainer Umbach (also see below)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

char    doc_3[290][75]={
"ExSimEck: ***************************************************************\n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Source:        ExSimEck.c                                      \n\0",
"ExSimEck: Version:       1.4b                                            \n\0",
"ExSimEck: Released:      January 19, 1999                                \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Author:         Rainer Umbach                                  \n\0",
"ExSimEck: Address:        TU Chemnitz                                    \n\0",
"ExSimEck:                 Institut fuer Physik                           \n\0",
"ExSimEck:                 Gasentladungs- und Ionenphysik                 \n\0",
"ExSimEck:                 D-09107 Chemnitz, F.R.G.                       \n\0",
"ExSimEck: URL:            www.tu-chemnitz.de/physik/ION                  \n\0",
"ExSimEck: aFTP:           ion.physik.tu-chemnitz.de                      \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Copyright:      1998, 1999 by the author                       \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Distribution:   This program may be distributed under the terms\n\0",
"ExSimEck:                 of the GNU Gerneral Public License (see below).\n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Documentation:  ExSimEck was written for experienced SIMION(tm)\n\0",
"ExSimEck:                 users. You should be familiar with the basic   \n\0",
"ExSimEck:                 ideas and techniques offered by this commercial\n\0",
"ExSimEck:                 software (see below). Please do read the       \n\0",
"ExSimEck:                 following hints.                               \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Acknowledgment: ExSimEck is based on the program ExSim by      \n\0",
"ExSimEck:                 Eckart Hauffler, who provided his old 1996     \n\0",
"ExSimEck:                 source code (or hack :). Thanks to Ecki!       \n\0",
"ExSimEck:                 He disclaims all copyright interests in        \n\0",
"ExSimEck:                 this newer ExSimEck version 1.4b.              \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: ***************************************************************\n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Calling sequences:                                             \n\0",
"ExSimEck: ------------------                                             \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:  ExSimEck                                - show help           \n\0",
"ExSimEck:  ExSimEck ?                              - show extended help  \n\0",
"ExSimEck:  ExSimEck <pa_file>                      - read pa header      \n\0",
"ExSimEck:  ExSimEck <option_file>                  - perform extraction  \n\0",
"ExSimEck:  ExSimEck <pa_file> <axis> <coordinate> [-<options>] [<dp>]    \n\0",
"ExSimEck:                                          - perform extraction  \n\0",
"ExSimEck: Arguments:                                                     \n\0",
"ExSimEck: ----------                                                     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:  <pa_file>              ->   pa file with extension            \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:  <option_file>          ->   recommended user interface        \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:  <axis> <coordinate>    ->   'x'  V(x=<coordinate>,y=*,z=*)    \n\0",
"ExSimEck:                              'y'  V(x=*,y=<coordinate>,z=*)    \n\0",
"ExSimEck:                              'z'  V(x=*,y=*,z=<coordinate>)    \n\0",
"ExSimEck:                              (definition of extraction plane)  \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:  -<options>             ->   '-q' for quiet loops              \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:                              '-g' for extracting geometry      \n\0",
"ExSimEck:                              '-v' for extracting V             \n\0",
"ExSimEck:                              '-e' for extracting |E|,Ex,Ey,Ez  \n\0",
"ExSimEck:                              (if none of these extraction      \n\0",
"ExSimEck:                              options is given, all are         \n\0",
"ExSimEck:                              selected)                         \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:                              '-t' for table style file output, \n\0",
"ExSimEck:                                   which automatically disables \n\0",
"ExSimEck:                                   matrix style output to files \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:                              '-c' for extracting coordinates;  \n\0",
"ExSimEck:                                   effects only matrix output   \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:                              '-r' for output of x-, y-, z-     \n\0",
"ExSimEck:                                   coordinates in mm instead of \n\0",
"ExSimEck:                                   grid units; the transfor-    \n\0",
"ExSimEck:                                   mation can be controlled by  \n\0",
"ExSimEck:                                   <dp>                         \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: <dp>                      -  value for the distance between    \n\0",
"ExSimEck:                              pixels in mm which is used for    \n\0",
"ExSimEck:                              computing gradients; if none is   \n\0",
"ExSimEck:                              given, dp=1 mm will be used       \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Option file:                                                   \n\0",
"ExSimEck: ------------                                                   \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: The option file needs to have the following structure:         \n\0",
"ExSimEck: UPPER_CASE_OPTION_NAME= <value>. All other characters are      \n\0",
"ExSimEck: not nessesary. The order of the entries is not important.      \n\0",
"ExSimEck: (See also example *.cfg file.)                                 \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: PA_PATH=                  .\\example\\     ; <pa_file>           \n\0",
"ExSimEck: PA_FILE_NAME=             noname01.pa0   ; <pa_file>           \n\0",
"ExSimEck: EXTRACTION_AXIS=          x              ; <axis> = x|y|z      \n\0",
"ExSimEck: EXTRACTION_COORDINATE=    20             ; <coordinate> = int  \n\0",
"ExSimEck: EXTRACTING_GEOMETRY=      n              ; y|n (-g option)     \n\0",
"ExSimEck: EXTRACTING_POTENTIALS=    y              ; y|n (-v option)     \n\0",
"ExSimEck: EXTRACTING_GRADIENTS=     y              ; y|n (-e option)     \n\0",
"ExSimEck: EXTRACTING_COORDINATES=   n              ; y|n (-c option)     \n\0",
"ExSimEck: QUIET_LOOPS=              n              ; y|n (-q option)     \n\0",
"ExSimEck: HIGH_PRECISION_OUTPUT=    n              ; y|n, default is n   \n\0",
"ExSimEck: OUTPUT_PATH=              c:\\tmp\\        ; default is .        \n\0",
"ExSimEck: OUTPUT_FILE_EXTENSION=    dat            ; default is dat      \n\0",
"ExSimEck: TABLE_STYLE_OUTPUT=       n              ; n|y (-t option)     \n\0",
"ExSimEck: DISTANCE_BETWEEN_PIXELS=  0.0322         ; <dp> = float        \n\0",
"ExSimEck: PRINT_REAL_COORDINATES=   n              ; n|y (-r option)     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Output files:                                                  \n\0",
"ExSimEck: -------------                                                  \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Electrodes:   MAT_ELEC.DAT -  (n x m) matrix with values       \n\0",
"ExSimEck:                                       ELEC = 1 = electrode     \n\0",
"ExSimEck:                                       ELEC = 0 = non-electrode \n\0",
"ExSimEck:               TAB_ELEC.DAT -  tabulated values x, y, z, ELEC   \n\0",
"ExSimEck:                               (for given '-R' option x, y, and \n\0",
"ExSimEck:                               z, are in units of mm for all    \n\0",
"ExSimEck:                               TAB files)                       \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Potential:    MAT_PA.DAT   -  (n x m) matrix with V values     \n\0",
"ExSimEck:               TAB_PA.DAT   -  tabulated values x, y, z, V      \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Gradients:    MAT_GA_E.DAT -  (n x m) matrix with |E| values   \n\0",
"ExSimEck:               TAB_GA_E.DAT -  tabulated values x, y, z, E      \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:               MAT_GA_X.DAT -  (n x m) matrix with Ex values    \n\0",
"ExSimEck:               TAB_GA_X.DAT -  tabulated values x, y, z, Ex     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:               MAT_GA_Y.DAT -  (n x m) matrix with Ey values    \n\0",
"ExSimEck:               TAB_GA_Y.DAT -  tabulated values x, y, z, Ey     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:               MAT_GA_Z.DAT -  (n x m) matrix with Ez values    \n\0",
"ExSimEck:               TAB_GA_Z.DAT -  tabulated values x, y, z, Ez     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Coordinates:  COO_PA_X.DAT -  vector/scalar of extracted       \n\0",
"ExSimEck:               COO_PA_Y.DAT -  coordinates for pa like files in \n\0",
"ExSimEck:               COO_PA_Z.DAT -  grid units or mm                 \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:               COO_GA_X.DAT -  vector/scalar of extracted       \n\0",
"ExSimEck:               COO_GA_Y.DAT -  coordinates for ga like files in \n\0",
"ExSimEck:               COO_GA_Z.DAT -  grid units or mm                 \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: ***************************************************************\n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Source related                                                 \n\0",
"ExSimEck: --------------                                                 \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: All tabs should be expanded to spaces. For program layout a    \n\0",
"ExSimEck: tabulator width of two characters was used.                    \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Input related                                                  \n\0",
"ExSimEck: -------------                                                  \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: This program doesn't resolve symmetries, etc., of your pa      \n\0",
"ExSimEck: file. Any pa file is treated as displayed in the SIMION(tm)    \n\0",
"ExSimEck: MODIFY menu. If SIMION(tm) indicates 'x = 20' in MODIFY, use   \n\0",
"ExSimEck: <axis>=x and <coordinate>=20 when calling ExSimEck to extract  \n\0",
"ExSimEck: that plane shown in MODIFY.                                    \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: ExSimEck should work well with .PA, .PA0,  and .PA[12345...]   \n\0",
"ExSimEck: file types. .PA# probably wont't work (untested). To be shure  \n\0",
"ExSimEck: to use the SAME pa SIMION(tm) holds in computer memory after a \n\0",
"ExSimEck: FAST ADJUST operation, SAVE .PA or .PA0 to disk.               \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: For 2d pa with cylindrical symmetry there is the possibility   \n\0",
"ExSimEck: of extracting the complete plane or a single line instead.     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: For 3d pa always a plane is extracted.                         \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: The integrity of any pa file is NOT tested by this program.    \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: This program is designed to extract potential arrays in units  \n\0",
"ExSimEck: of Volts. Extracting magnetic pa was not tested. This may      \n\0",
"ExSimEck: or may not work in a reasonable sense.                         \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Computational methods                                          \n\0",
"ExSimEck: ---------------------                                          \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: |E|, Ex, Ey, and Ez extraction is only performed on 3d pa      \n\0",
"ExSimEck: and cylindrical 2d pa. For extraction coordinates equal 1 or   \n\0",
"ExSimEck: nx, ny, nz, resp., there will be no such extraction            \n\0",
"ExSimEck: possibility.                                                   \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Ex is computed using two pa pixels: the two neighboring pixels \n\0",
"ExSimEck: x-1 and x+1 of the center pixel x. Ex is ( V(x+1) - V(x-1) )   \n\0",
"ExSimEck: / ( 2 * <dp> ). The same method is used for Ey and Ez.         \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: 3d:             |E| = SQRT( Ex^2 + Ey^2 + Ez^2 )               \n\0",
"ExSimEck: 2d cylindrical: |E| = SQRT( Ea^2 + Eb^2 )                      \n\0",
"ExSimEck:                 (a and b are coordinates in extraction plane)  \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: |E|, Ex, Ey, and Ez, will be computed in units of <dp>         \n\0",
"ExSimEck: which can be entered in the command line. If the user don't    \n\0",
"ExSimEck: supply a value, <dp> is set to 1 mm.                           \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: There is a possibility for 'binary noise' due to the           \n\0",
"ExSimEck: computing process. Don't trust very small V, |E|, Ex, Ey, Ez   \n\0",
"ExSimEck: values, e.g. in the range around some 10^(-5) %.               \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Output related                                                 \n\0",
"ExSimEck: --------------                                                 \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: All output files will be written to the current directory or   \n\0",
"ExSimEck: to the directory indicated by the option file.                 \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: No tabulated output file was tested regarding the assignment   \n\0",
"ExSimEck: of the coordinates x, y, and z, to the real SIMION(tm)         \n\0",
"ExSimEck: coordinates. The matrix output files WERE tested.              \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Use -q option to suppress output to stdout in pa scanning loop \n\0",
"ExSimEck: and computation loop. Program runs much faster.                \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: In case of missing electrodes there will be a warning.         \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: There will be no warning if one V value is different from      \n\0",
"ExSimEck: zero.                                                          \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Please remember that the decimal point is represented in the   \n\0",
"ExSimEck: output files by '.' (point). Some operating systems allows you \n\0",
"ExSimEck: to define a ',' (comma) as decimal point and the software you  \n\0",
"ExSimEck: want to use to import the ASCII data may use this definition.  \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: ***************************************************************\n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Distribution:                                                  \n\0",
"ExSimEck: -------------                                                  \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: This program is free software; you can redistribute it and/or  \n\0",
"ExSimEck: modify it under the terms of the GNU General Public License as \n\0",
"ExSimEck: published by the Free Software Foundation; either version 2 of \n\0",
"ExSimEck: the License, or (at your option) any later version.            \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: This program is distributed in the hope that it will be useful,\n\0",
"ExSimEck: but WITHOUT ANY WARRANTY; without even the implied warranty of \n\0",
"ExSimEck: MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  \n\0",
"ExSimEck: GNU General Public License for more details.                   \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: You should have received a copy of the GNU General Public      \n\0",
"ExSimEck: License along with this program; if not, write to the Free     \n\0",
"ExSimEck: Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,  \n\0",
"ExSimEck: USA.                                                           \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Contents of the version 1.4b distribution:                     \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck:     ExSimEck.c       - source code edited with RHIDE           \n\0",
"ExSimEck:     ExSimEck.doc     - instead of a documentation              \n\0",
"ExSimEck:     ExSimEck.exe     - executable program compiled with GNU C  \n\0",
"ExSimEck:     ExSimEck.cfg     - ExSimEck option file                    \n\0",
"ExSimEck:     EXAMPLE/MAT*.DAT - matrix style example output             \n\0",
"ExSimEck:     EXAMPLE/TAB*.DAT - table style example output              \n\0",
"ExSimEck:     EXAMPLE/COO*.DAT - example coordinates                     \n\0",
"ExSimEck:     COPYING          - GNU General Public Licence              \n\0",
"ExSimEck:     DISCLAIM.ER      - disclaimer of Eckart Hauffler           \n\0",
"ExSimEck:     TO_DO.TXT        - authors' future tasks                   \n\0",
"ExSimEck:     README.TXT       - first to be read                        \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: The latest version is available through the above stated       \n\0",
"ExSimEck: URL and aFTP. Allways look for sub-directory /exsimeck.        \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: All version numbers with an 'b' are test versions.             \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Hardware and software requirements                             \n\0",
"ExSimEck: ----------------------------------                             \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: The source was developed using the GNU C Compiler on a         \n\0",
"ExSimEck: 486 PC with 8 MB of RAM under MS-DOS running RHIDE.            \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: In a PC enviroment please call ExSimEck from Windows, e.g. via \n\0",
"ExSimEck: a PIF file, otherwise you may have to install a DMPI server.   \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Using a different compiler (on a different platform) might     \n\0",
"ExSimEck: or might not result in problems:                               \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: To avoid memory allocation for E related extractions please    \n\0",
"ExSimEck: use any of the -vgc options to avoid gradient extraction.      \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Bugs & improvements:                                           \n\0",
"ExSimEck: --------------------                                           \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: However, life differs from documentations: please report       \n\0",
"ExSimEck: bugs to the author (via WWW, see above).                       \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Program tests were performed by Ion Physics group members in   \n\0",
"ExSimEck: Chemnitz.                                                      \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: Warranty                                                       \n\0",
"ExSimEck: --------                                                       \n\0",
"ExSimEck:                                                                \n\0",
"ExSimEck: There is NO WARRENTY. This C code is distributed as is.        \n\0",
"ExSimEck: Please have an in-deep testing of this software extracting     \n\0",
"ExSimEck: your pa files! None of the authors is responsible for          \n\0",
"ExSimEck: wrong scientific output of this program.                       \n\0",
"ExSimEck:                                                                \n\0"
};

char    doc_1[3][74]={
"ExSimEck: Extracting geometry, V, |E|, Ex, Ey, and Ez, from a           \n\0",
"ExSimEck: SIMION(tm) pa file, Version 1.4b, by R. Umbach & E. Haufler   \n\0",
"ExSimEck: Ion Physics, TU Chemnitz, www.tu-chemnitz.de/physik/ION       \n\0"
};

char    doc_2[4][74]={
"ExSimEck: call: exsimeck ?                                              \n\0",
"ExSimEck:   or: exsimeck <pa_file>                                      \n\0",
"ExSimEck:   or: exsimeck <option_file>                                  \n\0",
"ExSimEck:   or: exsimeck <pa_file> x|y|z <coordinate> [-qgvectr] [<dp>] \n\0"
};

char    doc_4[3][74]={
"          SIMION 3D is a ION MODELING SOFTWARE by DAVID A. DAHL and is\n\0",
"          distributed by SCIENTIFIC INSTRUMENT SERVICES, INC., 1027   \n\0",
"          OLD YORK ROAD, RINGOES, NJ 08551, (908) 788-5550            \n\0"
};

char    doc_5[1][74]={
"          ExSimEck is distributed under GNU General Public Licence    \n\0"
};

/*****************/
/* pre-processor */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define PLANAR        1
#define CYLINDRICAL   0

#define MIRROR_X      1
#define MIRROR_Y      2
#define MIRROR_Z      4

#define MAGNETIC_PA   8

/***************************************/
/* global declarations und definitions */

/* functions */

void      fprintf_header1(FILE *);
void      fprintf_header2(FILE *);

void      print_line();

void      cannot_open(char *);
void      cannot_read(char *);
void      cannot_allocate(char *);

void      fclose_all();
void      free_all();

/* structures*/

struct header_type
{
  long    mode;
  long    symmetry;
  double  max_voltage;
  long    nx;
  long    ny;
  long    nz;
  long    mirror;
} header;

/* file pointer */

FILE      *fp_in_bin=0;
FILE      *fp_in_config=0;

FILE      *fp_out_tab_pa=0;
FILE      *fp_out_tab_elec=0;
FILE      *fp_out_tab_grad=0;
FILE      *fp_out_tab_grad_a=0;
FILE      *fp_out_tab_grad_b=0;
FILE      *fp_out_tab_grad_c=0;

FILE      *fp_out_mat_pa=0;
FILE      *fp_out_mat_elec=0;
FILE      *fp_out_mat_grad=0;
FILE      *fp_out_mat_grad_a=0;
FILE      *fp_out_mat_grad_b=0;
FILE      *fp_out_mat_grad_c=0;

FILE      *fp_out_coo_pa_a=0;
FILE      *fp_out_coo_pa_b=0;
FILE      *fp_out_coo_pa_c=0;

FILE      *fp_out_coo_ga_a=0;
FILE      *fp_out_coo_ga_b=0;
FILE      *fp_out_coo_ga_c=0;

/* memory pointer */

double    *plane1,*plane2,*plane3;

/* other */

char      name_pa[100];
char      axis_str[2];
char      sym[2][12]={"cylindrical\0","planar\0"};
char      mir[7][16]={"no mirror\0","mirror in x\0","mirror in y\0",
                      "mirror in x,y\0","mirror in z\0","mirror in x,z\0",
                      "mirror in x,y,z\0"};
char      pa_type[2][9]={"electric\0","magnetic\0"};

long      c_grad=0;

double    gu=1.0;

/****************/
/* main program */

main(int argc, const char * argv[])
{

  /********************************/
  /* declarations and definitions */

  int       axis=0,z2,argn;
  int       quiet=0;
  int       no_e_computing=0,no_ec_computing=0,real_coordinates=0;
  int       patch_no_e_computing=0;
  int       all_v_equal_0=1,all_elec_equal_0=1;
  int       extract_V=1,extract_E=1,extract_G=1;
  int       extract_all=1;
  int       output_M=1,output_T=0, output_C=0;
  int       config_test=0;
  int       number_of_warnings=0, ouput_high_precision=0;

  long      i,x,y,z;
  long      a_max,b_max,c_max;
  long      a_grad,b_grad,a_start,a_stop,b_start,b_stop;
  long      c_help_1,c_help_2;
  long      matrix_element_a=0,matrix_element_b=0,matrix_element_c=0;
  long      matrix_element=0;

  char      *a;
  double    z1;

  double    grad_a,grad_b,grad_c,grad;

  char      name[100],path_pa[100]=".\\\0",path_out[100]=".\\\0",ext_out[4]="dat\0";
  char      name_tab_pa[10]="tab_pa.\0";
  char      name_mat_pa[10]="mat_pa.\0";

  char      name_tab_elec[10]="tab_elec.\0";
  char      name_mat_elec[10]="mat_elec.\0";

  char      name_tab_ga[10]="tab_ga_e.\0";
  char      name_tab_a[10]="tab_ga_z.\0";
  char      name_tab_b[10]="tab_ga_y.\0";
  char      name_tab_c[10]="tab_ga_x.\0";
  char      name_mat_ga[10]="mat_ga_e.\0";
  char      name_mat_a[10]="mat_ga_z.\0";
  char      name_mat_b[10]="mat_ga_y.\0";
  char      name_mat_c[10]="mat_ga_x.\0";

  char      name_pa_a[10]="coo_pa_z.\0";
  char      name_pa_b[10]="coo_pa_x.\0";
  char      name_pa_c[10]="coo_pa_y.\0";
  char      name_ga_a[10]="coo_ga_z.\0";
  char      name_ga_b[10]="coo_ga_y.\0";
  char      name_ga_c[10]="coo_ga_x.\0";

  char      output_style[2][4]={"MAT\0","TAB\0"};
  char      coord_type[2][6]={"pixel\0","real\0"};

  char      axis_a[2]="x\0",axis_b[2]="y\0",axis_c[2]="z\0";

  char      arg1[100],arg2[100],arg3[100],arg4[100]="-",arg5[100];
  char      option_str[10]="-qgvectr\0",option_test[2]="-\0";
  char      config_str[100];

  /*******************************/
  /* command line interpretation */

  argn=argc;
  if (argn>=2) strcpy(arg1, argv[1]);
  if (argn>=3) strcpy(arg2, argv[2]);
  if (argn>=4) strcpy(arg3, argv[3]);
  if (argn>=5) strcpy(arg4, argv[4]);
  if (argn==6) strcpy(arg5, argv[5]);

  if (argn==1)                            /* only program name was given */
  {
     print_line();
     for (i=1;i<=sizeof(doc_1)/74;i++)    /* print welcomce sequence */
         printf("%s",doc_1[i-1]);
     print_line();
     for (i=1;i<=sizeof(doc_5)/74;i++)    /* print GNU notice */
         printf("%s",doc_5[i-1]);
     print_line();
     for (i=1;i<=sizeof(doc_4)/74;i++)    /* print SIMION(tm) notice */
         printf("%s",doc_4[i-1]);
     print_line();
     for (i=1;i<=sizeof(doc_2)/74;i++)    /* print short help */
         printf("%s",doc_2[i-1]);
     print_line();
     fclose_all(); free_all(); return(0);
  };

  if (argn>1)                            /* more than program name was given */
    {
      strcpy(name_pa, arg1);

      if (!strcmp(name_pa,"?"))         /* print extended help */
      {
        for (i=1;i<=sizeof(doc_3)/75;i++)
            printf("%s",doc_3[i-1]);
        print_line();
        for (i=1;i<=sizeof(doc_4)/74;i++)    /* print SIMION(tm) notice */
            printf("%s",doc_4[i-1]);
        print_line();
        fclose_all(); free_all(); return(0);
      }
      else
      {
          print_line();
          for (i=1;i<=sizeof(doc_1)/74;i++)   /* print welcomce sequence */
              printf("%s",doc_1[i-1]);
          print_line();

          if (strstr(name_pa,".cfg"))  /* read configuration file */
          {
             if ( !(fp_in_config=fopen(name_pa,"rt")) )
                { cannot_open(name_pa); fclose_all(); return(-1); };

             printf("ExSimEck: Using option file %s\n",strupr(name_pa));
             print_line();
             strcpy(name_pa,"noname01.pa0\0");
             strcpy(arg2,"x\0");
             strcpy(arg3,"1\0");

             while(!feof(fp_in_config))
             {
                fscanf(fp_in_config,"%s",config_str);

                     if (strstr(config_str,"PA_PATH="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(path_pa,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"PA_FILE_NAME="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(name_pa,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"EXTRACTION_AXIS="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(arg2,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"EXTRACTION_COORDINATE="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(arg3,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"EXTRACTING_GEOMETRY="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"g");
                         config_test++;
                     }
                else if (strstr(config_str,"EXTRACTING_POTENTIALS="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"v");
                         config_test++;
                     }
                else if (strstr(config_str,"EXTRACTING_GRADIENTS="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"e");
                         config_test++;
                     }
                else if (strstr(config_str,"EXTRACTING_COORDINATES="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"c");
                         config_test++;
                     }
                else if (strstr(config_str,"QUIET_LOOPS="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"q");
                         config_test++;
                     }
                else if (strstr(config_str,"HIGH_PRECISION_OUTPUT="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            ouput_high_precision=1;
                         config_test++;
                     }
                else if (strstr(config_str,"OUTPUT_PATH="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(path_out,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"OUTPUT_FILE_EXTENSION="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(ext_out,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"TABLE_STYLE_OUTPUT="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"t");
                         config_test++;
                     }
                else if (strstr(config_str,"DISTANCE_BETWEEN_PIXELS="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         strcpy(arg5,config_str);
                         config_test++;
                     }
                else if (strstr(config_str,"PRINT_REAL_COORDINATES="))
                     {
                         fscanf(fp_in_config,"%s",config_str);
                         if (strstr(config_str,"y"))
                            strcat(arg4,"r");
                         config_test++;
                     };
             };
             fclose(fp_in_config);
             if (config_test==14)
             {
                printf("ExSimEck: WARNING: MISSING ENTRY IN OPTION FILE, USE DEFAULT\n");
                print_line();
                number_of_warnings++;
             }
             else if (config_test<14)
             {
                printf("ExSimEck: WARNING: MISSING ENTRIES IN OPTION FILE, USE DEFAULTS\n");
                print_line();
                number_of_warnings++;
             };
          strcpy(arg1,path_pa);
          strcat(arg1,name_pa);
          strcpy(name_pa,arg1);
          argn=6;
          };
      };

      if ( !(fp_in_bin=fopen(name_pa,"rb")) )
         { cannot_open(name_pa); fclose_all(); return(-1); };
      printf("ExSimEck: PA file: %s\n", name_pa);

      a=(char *) &header;
      for (i=0;i<4*sizeof(double);i++)
      fscanf(fp_in_bin,"%c",&a[i]);

      printf("ExSimEck: PA file header: maximum voltage=%lg, nx=%ld, ny=%ld, nz=%ld,\n",
             header.max_voltage,header.nx,header.ny,header.nz);
      printf("ExSimEck:                 %s, %s, %s\n",
             sym[header.symmetry],mir[(header.mirror&(MIRROR_X|MIRROR_Y|MIRROR_Z))], 
             pa_type[((header.mirror&MAGNETIC_PA)==MAGNETIC_PA)]);
      print_line();

      if (header.mirror&MAGNETIC_PA)
      {
          printf("ExSimEck: WARNING: PROGRAM IS DESIGNED FOR ELECTRIC PA\n");
          print_line();
          number_of_warnings++;
      };
      if (header.nx>=3 && header.ny>=3 && header.nz==1 && header.symmetry==CYLINDRICAL)
      {
        no_ec_computing=1;
      }
      else if (header.nx<3 || header.ny<3 || header.nz<3)
      {
        printf("ExSimEck: WARNING: PA WITH N[X|Y|Z] >= 3 IS REQUIRED FOR GRADIENTS\n");
        print_line();
        number_of_warnings++;
        no_e_computing=1;
      };

    };

  if (argn==2)            /* only program name and pa file were given */
     { fclose_all(); return(-1); };

  strcpy(axis_str,arg2);
       if (!strcmp(axis_str,"x")) axis=1;
  else if (!strcmp(axis_str,"y")) axis=2;
  else if (!strcmp(axis_str,"z")) axis=3;
  if (axis==0)
    {
      printf("ExSimEck: ERROR: USE X, Y, OR Z, FOR SECOND ARGUMENT\n");
      print_line();
      fclose_all(); return(-1);
    };

  if (argn>=3)    /* (nearly) all arguments were given */
    {
      if (argn>=4)
        c_grad=atol(arg3);
      if (axis==1) /* x */
        {
          a_max=header.ny;
          b_max=header.nz;
          c_max=header.nx;
          strcpy(name_mat_a,"mat_ga_z.\0");
          strcpy(name_mat_b,"mat_ga_y.\0");
          strcpy(name_mat_c,"mat_ga_x.\0");
          strcpy(name_tab_a,"tab_ga_z.\0");
          strcpy(name_tab_b,"tab_ga_y.\0");
          strcpy(name_tab_c,"tab_ga_x.\0");
          strcpy(name_pa_a,"coo_pa_z.\0");
          strcpy(name_pa_b,"coo_pa_y.\0");
          strcpy(name_pa_c,"coo_pa_x.\0");
          strcpy(name_ga_a,"coo_ga_z.\0");
          strcpy(name_ga_b,"coo_ga_y.\0");
          strcpy(name_ga_c,"coo_ga_x.\0");
          strcpy(axis_a,"z\0");
          strcpy(axis_b,"y\0");
          strcpy(axis_c,"x\0");
        }
      else if (axis==2)  /* y */
        {
          a_max=header.nx;
          b_max=header.nz;
          c_max=header.ny;
          strcpy(name_mat_a,"mat_ga_z.\0");
          strcpy(name_mat_b,"mat_ga_x.\0");
          strcpy(name_mat_c,"mat_ga_y.\0");
          strcpy(name_tab_a,"tab_ga_z.\0");
          strcpy(name_tab_b,"tab_ga_x.\0");
          strcpy(name_tab_c,"tab_ga_y.\0");
          strcpy(name_pa_a,"coo_pa_z.\0");
          strcpy(name_pa_b,"coo_pa_x.\0");
          strcpy(name_pa_c,"coo_pa_y.\0");
          strcpy(name_ga_a,"coo_ga_z.\0");
          strcpy(name_ga_b,"coo_ga_x.\0");
          strcpy(name_ga_c,"coo_ga_y.\0");
          strcpy(axis_a,"z\0");
          strcpy(axis_b,"x\0");
          strcpy(axis_c,"y\0");
        }
      else if (axis==3) /* z */
        {
          a_max=header.nx;
          b_max=header.ny;
          c_max=header.nz;
          strcpy(name_mat_a,"mat_ga_y.\0");
          strcpy(name_mat_b,"mat_ga_x.\0");
          strcpy(name_mat_c,"mat_ga_z.\0");
          strcpy(name_tab_a,"tab_ga_y.\0");
          strcpy(name_tab_b,"tab_ga_x.\0");
          strcpy(name_tab_c,"tab_ga_z.\0");
          strcpy(name_pa_a,"coo_pa_y.\0");
          strcpy(name_pa_b,"coo_pa_x.\0");
          strcpy(name_pa_c,"coo_pa_z.\0");
          strcpy(name_ga_a,"coo_ga_y.\0");
          strcpy(name_ga_b,"coo_ga_x.\0");
          strcpy(name_ga_c,"coo_ga_z.\0");
          strcpy(axis_a,"y\0");
          strcpy(axis_b,"x\0");
          strcpy(axis_c,"z\0");
        };

      if ((c_grad == 1 || c_grad == c_max) && !no_e_computing && !no_ec_computing)
        {
          patch_no_e_computing=1;
          no_e_computing=1;
        }
      else if (c_grad < 1 || c_grad > c_max)
        {
          if (c_max ==1)
            {
              printf("ExSimEck: ERROR: USE <COORDINATE>=1 FOR THIRD ARGUMENT\n");
            }
          else
            {
              printf("ExSimEck: ERROR: USE <COORDINATE> IN [1, %ld] FOR THIRD ARGUMENT\n",c_max);
            };
          print_line();
          fclose_all(); return(-1);
        };
    };
    if (no_ec_computing && (axis==1 || axis==2))
    {
       no_e_computing=1;
       if (extract_E)
       {
          printf("ExSimEck: WARNING: FOR LINE EXTRACTION YOU WON'T GET GRADIENTS\n");
          print_line();
          number_of_warnings++;
       };
    };

  if (argn>=5)
    {
      strcpy(option_str,arg4);

      *option_test = *(option_str + 0);
      if (!strncmp(option_test,"-",1))
      {

      for (i=1;i<strlen(option_str);i++)
      {
        *option_test = *(option_str + i);

             if (!strcmp(option_test,"g")) extract_all=0;
        else if (!strcmp(option_test,"v")) extract_all=0;
        else if (!strcmp(option_test,"e")) extract_all=0;
      };
      if (!extract_all)
      {
         extract_V=0; extract_E=0; extract_G=0;
      }
      else
      {
          printf("ExSimEck: Asuming complete extraction: will use -gve options.\n");
          print_line();
      };

      for (i=1;i<strlen(option_str);i++)
      {
        *option_test = *(option_str + i);
             if (!strcmp(option_test,"q"))   quiet=1;
        else if (!strcmp(option_test,"g"))   extract_G=1;
        else if (!strcmp(option_test,"v"))   extract_V=1;
        else if (!strcmp(option_test,"e"))   extract_E=1;
        else if (!strcmp(option_test,"c"))   output_C=1;
        else if (!strcmp(option_test,"t")) { output_T=1; output_M=0; }
        else if (!strcmp(option_test,"r"))   real_coordinates=1;
      };

      if (!extract_E)
         no_e_computing=1;
      else
      {
         if (patch_no_e_computing)
         {
           printf("ExSimEck: WARNING: <COORDINATE>=%ld => WON'T COMPUTE |E|,Ex,Ey,Ez\n",c_grad);
           print_line();
           number_of_warnings++;
         }
      };
      if (output_T && output_C)
      {
         printf("ExSimEck: WARNING: -C OPTION HAS NO EFFECT\n");
         print_line();
         number_of_warnings++;
         output_C=0;
      };
      }

      else
      {
        gu = atof(arg4);
        if (!gu)
           gu = 1.0;
        else if (!real_coordinates)
        {
           if (output_C)
           {
              printf("ExSimEck: WARNING: DUE TO MISSING -R OPTION <DP> EFFECTS NO COORDINATES\n");
              print_line();
              number_of_warnings++;
           };
        };
      };

    };

    if (argn==6)
    {
      gu = atof(arg5);
      if (!gu)
         gu = 1.0;
      else  if (!real_coordinates)
      {
         if (output_C)
         {
           printf("ExSimEck: WARNING: DUE TO MISSING -R OPTION <DP> EFFECTS NO COORDINATES\n");
           print_line();
           number_of_warnings++;
         };
      };
    };

  /*****************/
  /* initial files */

  if (extract_V)      /* extract potential */
  {
    if (output_T)     /*          as table */
    {
      strcpy(name,path_out); strcat(name,name_tab_pa); strcat(name,ext_out);
      if ( !(fp_out_tab_pa=fopen(name,"wt")) )
         { cannot_open(name_tab_pa); fclose_all(); return(-1); }
      else
         { fprintf_header1(fp_out_tab_pa);
           fprintf(fp_out_tab_pa,"/* Columns in this file: %s coordinates x, y, and z, V\n",coord_type[real_coordinates]);
           fprintf_header2(fp_out_tab_pa); };
    };

    if (output_M)     /*         as matrix */
    {
      strcpy(name,path_out); strcat(name,name_mat_pa); strcat(name,ext_out);
      if ( !(fp_out_mat_pa=fopen(name,"wt")) )
         { cannot_open(name_mat_pa); fclose_all(); return(-1); }
      else
         { fprintf_header1(fp_out_mat_pa);
           fprintf(fp_out_mat_pa,"/* Dimensions of matrix in this file: %ld x %ld; elements: V\n",a_max,b_max);
           fprintf_header2(fp_out_mat_pa); };
    };
  };

  if (extract_G)      /* extract geometry */
  {
    if (output_T)     /*         as table */
    {
      strcpy(name,path_out); strcat(name,name_tab_elec); strcat(name,ext_out);
      if ( !(fp_out_tab_elec=fopen(name,"wt")) )
         { cannot_open(name_tab_elec); fclose_all(); return(-1); }
      else
         { fprintf_header1(fp_out_tab_elec);
           fprintf(fp_out_tab_elec,"/* Columns in this file: %s coordinates x, y, and z, ELEC (y,n)\n",coord_type[real_coordinates]);
           fprintf_header2(fp_out_tab_elec); };
    };

    if (output_M)     /*        as matrix */
    {
      strcpy(name,path_out); strcat(name,name_mat_elec); strcat(name,ext_out);
      if ( !(fp_out_mat_elec=fopen(name,"wt")) )
         { cannot_open(name_mat_elec); fclose_all(); return(-1); }
      else
         { fprintf_header1(fp_out_mat_elec);
           fprintf(fp_out_mat_elec,"/* Dimensions of matrix in this file: %ld x %ld; elements: ELEC (y,n)\n",a_max,b_max);
           fprintf_header2(fp_out_mat_elec); };
    };
  };

  if (output_C && (extract_G || extract_V)) /* coordinates for matrixes */
  {

    strcpy(name,path_out); strcat(name,name_pa_a); strcat(name,ext_out);
    if ( !(fp_out_coo_pa_a=fopen(name,"wt")) )      /* a */
       { cannot_open(name_pa_a); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_coo_pa_a);
         fprintf(fp_out_coo_pa_a,"/* Column in this file: %s coordinate(s) %s\n",coord_type[real_coordinates],axis_a);
         fprintf_header2(fp_out_coo_pa_a); };

    strcpy(name,path_out); strcat(name,name_pa_b); strcat(name,ext_out);
    if ( !(fp_out_coo_pa_b=fopen(name,"wt")) )      /* b */
       { cannot_open(name_pa_b); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_coo_pa_b);
         fprintf(fp_out_coo_pa_b,"/* Column in this file: %s coordinate(s) %s\n",coord_type[real_coordinates],axis_b);
         fprintf_header2(fp_out_coo_pa_b); };

    strcpy(name,path_out); strcat(name,name_pa_c); strcat(name,ext_out);
    if ( !(fp_out_coo_pa_c=fopen(name,"wt")) )      /* c */
       { cannot_open(name_pa_c); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_coo_pa_c);
         fprintf(fp_out_coo_pa_c,"/* Column in this file: %s coordinate(s) %s\n",coord_type[real_coordinates],axis_c);
         fprintf_header2(fp_out_coo_pa_c); };
  };

  /************************************/
  /* allocate memory for input planes */

  if (!no_e_computing)                        /* do compute gradients */
  {
    if ( !(plane1=(double *)malloc(a_max*b_max*sizeof(double) )))
       { cannot_allocate("EXTRACTION"); free_all(); fclose_all(); return(-1); };

    if ( !(plane2=(double *)malloc(a_max*b_max*sizeof(double))))
       { cannot_allocate("UPPER"); free_all(); fclose_all(); return(-1); };

    if ( !(plane3=(double *)malloc(a_max*b_max*sizeof(double))))
       { cannot_allocate("LOWER"); free_all(); fclose_all(); return(-1); };

    c_help_1 = c_grad + 1; c_help_2 = c_grad - 1;
  };

  /*****************************/
  /* generating pa coordinates */

  if (output_C && (extract_V || extract_G))
  {
    if (real_coordinates)                             /* c */
       if (ouput_high_precision)
          fprintf(fp_out_coo_pa_c,"%22.15le\n",c_grad*gu);
       else
          fprintf(fp_out_coo_pa_c,"%lg\n",c_grad*gu);
    else
       fprintf(fp_out_coo_pa_c,"%ld\n",c_grad);

    for(b_grad=1;b_grad<=b_max;b_grad++)              /* b */
    {
      if (real_coordinates)
         if (ouput_high_precision)
            fprintf(fp_out_coo_pa_a,"%22.15le\n",b_grad*gu);
         else
            fprintf(fp_out_coo_pa_a,"%lg\n",b_grad*gu);
      else
         fprintf(fp_out_coo_pa_a,"%ld\n",b_grad);
    };

    for(a_grad=1;a_grad<=a_max;a_grad++)              /* a */
    {
      if (real_coordinates)
         if (ouput_high_precision)
            fprintf(fp_out_coo_pa_b,"%22.15le\n",a_grad*gu);
         else
            fprintf(fp_out_coo_pa_b,"%lg\n",a_grad*gu);
      else
         fprintf(fp_out_coo_pa_b,"%ld\n",a_grad);
    };

    if (!fp_out_coo_pa_a)   fclose(fp_out_coo_pa_a);
    if (!fp_out_coo_pa_b)   fclose(fp_out_coo_pa_b);
    if (!fp_out_coo_pa_c)   fclose(fp_out_coo_pa_c);
    printf("ExSimEck: Coordinates were written to COO_PA_[X|Y|Z].%s\n",strupr(ext_out));
    print_line();

  };

  /******************************************************************/
  /* scanning input file and writing electrodes and potential files */

  a=(char *) &z1;

  for (z=1;z<=header.nz;z++)
  {
    for (y=1;y<=header.ny;y++)
    {
      for (x=1;x<=header.nx;x++)
      {
        for (i=0;i<sizeof(double);i++)
          fscanf(fp_in_bin,"%c",&a[i]);

         if ((x==c_grad && axis==1) ||
            (y==c_grad && axis==2) ||
            (z==c_grad && axis==3))
          {

            if (z1>header.max_voltage)
              {
                z1-=2.0*header.max_voltage;
                z2=1;
                all_elec_equal_0 = 0;
              }
            else
              {
                z2=0;
              };
            if (z1 != 0) all_v_equal_0 = 0;

            if (quiet==0)
            {
              if (real_coordinates)
                 printf("ExSimEck: x=%lg, y=%lg, z=%lg, V=%lg, ELEC=%d\n",
                        x*gu,y*gu,z*gu,z1,z2);
              else
                  printf("ExSimEck: x=%ld, y=%ld, z=%ld, V=%lg, ELEC=%d\n",
                        x,y,z,z1,z2);
            };

            if (extract_V)
            {
              if (output_T)
              {
                 if (real_coordinates)
                    if (ouput_high_precision)
                       fprintf(fp_out_tab_pa,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,z1);
                    else
                       fprintf(fp_out_tab_pa,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,z1);
                 else
                    if (ouput_high_precision)
                       fprintf(fp_out_tab_pa,"%ld\t%ld\t%ld\t%22.15le\n",x,y,z,z1);
                    else
                       fprintf(fp_out_tab_pa,"%ld\t%ld\t%ld\t%lg\n",x,y,z,z1);
              };
              if (output_M)
              {
                 if (ouput_high_precision)
                    fprintf(fp_out_mat_pa,"%22.15le",z1);
                 else
                    fprintf(fp_out_mat_pa,"%lg",z1);
              };
            };
            if (extract_G)
            {
              if (output_T && z2==1)
              {
                 if (real_coordinates)
                    if (ouput_high_precision)
                       fprintf(fp_out_tab_elec,"%22.15le\t%22.15le\t%22.15le\t%d\n",x*gu,y*gu,z*gu,z2);
                    else
                       fprintf(fp_out_tab_elec,"%lg\t%lg\t%lg\t%d\n",x*gu,y*gu,z*gu,z2);
                 else
                    fprintf(fp_out_tab_elec,"%ld\t%ld\t%ld\t%d\n",x,y,z,z2);
              };
              if (output_M) fprintf(fp_out_mat_elec,"%d" ,z2);
            };

            if (output_M)
              {
                if (((matrix_element+1) % a_max) || (matrix_element==0))
                  {
                    if (extract_V) fprintf(fp_out_mat_pa,"\t");
                    if (extract_G) fprintf(fp_out_mat_elec,"\t");
                  }
                else
                  {
                    if (extract_V) fprintf(fp_out_mat_pa,"\n");
                    if (extract_G) fprintf(fp_out_mat_elec,"\n");
                  };
              };
            matrix_element++;

            if (!no_e_computing)              /* do compute gradients */
              {
                *(plane1 + matrix_element_a++)=z1;
              };
          };

          if (!no_e_computing && !no_ec_computing) /* do compute gradients */
            {

              if ((x==c_help_1 && axis==1) ||
                 (y==c_help_1 && axis==2) ||
                 (z==c_help_1 && axis==3))
                {
                  if (z1>header.max_voltage)
                    z1-=2.0*header.max_voltage;
                  *(plane2 + matrix_element_b++)=z1;
                };

              if ((x==c_help_2 && axis==1) ||
                 (y==c_help_2 && axis==2) ||
                 (z==c_help_2 && axis==3))
                {
                  if (z1>header.max_voltage)
                  z1-=2.0*header.max_voltage;
                  *(plane3 + matrix_element_c++)=z1;
                };
            };

      }
    }
    if (feof(fp_in_bin)!=0 && z<header.nz-1)
       { cannot_read("pa"); free_all(); fclose_all(); return(-1); };
  }

  if (quiet==0) print_line();

  if (!fp_in_bin)      fclose(fp_in_bin);

  if (extract_G)
  {
    if (!fp_out_tab_elec) fclose(fp_out_tab_elec);
    if (!fp_out_mat_elec) fclose(fp_out_mat_elec);
    printf("ExSimEck: Electrodes were written to %s_ELEC.%s\n",output_style[output_T],strupr(ext_out));
    print_line();
  };
  if (extract_V)
  {
    if (!fp_out_tab_pa)  fclose(fp_out_tab_pa);
    if (!fp_out_mat_pa)  fclose(fp_out_mat_pa);
    printf("ExSimEck: Potentials were written to %s_PA.%s\n",output_style[output_T],strupr(ext_out));
    print_line();
  };

  if (all_elec_equal_0)
  {
    printf("ExSimEck: WARNING: NO ELECTRODES WERE FOUND IN EXTRACTION PLANE\n");
    print_line();
    number_of_warnings++;
  };
  if (all_v_equal_0)
  {
    printf("ExSimEck: WARNING: ALL V=0 IN EXTRACTION PLANE\n");
    print_line();
    number_of_warnings++;
  };
  if(all_v_equal_0 && !no_e_computing)
  {
    printf("ExSimEck: ALL V=0 => won't compute |E|,Ex,Ey,Ez\n");
    print_line();
    no_e_computing=1;
  };

if (!no_e_computing)                          /* do compute gradients */
{
  /************************************/
  /* computing Ec to free some memory */

  if (!no_ec_computing)
  {
     for(matrix_element;matrix_element>=0;--matrix_element)
     {
        grad_c  =  *(plane3 + matrix_element)                 /* Ec */
                -  *(plane2 + matrix_element);
        grad_c /=  (2.0*gu);

        *(plane2 + matrix_element)=grad_c;
     };
  }
  else
  {
     for(matrix_element;matrix_element>=0;--matrix_element)
        *(plane2 + matrix_element)=0;
  };
  if (!plane3) free(plane3);

  /*****************************/
  /* generating ga coordinates */

  a_start=1;a_stop=a_max-1;
  b_start=1;b_stop=b_max-1;

  if (output_C)
  {

    strcpy(name,path_out); strcat(name,name_ga_a); strcat(name,ext_out);
    if ( !(fp_out_coo_ga_a=fopen(name,"wt")) )      /* a */
       { cannot_open(name_ga_a); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_coo_ga_a);
         fprintf(fp_out_coo_ga_a,"/* Column in this file: %s coordinate(s) %s\n",coord_type[real_coordinates],axis_a);
         fprintf_header2(fp_out_coo_ga_a); };

    strcpy(name,path_out); strcat(name,name_ga_b); strcat(name,ext_out);
    if ( !(fp_out_coo_ga_b=fopen(name,"wt")) )      /* b */
       { cannot_open(name_ga_b); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_coo_ga_b);
         fprintf(fp_out_coo_ga_b,"/* Column in this file: %s coordinate(s) %s\n",coord_type[real_coordinates],axis_b);
         fprintf_header2(fp_out_coo_ga_b); };

    strcpy(name,path_out); strcat(name,name_ga_c); strcat(name,ext_out);
    if ( !(fp_out_coo_ga_c=fopen(name,"wt")) )      /* c */
       { cannot_open(name_ga_c); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_coo_ga_c);
         fprintf(fp_out_coo_ga_c,"/* Column in this file: %s coordinate(s) %s\n",coord_type[real_coordinates],axis_c);
         fprintf_header2(fp_out_coo_ga_c); };

    if (real_coordinates)                                   /* c */
       if (ouput_high_precision)
          fprintf(fp_out_coo_ga_c,"%22.15le\n",c_grad*gu);
       else
          fprintf(fp_out_coo_ga_c,"%lg\n",c_grad*gu);
    else
       fprintf(fp_out_coo_ga_c,"%ld\n",c_grad);

    if (no_ec_computing) b_start--;
    for(b_grad=b_start;b_grad<b_stop;b_grad++)              /* b */
    {
      if (real_coordinates)
         if (ouput_high_precision)
            fprintf(fp_out_coo_ga_a,"%22.15le\n",(b_grad+1)*gu);
         else
            fprintf(fp_out_coo_ga_a,"%lg\n",(b_grad+1)*gu);
      else
         fprintf(fp_out_coo_ga_a,"%ld\n",(b_grad+1));
    };
    if (no_ec_computing) b_start++;

    for(a_grad=a_start;a_grad<a_stop;a_grad++)              /* a */
    {
      if (real_coordinates)
         if (ouput_high_precision)
            fprintf(fp_out_coo_ga_b,"%22.15le\n",(a_grad+1)*gu);
         else
            fprintf(fp_out_coo_ga_b,"%lg\n",(a_grad+1)*gu);
      else
         fprintf(fp_out_coo_ga_b,"%ld\n",(a_grad+1));
    };

    fclose_all();
    printf("ExSimEck: Coordinates were written to COO_GA_[X|Y|Z].%s\n",strupr(ext_out));
    print_line();

  };

  /* ****************/
  /* initial files */

  if (output_T)       /* gradients as table */
  {
   strcpy(name,path_out); strcat(name,name_tab_ga); strcat(name,ext_out);
   if ( !(fp_out_tab_grad=fopen(name,"wt")) )
       { cannot_open(name_tab_ga); free_all(); fclose_all(); return(-1); }
   else
       { fprintf_header1(fp_out_tab_grad);
         fprintf(fp_out_tab_grad,"/* Columns in this file: %s coordinates x, y, and z, |E|\n",coord_type[real_coordinates]);
         fprintf_header2(fp_out_tab_grad); };

   strcpy(name,path_out); strcat(name,name_tab_a); strcat(name,ext_out);
   if ( !(fp_out_tab_grad_a=fopen(name,"wt")) )      /* Ea */
       { cannot_open(name_tab_a); free_all(); fclose_all(); return(-1); }
   else
       { fprintf_header1(fp_out_tab_grad_a);
         fprintf(fp_out_tab_grad_a,"/* Columns in this file: %s coordinates x, y, and z, E%s\n",coord_type[real_coordinates],axis_a);
         fprintf_header2(fp_out_tab_grad_a); };

   strcpy(name,path_out); strcat(name,name_tab_b); strcat(name,ext_out);
   if ( !(fp_out_tab_grad_b=fopen(name,"wt")) )      /* Eb */
       { cannot_open(name_tab_b); free_all(); fclose_all(); return(-1); }
   else
       { fprintf_header1(fp_out_tab_grad_b);
         fprintf(fp_out_tab_grad_b,"/* Columns in this file: %s coordinates x, y, and z, E%s\n",coord_type[real_coordinates],axis_b);
         fprintf_header2(fp_out_tab_grad_b); };

   strcpy(name,path_out); strcat(name,name_tab_c); strcat(name,ext_out);
   if ( !(fp_out_tab_grad_c=fopen(name,"wt")) )      /* Ec */
       { cannot_open(name_tab_c); free_all(); fclose_all(); return(-1); }
   else
       { fprintf_header1(fp_out_tab_grad_c);
         fprintf(fp_out_tab_grad_c,"/* Columns in this file: %s coordinates x, y, and z, E%s\n",coord_type[real_coordinates],axis_c);
         fprintf_header2(fp_out_tab_grad_c); };
  };

  if (output_M)       /* gradients as matrix */
  {
    strcpy(name,path_out); strcat(name,name_mat_ga); strcat(name,ext_out);
    if ( !(fp_out_mat_grad=fopen(name,"wt")) )
       { cannot_open(name_mat_ga); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_mat_grad);
         if (no_ec_computing)
            fprintf(fp_out_mat_grad,"/* Dimensions of matrix in this file: %ld x %ld; elements: |E|\n",a_max-2,b_max-1);
         else
            fprintf(fp_out_mat_grad,"/* Dimensions of matrix in this file: %ld x %ld; elements: |E|\n",a_max-2,b_max-2);
         fprintf_header2(fp_out_mat_grad); };

    strcpy(name,path_out); strcat(name,name_mat_a); strcat(name,ext_out);
    if ( !(fp_out_mat_grad_a=fopen(name,"wt")) )      /* Ea */
       { cannot_open(name_mat_a); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_mat_grad_a);
         if (no_ec_computing)
            fprintf(fp_out_mat_grad_a,"/* Dimensions of matrix in this file: %ld x %ld; elements: E%s\n",a_max-2,b_max-1,axis_a);
         else
            fprintf(fp_out_mat_grad_a,"/* Dimensions of matrix in this file: %ld x %ld; elements: E%s\n",a_max-2,b_max-2,axis_a);
         fprintf_header2(fp_out_mat_grad_a); };

    strcpy(name,path_out); strcat(name,name_mat_b); strcat(name,ext_out);
    if ( !(fp_out_mat_grad_b=fopen(name,"wt")) )      /* Eb */
       { cannot_open(name_mat_b); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_mat_grad_b);
         if (no_ec_computing)
            fprintf(fp_out_mat_grad_b,"/* Dimensions of matrix in this file: %ld x %ld; elements: E%s\n",a_max-2,b_max-1,axis_b);
         else
            fprintf(fp_out_mat_grad_b,"/* Dimensions of matrix in this file: %ld x %ld; elements: E%s\n",a_max-2,b_max-2,axis_b);
         fprintf_header2(fp_out_mat_grad_b); };

    strcpy(name,path_out); strcat(name,name_mat_c); strcat(name,ext_out);
    if ( !(fp_out_mat_grad_c=fopen(name,"wt")) )      /* Ec */
       { cannot_open(name_mat_c); free_all(); fclose_all(); return(-1); }
    else
       { fprintf_header1(fp_out_mat_grad_c);
         if (no_ec_computing)
            fprintf(fp_out_mat_grad_c,"/* Dimensions of matrix in this file: %ld x %ld; elements: E%s\n",a_max-2,b_max-1,axis_c);
         else
            fprintf(fp_out_mat_grad_c,"/* Dimensions of matrix in this file: %ld x %ld; elements: E%s\n",a_max-2,b_max-2,axis_c);
         fprintf_header2(fp_out_mat_grad_c); };

  };

  /******************************************************/
  /* computing Ex,Ey,Ez,|E| for cylindrical case at x=0 */

  if (no_ec_computing)
  {
    b_grad=0;
    for(a_grad=a_start;a_grad<a_stop;a_grad++)
    {
           if (axis==1)  { y=a_grad+1; z=b_grad+1; x=c_grad; }
      else if (axis==2)  { x=a_grad+1; z=b_grad+1; y=c_grad; }
      else if (axis==3)  { x=a_grad+1; y=b_grad+1; z=c_grad; };

      if (quiet==0)
      {
         if (real_coordinates)
             printf("ExSimEck: computing Ex,Ey,Ez,|E| at x=%lg, y=%lg, z=%lg\n"
                     ,x*gu,y*gu,z*gu);
         else
             printf("ExSimEck: computing Ex,Ey,Ez,|E| at x=%ld, y=%ld, z=%ld\n"
                     ,x,y,z);
      };

      /* Ec */
      grad_c  =  0;

      /* Eb */
      grad_b  =  *(plane1 + b_grad*a_max + a_grad-1)
              -  *(plane1 + b_grad*a_max + a_grad+1);
      grad_b /=  (2.0*gu);

      /* Ea */
      grad_a  =  0;

      /* |E| */
      grad = grad_b;

      if (output_T)
      {
         if (real_coordinates)
         {
            if (ouput_high_precision)
            {
               fprintf(fp_out_tab_grad_c,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad_c);
               fprintf(fp_out_tab_grad_b,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad_b);
               fprintf(fp_out_tab_grad_a,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad_a);
               fprintf(fp_out_tab_grad  ,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad);
            }
            else
            {
               fprintf(fp_out_tab_grad_c,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad_c);
               fprintf(fp_out_tab_grad_b,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad_b);
               fprintf(fp_out_tab_grad_a,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad_a);
               fprintf(fp_out_tab_grad  ,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad);
            }
         }
         else
         {
            if (ouput_high_precision)
            {
               fprintf(fp_out_tab_grad_c,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad_c);
               fprintf(fp_out_tab_grad_b,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad_b);
               fprintf(fp_out_tab_grad_a,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad_a);
               fprintf(fp_out_tab_grad  ,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad);
            }
            else
            {
               fprintf(fp_out_tab_grad_c,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad_c);
               fprintf(fp_out_tab_grad_b,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad_b);
               fprintf(fp_out_tab_grad_a,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad_a);
               fprintf(fp_out_tab_grad  ,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad);
            };
         };
      };

      if (output_M)
      {
         if (ouput_high_precision)
         {
            fprintf(fp_out_mat_grad_c,"%22.15le", grad_c);
            fprintf(fp_out_mat_grad_b,"%22.15le", grad_b);
            fprintf(fp_out_mat_grad_a,"%22.15le", grad_a);
            fprintf(fp_out_mat_grad  ,"%22.15le", grad);
         }
         else
         {
            fprintf(fp_out_mat_grad_c,"%lg", grad_c);
            fprintf(fp_out_mat_grad_b,"%lg", grad_b);
            fprintf(fp_out_mat_grad_a,"%lg", grad_a);
            fprintf(fp_out_mat_grad  ,"%lg", grad);
         };

        if (a_grad<a_max-2)                                                                                                     {
          fprintf(fp_out_mat_grad_c,"\t");
          fprintf(fp_out_mat_grad_b,"\t");
          fprintf(fp_out_mat_grad_a,"\t");
          fprintf(fp_out_mat_grad,"\t");
        }
        else
        {
          fprintf(fp_out_mat_grad_c,"\n");
          fprintf(fp_out_mat_grad_b,"\n");
          fprintf(fp_out_mat_grad_a,"\n");
          fprintf(fp_out_mat_grad,"\n");
        };
      };
    };
  };

  /**************************/
  /* computing Ex,Ey,Ez,|E| */

  for(b_grad=b_start;b_grad<b_stop;b_grad++)
  {
    for(a_grad=a_start;a_grad<a_stop;a_grad++)
    {
           if (axis==1)  { y=a_grad+1; z=b_grad+1; x=c_grad; }
      else if (axis==2)  { x=a_grad+1; z=b_grad+1; y=c_grad; }
      else if (axis==3)  { x=a_grad+1; y=b_grad+1; z=c_grad; };

      if (quiet==0)
      {
         if (real_coordinates)
             printf("ExSimEck: computing Ex,Ey,Ez,|E| at x=%lg, y=%lg, z=%lg\n"
                     ,x*gu,y*gu,z*gu);
         else
             printf("ExSimEck: computing Ex,Ey,Ez,|E| at x=%ld, y=%ld, z=%ld\n"
                     ,x,y,z);
      };

      /* Ec */
      grad_c  =  *(plane2 + b_grad*a_max + a_grad);

      /* Eb */
      grad_b  =  *(plane1 + b_grad*a_max + a_grad-1)
              -  *(plane1 + b_grad*a_max + a_grad+1);
      grad_b /=  (2.0*gu);

      /* Ea */
      grad_a  =  *(plane1 + (b_grad-1)*a_max + a_grad)
              -  *(plane1 + (b_grad+1)*a_max + a_grad);
      grad_a /=  (2.0*gu);

      /* |E| */
      grad = sqrt(pow(grad_a,2)+pow(grad_b,2)+pow(grad_c,2));

      if (output_T)
      {
         if (real_coordinates)
         {
            if (ouput_high_precision)
            {
               fprintf(fp_out_tab_grad_c,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad_c);
               fprintf(fp_out_tab_grad_b,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad_b);
               fprintf(fp_out_tab_grad_a,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad_a);
               fprintf(fp_out_tab_grad  ,"%22.15le\t%22.15le\t%22.15le\t%22.15le\n",x*gu,y*gu,z*gu,grad);
            }
            else
            {
               fprintf(fp_out_tab_grad_c,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad_c);
               fprintf(fp_out_tab_grad_b,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad_b);
               fprintf(fp_out_tab_grad_a,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad_a);
               fprintf(fp_out_tab_grad  ,"%lg\t%lg\t%lg\t%lg\n",x*gu,y*gu,z*gu,grad);
            };
         }
         else
         {
            if (ouput_high_precision)
            {
               fprintf(fp_out_tab_grad_c,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad_c);
               fprintf(fp_out_tab_grad_b,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad_b);
               fprintf(fp_out_tab_grad_a,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad_a);
               fprintf(fp_out_tab_grad  ,"%ld\t%ld\t%ld\t%22.17le\n",x,y,z,grad);
            }
            else
            {
               fprintf(fp_out_tab_grad_c,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad_c);
               fprintf(fp_out_tab_grad_b,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad_b);
               fprintf(fp_out_tab_grad_a,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad_a);
               fprintf(fp_out_tab_grad  ,"%ld\t%ld\t%ld\t%lg\n",x,y,z,grad);
            };
         };
      };

      if (output_M)
      {
         if (ouput_high_precision)
         {
            fprintf(fp_out_mat_grad_c,"%22.15le", grad_c);
            fprintf(fp_out_mat_grad_b,"%22.15le", grad_b);
            fprintf(fp_out_mat_grad_a,"%22.15le", grad_a);
            fprintf(fp_out_mat_grad  ,"%22.15le", grad);
         }
         else
         {
            fprintf(fp_out_mat_grad_c,"%lg", grad_c);
            fprintf(fp_out_mat_grad_b,"%lg", grad_b);
            fprintf(fp_out_mat_grad_a,"%lg", grad_a);
            fprintf(fp_out_mat_grad  ,"%lg", grad);
         };

        if (a_grad<a_max-2)
        {
          fprintf(fp_out_mat_grad_c,"\t");
          fprintf(fp_out_mat_grad_b,"\t");
          fprintf(fp_out_mat_grad_a,"\t");
          fprintf(fp_out_mat_grad,"\t");
        }
        else
        {
          fprintf(fp_out_mat_grad_c,"\n");
          fprintf(fp_out_mat_grad_b,"\n");
          fprintf(fp_out_mat_grad_a,"\n");
          fprintf(fp_out_mat_grad,"\n");
        };
      };
    };
  };

  if (quiet==0) print_line();
  printf("ExSimEck: Gradients were written to %s_GA_[E|X|Y|Z].%s\n",output_style[output_T],strupr(ext_out));
  print_line();
  fclose_all();
  free_all();

};

     if (number_of_warnings==0)
        printf("ExSimEck: ALL DONE, NO WARNINGS. READY.\n");
else if (number_of_warnings==1)
        printf("ExSimEck: ATTENTION, THERE WAS 1 WARNING. READY.\n");
else
        printf("ExSimEck: ATTENTION, THERE WERE %d WARNINGS. READY.\n",number_of_warnings);

return(1);

};


/**************************************/
/* write top of header of output file */

void fprintf_header1(FILE *fp)
{
  fprintf(fp,"/********************************************************************\n");
  fprintf(fp,"/* PA file: %s\n", name_pa);
  fprintf(fp,"/* PA file header: maximum voltage=%lg, nx=%ld, ny=%ld, nz=%ld,\n",
         header.max_voltage,header.nx,header.ny,header.nz);
  fprintf(fp,"/*                 %s, %s, %s\n",
         sym[header.symmetry],mir[(header.mirror&(MIRROR_X|MIRROR_Y|MIRROR_Z))],
         pa_type[((header.mirror&MAGNETIC_PA)==MAGNETIC_PA)]);
  fprintf(fp,"/* Extraction plane: %s = %ld\n",axis_str,c_grad);
  fprintf(fp,"/* Distance between pixels: %lg mm\n",gu);
};

/*****************************************/
/* write bottom of header of output file */

void fprintf_header2(FILE *fp)
{
  fprintf(fp,"/********************************************************************\n");
};

/*************************/
/* print seperation line */

void print_line()
{
  printf("ExSimEck: --------------------------------------------------------------\n");
};
/**************************************/
/* message to stdout: can't open file */

void cannot_open(char *name)
{
  printf("ExSimEck: ERROR: CAN'T OPEN %s\n",strupr(name));
  print_line();
};

/**************************************/
/* message to stdout: can't read file */

void cannot_read(char *name)
{
  printf("ExSimEck: ERROR READING %s\n",strupr(name));
  print_line();
};

/*************************************************/
/* message to stdout: can't allocate memory file */

void cannot_allocate(char *name)
{
  printf("ExSimEck: ERROR: CAN'T ALLOCATE MEMORY FOR %s PLANE\n",strupr(name));
  print_line();
};

/************************/
/* close all open files */

void fclose_all()
{
  if (!fp_in_bin)           fclose(fp_in_bin);
  if (!fp_in_config)        fclose(fp_in_config);

  if (!fp_out_tab_pa)       fclose(fp_out_tab_pa);
  if (!fp_out_tab_elec)     fclose(fp_out_tab_elec);
  if (!fp_out_tab_grad)     fclose(fp_out_tab_grad);
  if (!fp_out_tab_grad_a)   fclose(fp_out_tab_grad_a);
  if (!fp_out_tab_grad_b)   fclose(fp_out_tab_grad_b);
  if (!fp_out_tab_grad_c)   fclose(fp_out_tab_grad_c);

  if (!fp_out_mat_pa)       fclose(fp_out_mat_pa);
  if (!fp_out_mat_elec)     fclose(fp_out_mat_elec);
  if (!fp_out_mat_grad)     fclose(fp_out_mat_grad);
  if (!fp_out_mat_grad_a)   fclose(fp_out_mat_grad_a);
  if (!fp_out_mat_grad_b)   fclose(fp_out_mat_grad_b);
  if (!fp_out_mat_grad_c)   fclose(fp_out_mat_grad_c);

  if (!fp_out_coo_pa_a)     fclose(fp_out_coo_pa_a);
  if (!fp_out_coo_pa_b)     fclose(fp_out_coo_pa_b);
  if (!fp_out_coo_pa_c)     fclose(fp_out_coo_pa_c);

  if (!fp_out_coo_ga_a)     fclose(fp_out_coo_ga_a);
  if (!fp_out_coo_ga_b)     fclose(fp_out_coo_ga_b);
  if (!fp_out_coo_ga_c)     fclose(fp_out_coo_ga_c);
};

/***************/
/* free memory */

void free_all()
{
  if (!plane1)              free(plane1);
  if (!plane2)              free(plane2);
  if (!plane3)              free(plane3);
};






























































































/****************************************************************
 *          __      __ ______ __    _____ _____ _    __         *
 *          \ \    / // __  // /   / ___// ___// \  / /         *
 *           \ \/\/ // /_/ // /__ / __/ / __/ / /\\/ /          *
 *            \_/\_//_____//____//_/   /____//_/  \_/           *
 *                                                              *
 ****************************************************************/
