/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;

public class TagCache {
    String shortTagName;
    Hashtable methodMaps;
    BeanInfo tagClassInfo;
    Class tagHandlerClass;

    TagCache(String shortTagName) {
        this.shortTagName = shortTagName;
        this.methodMaps = new Hashtable();
    }

    private void addSetterMethod(String attrName, Method m) {
        this.methodMaps.put(attrName, m);
    }

    Method getSetterMethod(String attrName) {
        return (Method)this.methodMaps.get(attrName);
    }

    BeanInfo getTagClassInfo() {
        return this.tagClassInfo;
    }

    Class getTagHandlerClass() {
        return this.tagHandlerClass;
    }

    void setTagHandlerClass(Class tagHandlerClass) throws JasperException {
        try {
            this.tagClassInfo = Introspector.getBeanInfo(tagHandlerClass);
            this.tagHandlerClass = tagHandlerClass;
            PropertyDescriptor[] pd = this.tagClassInfo.getPropertyDescriptors();
            int i = 0;
            while (i < pd.length) {
                if (pd[i].getWriteMethod() != null) {
                    this.addSetterMethod(pd[i].getName(), pd[i].getWriteMethod());
                }
                ++i;
            }
        }
        catch (IntrospectionException ex) {
            throw new JasperException(Constants.getString("jsp.error.unable.to_introspect", new Object[]{tagHandlerClass.getName(), ex.getMessage()}));
        }
    }
}

