/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Copydir
extends MatchingTask {
    private File srcDir;
    private File destDir;
    private boolean filtering = false;
    private Hashtable filecopyList = new Hashtable();

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, files);
        if (this.filecopyList.size() > 0) {
            this.project.log("Copying " + this.filecopyList.size() + " files to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.filecopyList.keys();
            while (enumeration.hasMoreElements()) {
                String fromFile = (String)enumeration.nextElement();
                String toFile = (String)this.filecopyList.get(fromFile);
                try {
                    this.project.copyFile(fromFile, toFile, this.filtering);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg);
                }
            }
        }
    }

    private void scanDir(File from, File to, String[] files) {
        int i = 0;
        while (i < files.length) {
            String filename = files[i];
            File srcFile = new File(from, filename);
            File destFile = new File(to, filename);
            if (srcFile.lastModified() > destFile.lastModified()) {
                this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
            }
            ++i;
        }
    }

    public void setDest(String dest) {
        this.destDir = this.project.resolveFile(dest);
    }

    public void setFiltering(String filter) {
        this.filtering = Project.toBoolean(filter);
    }

    public void setSrc(String src) {
        this.srcDir = this.project.resolveFile(src);
    }
}

