/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class FixCRLF
extends MatchingTask {
    private int addcr;
    private int addtab;
    private int ctrlz;
    private File srcDir;
    private File destDir = null;

    public FixCRLF() {
        if (System.getProperty("path.separator").equals(":")) {
            this.addcr = -1;
            this.ctrlz = -1;
        } else {
            this.addcr = 1;
            this.ctrlz = 0;
        }
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.project.log("options: cr=" + (this.addcr == -1 ? "add" : (this.addcr == 0 ? "asis" : "remove")) + " tab=" + (this.addtab == -1 ? "add" : (this.addtab == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == -1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")), "fixcrlf", 3);
        DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            int o;
            File srcFile = new File(this.srcDir, files[i]);
            int count = (int)srcFile.length();
            byte[] indata = new byte[count];
            try {
                FileInputStream inStream = new FileInputStream(srcFile);
                inStream.read(indata);
                inStream.close();
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
            int cr = 0;
            int lf = 0;
            int tab = 0;
            int k = 0;
            while (k < count) {
                byte c = indata[k];
                if (c == 13) {
                    ++cr;
                }
                if (c == 10) {
                    ++lf;
                }
                if (c == 9) {
                    ++tab;
                }
                ++k;
            }
            boolean eof = count > 0 && indata[count - 1] == 26;
            this.project.log(String.valueOf(String.valueOf(srcFile)) + ": size=" + count + " cr=" + cr + " lf=" + lf + " tab=" + tab + " eof=" + eof, "fixcrlf", 3);
            int outsize = count;
            if (this.addcr != 0) {
                outsize -= cr;
            }
            if (this.addcr == 1) {
                outsize += lf;
            }
            if (this.addtab == -1) {
                outsize += tab * 7;
            }
            if (this.ctrlz == 1) {
                ++outsize;
            }
            byte[] outdata = new byte[outsize];
            int line = o = 0;
            int col = 0;
            int k2 = 0;
            while (k2 < count) {
                switch (indata[k2]) {
                    case 32: {
                        if (this.addtab == 0) {
                            outdata[o++] = 32;
                        }
                        ++col;
                        break;
                    }
                    case 9: {
                        if (this.addtab == 0) {
                            outdata[o++] = 9;
                            ++col;
                            break;
                        }
                        col = (col | 7) + 1;
                        break;
                    }
                    case 13: {
                        if (this.addcr != 0) break;
                        outdata[o++] = 13;
                        ++col;
                        break;
                    }
                    case 10: {
                        if (this.addcr == 1) {
                            outdata[o++] = 13;
                        }
                        outdata[o++] = 10;
                        line = o;
                        col = 0;
                        break;
                    }
                    default: {
                        if (this.addtab > 0 && o + 1 < line + col) {
                            int diff = o - line;
                            while ((diff | 7) < col) {
                                outdata[o++] = 9;
                                diff = o - (line -= 7 - (diff & 7));
                            }
                        }
                        while (o < line + col) {
                            outdata[o++] = 32;
                        }
                        outdata[o++] = indata[k2];
                        ++col;
                    }
                }
                ++k2;
            }
            if (this.ctrlz == 1) {
                if (outdata[o - 1] != 26) {
                    outdata[o++] = 26;
                }
            } else if (this.ctrlz == -1) {
                if (o > 2 && outdata[o - 1] == 10 && outdata[o - 2] == 26) {
                    --o;
                }
                if (o > 1 && outdata[o - 1] == 26) {
                    --o;
                }
            }
            try {
                File destFile = srcFile;
                if (this.destDir != null) {
                    destFile = new File(this.destDir, files[i]);
                }
                FileOutputStream outStream = new FileOutputStream(destFile);
                outStream.write(outdata, 0, o);
                outStream.close();
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
            ++i;
        }
    }

    public void setCr(String option) {
        if (option.equals("remove")) {
            this.addcr = -1;
        } else if (option.equals("asis")) {
            this.addcr = 0;
        } else if (option.equals("add")) {
            this.addcr = 1;
        } else {
            throw new BuildException("Invalid option: " + option);
        }
    }

    public void setDestdir(String destDirName) {
        this.destDir = this.project.resolveFile(destDirName);
    }

    public void setEof(String option) {
        if (option.equals("remove")) {
            this.ctrlz = -1;
        } else if (option.equals("asis")) {
            this.ctrlz = 0;
        } else if (option.equals("add")) {
            this.ctrlz = 1;
        } else {
            throw new BuildException("Invalid option: " + option);
        }
    }

    public void setSrcdir(String srcDirName) {
        this.srcDir = this.project.resolveFile(srcDirName);
    }

    public void setTab(String option) {
        if (option.equals("remove")) {
            this.addtab = -1;
        } else if (option.equals("asis")) {
            this.addtab = 0;
        } else if (option.equals("add")) {
            this.addtab = 1;
        } else {
            throw new BuildException("Invalid option: " + option);
        }
    }
}

