/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.tomcat.service.JNIEndpointConnector;
import org.apache.tomcat.service.StartupThread;
import org.apache.tomcat.service.connector.JNIConnectionHandler;
import org.apache.tomcat.util.StringManager;

public class JNIEndpoint {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    JNIConnectionHandler handler;
    boolean running = false;

    public JNIConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public int service(long s, long l) {
        if (this.running) {
            try {
                JNIConnectionHandler handler = this.getConnectionHandler();
                handler.processConnection(s, l);
                return 1;
            }
            catch (Throwable throwable) {
            }
        }
        return 0;
    }

    public void setConnectionHandler(JNIConnectionHandler handler) {
        this.handler = handler;
    }

    public void shutdown() {
        System.out.println("JNI In shutdown");
    }

    public synchronized void startEndpoint() {
        System.out.println("Running ...");
        this.running = true;
        this.notify();
    }

    public int startup(String cmdLine, String stdout, String stderr) {
        try {
            if (stdout != null) {
                System.setOut(new PrintStream(new FileOutputStream(stdout)));
            }
        }
        catch (Throwable throwable) {}
        try {
            if (stderr != null) {
                System.setErr(new PrintStream(new FileOutputStream(stderr)));
            }
        }
        catch (Throwable throwable) {}
        try {
            JNIEndpointConnector.setEndpoinet(this);
            StartupThread startup = new StartupThread(cmdLine, this);
            startup.start();
            System.out.println("Starting up StartupThread");
            JNIEndpoint jNIEndpoint = this;
            synchronized (jNIEndpoint) {
                this.wait(60000L);
            }
            System.out.println("End waiting");
        }
        catch (Throwable throwable) {}
        if (this.running) {
            System.out.println("Running fine ");
            return 1;
        }
        System.out.println("Error - why doesn't run ??");
        return 0;
    }

    public synchronized void stopEndpoint() {
        this.running = false;
        this.notify();
    }
}

