/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.MessageString;
import org.apache.tomcat.util.StringManager;

public class MimeHeaderField {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    protected final MessageString name = new MessageString();
    protected final MessageString value = new MessageString();
    protected int intValue;
    protected final HttpDate dateValue = new HttpDate(0L);
    protected int type = 0;
    protected static final int T_NULL = 0;
    protected static final int T_STR = 1;
    protected static final int T_INT = 2;
    protected static final int T_DATE = 3;
    private static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public int getBytes(byte[] buf, int buf_offset) {
        int start_pt = buf_offset;
        buf_offset += this.name.getBytes(buf, buf_offset);
        buf[buf_offset++] = 58;
        buf[buf_offset++] = 32;
        switch (this.type) {
            case 1: {
                buf_offset += this.value.getBytes(buf, buf_offset);
                break;
            }
            case 2: {
                buf_offset += this.intGetBytes(this.intValue, buf, buf_offset);
                break;
            }
            case 3: {
                buf_offset += this.dateValue.getBytes(buf, buf_offset, HttpDate.DATELEN);
                break;
            }
        }
        buf[buf_offset++] = 13;
        buf[buf_offset++] = 10;
        return buf_offset - start_pt;
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 3: {
                return this.dateValue.getTime();
            }
            case 1: {
                return this.value.toDate(this.dateValue);
            }
        }
        String msg = this.sm.getString("mimeHeaderField.date.iae");
        throw new IllegalArgumentException(msg);
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 2: {
                return this.intValue;
            }
            case 1: {
                return this.value.toInteger();
            }
        }
        String msg = this.sm.getString("mimeHeaderField.int.nfe");
        throw new NumberFormatException(msg);
    }

    public String getName() {
        return this.name.toString();
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                return this.dateValue.toString();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int intGetBytes(int target, byte[] buf, int offset) {
        power = 1000000000;
        bytes_emitted = 0;
        if (target != 0) ** GOTO lbl11
        buf[offset] = MimeHeaderField.charval[0];
        return 1;
lbl-1000:
        // 1 sources

        {
            this_digit = target / power;
            if (this_digit != 0 || bytes_emitted > 0) {
                buf[offset + bytes_emitted++] = MimeHeaderField.charval[this_digit];
            }
            target %= power;
            power /= 10;
lbl11:
            // 2 sources

            ** while (power > 0)
        }
lbl12:
        // 1 sources

        return bytes_emitted;
    }

    public boolean nameEquals(String s) {
        return this.name.equalsIgnoreCase(s);
    }

    public boolean nameEquals(byte[] b, int off, int len) {
        return this.name.equalsIgnoreCase(b, off, len);
    }

    public boolean parse(byte[] b, int off, int len) {
        byte c;
        int start = off;
        while ((c = b[off++]) != 58 && c != 32) {
            if (c != 10) continue;
            System.out.println("Parse error, empty line: " + new String(b, off, len));
            return false;
        }
        this.setName(b, start, off - start - 1);
        while (c == 32) {
            c = b[off++];
        }
        if (c != 58) {
            System.out.println("Parse error, missing : in  " + new String(b, off, len));
            return false;
        }
        while ((c = b[off++]) == 32) {
        }
        this.setValue(b, off - 1, len - (off - start - 1));
        return true;
    }

    public void reset() {
        this.name.reset();
        this.value.reset();
        this.type = 0;
    }

    public void setDateValue() {
        this.dateValue.setTime();
        this.type = 3;
    }

    public void setDateValue(long t) {
        this.dateValue.setTime(t);
        this.type = 3;
    }

    public void setIntValue(int i) {
        this.intValue = i;
        this.type = 2;
    }

    public void setName(String s) {
        this.name.setString(s);
    }

    public void setName(byte[] b, int off, int len) {
        this.name.setBytes(b, off, len);
    }

    public void setValue(String s) {
        this.value.setString(s);
        this.type = 1;
    }

    public void setValue(byte[] b, int off, int len) {
        this.value.setBytes(b, off, len);
        this.type = 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name.toString());
        sb.append(": ");
        switch (this.type) {
            case 1: {
                sb.append(this.value.toString());
                break;
            }
            case 2: {
                sb.append(this.intValue);
                break;
            }
            case 3: {
                sb.append(this.dateValue.toString());
                break;
            }
        }
        return sb.toString();
    }

    public void write(ServletOutputStream out) throws IOException {
        this.name.write(out);
        out.print(": ");
        switch (this.type) {
            case 1: {
                this.value.write(out);
                out.println();
                break;
            }
            case 2: {
                out.println(this.intValue);
                break;
            }
            case 3: {
                this.dateValue.write((OutputStream)out);
                out.println();
                break;
            }
            default: {
                out.println();
            }
        }
    }
}

