/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.util.Vector;

public class ThreadPool {
    public static final int MAX_THREADS = 50;
    public static final int MAX_SPARE_THREADS = 25;
    public static final int MIN_SPARE_THREADS = 10;
    public static final int WORK_WAIT_TIMEOUT = 60000;
    protected Vector pool;
    protected MonitorRunnable monitor;
    protected int maxThreads = 50;
    protected int minSpareThreads = 10;
    protected int maxSpareThreads = 25;
    protected int currentThreadCount = 0;
    protected int currentThreadsBusy = 0;
    protected boolean stopThePool = false;

    protected void adjustLimits() {
        if (this.maxThreads <= 0) {
            this.maxThreads = 50;
        }
        if (this.maxSpareThreads >= this.maxThreads) {
            this.maxSpareThreads = this.maxThreads;
        }
        if (this.maxSpareThreads <= 0) {
            this.maxSpareThreads = this.maxThreads == 1 ? 1 : this.maxThreads / 2;
        }
        if (this.minSpareThreads > this.maxSpareThreads) {
            this.minSpareThreads = this.maxSpareThreads;
        }
        if (this.minSpareThreads <= 0) {
            this.minSpareThreads = this.maxSpareThreads == 1 ? 1 : this.maxSpareThreads / 2;
        }
        System.out.println(String.valueOf(this.maxThreads) + " " + this.maxSpareThreads + " " + this.minSpareThreads);
    }

    protected synchronized void checkSpareControllers() {
        if (this.stopThePool) {
            return;
        }
        if (this.currentThreadCount - this.currentThreadsBusy > this.maxSpareThreads) {
            int toFree = this.currentThreadCount - this.currentThreadsBusy - this.maxSpareThreads;
            int i = 0;
            while (i < toFree) {
                ControlRunnable c = (ControlRunnable)this.pool.firstElement();
                this.pool.removeElement(c);
                c.terminate();
                --this.currentThreadCount;
                ++i;
            }
        }
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    protected void openThreads(int toOpen) {
        if (toOpen > this.maxThreads) {
            toOpen = this.maxThreads;
        }
        if (this.currentThreadCount == 0) {
            this.pool = new Vector(toOpen);
        }
        int i = this.currentThreadCount;
        while (i < toOpen) {
            this.pool.addElement(new ControlRunnable(this));
            ++i;
        }
        this.currentThreadCount = toOpen;
    }

    protected synchronized void returnController(ControlRunnable c) {
        if (this.currentThreadCount == 0 || this.stopThePool) {
            c.terminate();
            return;
        }
        --this.currentThreadsBusy;
        this.pool.addElement(c);
        this.notify();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runIt(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        if (this.currentThreadCount == 0 || this.stopThePool) {
            throw new IllegalStateException();
        }
        ControlRunnable c = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.currentThreadsBusy == this.currentThreadCount) {
                if (this.currentThreadCount < this.maxThreads) {
                    int toOpen = this.currentThreadCount + this.minSpareThreads;
                    this.openThreads(toOpen);
                } else {
                    while (this.currentThreadsBusy == this.currentThreadCount) {
                        try {
                            this.wait();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        if (this.currentThreadCount != 0 && !this.stopThePool) continue;
                        throw new IllegalStateException();
                    }
                }
            }
            c = (ControlRunnable)this.pool.lastElement();
            this.pool.removeElement(c);
            ++this.currentThreadsBusy;
        }
        c.runIt(r);
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public synchronized void shutdown() {
        System.out.println("start shutdown()");
        if (!this.stopThePool) {
            this.stopThePool = true;
            this.monitor.terminate();
            this.monitor = null;
            int i = 0;
            while (i < this.currentThreadCount - this.currentThreadsBusy) {
                try {
                    ((ControlRunnable)this.pool.elementAt(i)).terminate();
                }
                catch (Throwable throwable) {}
                ++i;
            }
            this.currentThreadCount = 0;
            this.currentThreadsBusy = 0;
            this.pool = null;
            this.notifyAll();
        }
        System.out.println("end shutdown()");
    }

    public synchronized void start() {
        this.adjustLimits();
        this.openThreads(this.minSpareThreads);
        this.monitor = new MonitorRunnable(this);
    }

    class MonitorRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        boolean shouldTerminate = false;

        MonitorRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.start();
        }

        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        MonitorRunnable monitorRunnable = this;
                        synchronized (monitorRunnable) {
                            this.wait(60000L);
                        }
                        if (this.shouldTerminate) break block5;
                        this.p.checkSpareControllers();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }

    class ControlRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        Runnable toRun = null;
        boolean shouldTerminate = false;
        boolean shouldRun = false;

        ControlRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.start();
        }

        public void run() {
            while (true) {
                try {
                    do {
                        Object var2_4;
                        block11: {
                            ControlRunnable controlRunnable = this;
                            synchronized (controlRunnable) {
                                if (!this.shouldRun && !this.shouldTerminate) {
                                    this.wait();
                                }
                            }
                            try {
                                if (!this.shouldRun) break block11;
                                this.toRun.run();
                            }
                            catch (Throwable throwable) {
                                var2_4 = null;
                                if (this.shouldRun) {
                                    this.shouldRun = false;
                                    this.p.returnController(this);
                                }
                                throw throwable;
                            }
                        }
                        var2_4 = null;
                        if (!this.shouldRun) continue;
                        this.shouldRun = false;
                        this.p.returnController(this);
                    } while (!this.shouldTerminate);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public synchronized void runIt(Runnable toRun) {
            this.toRun = toRun;
            this.shouldRun = true;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }
}

