<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
     <TITLE>PO Query Results</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[


function doView(PO) {

  var features = "scrollbars=yes,resizable=yes";
  var newlink =  "/servlet/MSIServlet?disValue=807&PONumber=" + PO; 
  var newLayer = open(newlink,"PO",features);
}

function doEdit(PO) {

  var features = "scrollbars=yes,resizable=yes";
  var newlink =  "/servlet/MSIServlet?disValue=811&PONUMBER=" + PO; 
  var newLayer = open(newlink,"PO",features);
}

]]>
</xsl:comment>
</SCRIPT>


<!-- Include this in every page for allowing the colors and attributes to be set -->
<BODY>


<CENTER><H1>PO Query Results</H1></CENTER><P></P>
<P></P>

<FORM NAME="SINGLE">
<!-- <xsl:attribute name="ACTION">javascript:loadPO(&quot;<xsl:value-of select="MSI/LAYOUT/SERVLET"/>&quot;,document.SINGLE.PONumber.value);</xsl:attribute>	-->

<TABLE>
<TR>
	<TH/>
	<TH/>
	<TH>PO #</TH>
	<TH>Date Ordered</TH>
	<TH>Customer</TH>
	<TH>Supplier</TH>
	<TH>Rep ID</TH>
	<TH>Order Total</TH>
</TR>


<xsl:for-each select="MSI/POInfoTable">
<xsl:sort select="i4" data-type="text" order="descending"/>
<xsl:sort select="i0" data-type="text" order="descending"/>


<TR>
	<xsl:choose>
	<xsl:when test="position() mod 2 = 1">
	 <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
	</xsl:when>
	<xsl:otherwise>
	 <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
	</xsl:otherwise>
	</xsl:choose>			



<TD> 
	<BUTTON SIZE="10">
	<xsl:attribute name="onClick">doEdit('<xsl:value-of select="i0"/>');</xsl:attribute>    
	Edit
	</BUTTON>
</TD>

<TD> 
	<BUTTON SIZE="10">
	<xsl:attribute name="onClick">doView('<xsl:value-of select="i0"/>');</xsl:attribute>    
	View
	</BUTTON>
</TD>


<TD>
<xsl:choose>
<xsl:when test="i13[.!='']">
<xsl:value-of select="i13"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="i0"/>
</xsl:otherwise>
</xsl:choose>			
</TD>

<TD>
<xsl:value-of select="i4"/>
</TD>

<TD>
<xsl:value-of select="i23"/>
</TD>

<TD>
<xsl:value-of select="i10"/>
</TD>

<TD>
<xsl:value-of select="i3"/>
</TD>

<TD ALIGN="RIGHT">
$<xsl:value-of select="format-number(i11,'###,##0.00')"/>
</TD>

</TR>
</xsl:for-each>

</TABLE>



</FORM>
<P></P>


</BODY></HTML>
</xsl:template>
</xsl:stylesheet>
