//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl\registry.hpp>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
#define NameLen 40
#define DateLen 12
#define PhoneLen 21
#define AddressLen 40
#define DayLen 2
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TMainForm *MainForm;
TStringList *StrList = new TStringList;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
   // Loading colors from registry
   TColor dummyColor = RGB(254,50,233),
          defColor = RGB(0,0,255),
          testColor;

   TRegIniFile *RegFile = new TRegIniFile("SOFTWARE\\Birthday Scanner");
   testColor = RegFile->ReadInteger("Colors","Form",dummyColor);
   if (testColor != dummyColor)
   {
      MainForm->Color = RegFile->ReadInteger("Colors","Form",defColor);
      SetEdit(RegFile->ReadInteger("Colors","Edit",defColor));
      SetEditText(RegFile->ReadInteger("Colors","EditText",defColor));
      SetLabels(RegFile->ReadInteger("Colors","Labels",defColor));
      MainForm->Label1->Font->Color = RegFile->ReadInteger("Colors","Label1",defColor);
      MainForm->Label2->Font->Color = RegFile->ReadInteger("Colors","Label2",defColor);
   }
   RegFile->Free();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
   try
   {
      StrList->LoadFromFile("Birthday.txt");
   }
   catch (EFOpenError &E)
   {
      exit(EXIT_SUCCESS);
   }

   TDateTime Date1, TenDays(10);
   AnsiString DateStr, DayStr;
   unsigned short year, month, day, current_year, num_days;

   Date1 = Date();
   Date1.DecodeDate(&current_year,&month,&day);

// removing all lines from StrList, except those to display
   int i=0;
   while(i < StrList->Count)
   {
      // decoding Date field
      DateStr = TrimRight((StrList->Strings[i]).SubString(NameLen+1,DateLen));
      try
      {
         Date1 = StrToDate(DateStr);
      }
      catch (EConvertError &E)
      {
         Date1 = Date()+TenDays;
      }

      // decoding Day field
      DayStr = TrimRight((StrList->Strings[i]).SubString(NameLen+DateLen+PhoneLen+AddressLen+1,DayLen));
      try
      {
         num_days = DayStr.ToInt();
      }
      catch (EConvertError &E)
      {
         num_days = 1;
      }

      TDateTime NumDays(num_days);

      // calculating anniversary date in current year
      Date1.DecodeDate(&year,&month,&day);
      TDateTime Date2(current_year,month,day), Date3(current_year+1,month,day);

      if (  ( (Date2 >= Date()) && ((Date2-Date()) < NumDays) ) ||    // the date in this year
            ( (Date3 >= Date()) && ((Date3-Date()) < NumDays) )    )  // the date in next year (e.g. for January 1)
      {
         i++;
      }
      else
      {
         StrList->Delete(i);
      }
   }

   if (StrList->Count == 0)
   {
      exit(EXIT_SUCCESS);
   }

   if (StrList->Count == 1)
   {
       PrevButton->Visible = FALSE;
       NextButton->Visible = FALSE;
       Counter->Visible = FALSE;
   }
}
//---------------------------------------------------------------------------
void TMainForm::AnniversaryDisplay(void)
{
// updates StatusLabel with corresponding info
   TDateTime Date1, TenDays(10);
   AnsiString DateStr, DayStr;
   unsigned short year, month, day, current_year, num_days;

   Date1 = Date();
   Date1.DecodeDate(&current_year,&month,&day);

   // decoding Date Field
   DateStr = TrimRight((StrList->Strings[Counter->Tag]).SubString(NameLen+1,DateLen));
   try
   {
      Date1 = StrToDate(DateStr);
   }
   catch (EConvertError &E)
   {
      Date1 = Date()+TenDays;
   }

   Date1.DecodeDate(&year,&month,&day);

   // decoding Day field
   DayStr = TrimRight((StrList->Strings[Counter->Tag]).SubString(NameLen+DateLen+PhoneLen+AddressLen+1,DayLen));
   try
   {
      num_days = DayStr.ToInt();
   }
   catch (EConvertError &E)
   {
      num_days = 1;
   }

   TDateTime NumDays(num_days);


   TDateTime Date2(current_year,month,day),  // the same date in this year
             Date3(current_year+1,month,day),  // the same date in next year
             Date4;  // the most relevant date

   if ( (Date2 >= Date()) && ((Date2-Date()) < NumDays) )   Date4 = Date2;
   else   Date4 = Date3;

   int AnnYear = current_year - year;  // anniversary's year
   if (AnnYear<1)  // strange - he haven't born yet
   {
      Label2->Caption = "Somebody's birthday is soon!";
   }
   else
   {
      AnsiString AnnYearStr(AnnYear),
                 AnnNumDays[11] = {"today", "tomorrow", "in 2 days", "in 3 days", "in 4 days", "in 5 days", "in 6 days", "in 7 days", "in 8 days", "in 9 days", "in 10 days"},
                 AnnYearEnd[10] = {"th","st","nd","rd","th","th","th","th","th","th"};

      // how many days left
      // (not the nicest way to do it - but I have some problems with VCL ;)
      TDateTime  OneDay(1), TwoDays(2), ThreeDays(3), FourDays(4), FiveDays(5), SixDays(6), SevenDays(7), EightDays(8), NineDays(9);

      NumDays = Date4 - Date();  // the actual number of days left

      int LeftDays = 10;
      if (NumDays<TenDays) LeftDays = 9;
      if (NumDays<NineDays) LeftDays = 8;
      if (NumDays<EightDays) LeftDays = 7;
      if (NumDays<SevenDays) LeftDays = 6;
      if (NumDays<SixDays) LeftDays = 5;
      if (NumDays<FiveDays) LeftDays = 4;
      if (NumDays<FourDays) LeftDays = 3;
      if (NumDays<ThreeDays) LeftDays = 2;
      if (NumDays<TwoDays) LeftDays = 1;
      if (NumDays<OneDay) LeftDays = 0;

      // last year's digit
      int LastDigit = AnnYear/10;
      LastDigit = AnnYear-LastDigit*10;

      Label2->Caption = "Somebody's " + AnnYearStr + AnnYearEnd[LastDigit] + " anniversary is " + AnnNumDays[LeftDays] + "!";
   }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormPaint(TObject *Sender)
{
   AnsiString PosStr((int)Counter->Tag + 1),
              NumStr((int)StrList->Count),
              Str;
   Counter->Text = PosStr + " of " + NumStr;
   Str = StrList->Strings[Counter->Tag];
   NameEdit->Text  = TrimRight(Str.SubString(1,NameLen));
   DateEdit->Text  = TrimRight(Str.SubString(NameLen+1,DateLen));
   PhoneEdit->Text = TrimRight(Str.SubString(NameLen+DateLen+1,PhoneLen));
   AddressEdit->Text = TrimRight(Str.SubString(NameLen+DateLen+PhoneLen+1,AddressLen));
   AnniversaryDisplay();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::NextButtonClick(TObject *Sender)
{
   if (Counter->Tag < (StrList->Count-1))  (Counter->Tag)++;
   MainForm->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PrevButtonClick(TObject *Sender)
{
   if (Counter->Tag > 0)  (Counter->Tag)--;
   MainForm->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ExitButtonClick(TObject *Sender)
{
   MainForm->Close();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormShow(TObject *Sender)
{
   if (StrList->Count == 1)
      ExitButton->SetFocus();
   else
      NextButton->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AboutButtonClick(TObject *Sender)
{
   AboutBox->ShowModal();
}
//---------------------------------------------------------------------------
void TMainForm::SetEdit(TColor Color)
{
   for (int i=0; i<(ComponentCount); i++)
      if (dynamic_cast<TEdit *>(Components[i]))
         dynamic_cast<TEdit *>(Components[i])->Color = Color;
      else if (dynamic_cast<TComboBox *>(Components[i]))
         dynamic_cast<TComboBox *>(Components[i])->Color = Color;
}
//---------------------------------------------------------------------------
void TMainForm::SetEditText(TColor Color)
{
   for (int i=0; i<(ComponentCount); i++)
      if (dynamic_cast<TEdit *>(Components[i]))
         dynamic_cast<TEdit *>(Components[i])->Font->Color = Color;
      else if (dynamic_cast<TComboBox *>(Components[i]))
         dynamic_cast<TComboBox *>(Components[i])->Font->Color = Color;
}
//---------------------------------------------------------------------------
void TMainForm::SetLabels(TColor Color)
{
   for (int i=0; i<(ComponentCount); i++)
      if (dynamic_cast<TLabel *>(Components[i]))
         dynamic_cast<TLabel *>(Components[i])->Font->Color = Color;
}
//---------------------------------------------------------------------------
