/* Copyright (c) 2000 The Mdate Development Team
 * under the terms of the GPL.
 */

/*
 * PLEASE check for XXX sections, they may need your attention!
 */

/* XXX: ok im adding super-careful defines around these things */
#ifndef _MDATE_H
#define _MDATE_H 1

#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS		/* empty */
# define __END_DECLS		/* empty */
#endif

#undef __P
#if defined (__STDC__) || defined (_AIX) \
	|| (defined (__mips) && defined (_SYSTYPE_SVR4)) \
	|| defined(WIN32) || defined(__cplusplus)
#define __P(protos) protos
#else
# define __P(protos) ()
#endif

/* XXX - this was done to avoid clashes with Unix headers; it may not be useful under Win32 */
#undef TRUE
#undef FALSE
typedef enum
{ FALSE = 0, TRUE = 1 }
BOOL;

#define FALSE FALSE
#define TRUE TRUE

/* XXX - OS specific defines following - please alter for your OS:
 * IF you're compiling under Win32, make sure WIN32 is defined, if NOT, you MUST undefine it!
 */

#ifndef _GNU_SOURCE
# define _GNU_SOURCE 1
#endif

/* XXX - modified for poor stupid doze, comment out for other OS's */
#ifndef WIN32
# define WIN32
#endif

#ifdef HAVE_CONFIG_H
# include "config.h"
#else
# include <stdio.h>
# include <stdlib.h>
# include <sys/types.h>
# include <math.h>
# include <string.h>
# include <time.h>
#endif

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
#endif

#include <sys/types.h>

#ifdef HAVE_MATH_H
# include <math.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#endif

#include <time.h>

/* Design Principles:
 * MIT style, not Berkeley style.
 * Everything that could fail returns a bool for success/failure.
 * julian_date is the common date format - everything converts to and from it.
 * Use strings as little as possible.
 * The range needs to be clearly specified - what is the legal date range?
 */

/* XXX: the legal date range is anything JDN can handle:
 * from 584285.0 to something like 999999999.0!
 * 
 * that's from 13 08 -3113 BC to 26 11 2733194 AD
 * -- ewe2
 */

/* USER/DEVELOPER SERVICEABLE PART
 * 
 * change this if you want a different correlation:
 * we assume you know what you're doing.
 */
#define JD_CORRELATION 584285.0L

typedef struct long_count
{
  int bak, kat, tun, uin, kin;
} long_count;

typedef struct greg_date
{
  int day, month, year;
} greg_date;

typedef double julian_date;

typedef struct haab_date
{
  int month, day;
} haab_date;

typedef struct tzolkin_date
 {
  int month, day;
} tzolkin_date;

/* *INDENT-OFF* */
__BEGIN_DECLS 
BOOL jdate_from_double_jd __P((double from, julian_date * to));
BOOL jdate_from_tm __P((struct tm from, julian_date * to));
BOOL jdate_from_time_t __P((time_t from, julian_date * to));
BOOL jdate_from_long_count __P((long_count from, julian_date * to));
BOOL jdate_from_greg_date __P((greg_date from, julian_date * to));

BOOL is_valid_greg_date __P((greg_date date));
BOOL is_valid_jdate __P((double jul));
BOOL is_valid_long_count __P((long_count date));
BOOL is_valid_struct_tm __P((struct tm date));

/* Maybe not - but it would come in handy sometimes */

BOOL tm_from_jdate __P((julian_date from, struct tm * to));
BOOL time_t_from_jdate __P((julian_date from, time_t * to));
BOOL long_count_from_jdate __P((julian_date from, long_count * to));
BOOL greg_date_from_jdate __P((julian_date from, greg_date * to));
BOOL haab_date_from_jdate __P((julian_date from, haab_date * to));
BOOL tzolkin_date_from_jdate __P((julian_date from, tzolkin_date * to));

/* In the following functions, to must point to an array
 * of at least 256 character. */

void greg_date_to_str __P((greg_date from, char *to));
BOOL haab_date_to_str __P((haab_date from, char *to));
BOOL tzolkin_date_to_str __P((tzolkin_date from, char *to));
void long_count_to_str __P((long_count from, char *to));
void jdate_to_str __P((julian_date from, char *to));

BOOL haab_month_to_str __P((int from, char *to));
BOOL tzolkin_month_to_str __P((int from, char *to));

/* added back for doze because strftime() is buggy with -ve dates */
const char *gmonth_str __P((int month));

__END_DECLS
/* *INDENT-ON* */
#endif /* !_MDATE_H */
