/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Card;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Category;

public class HandCalculator {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$HandCalculator == null ? (class$com$rexbot$game$card$HandCalculator = HandCalculator.class$("com.rexbot.game.card.HandCalculator")) : class$com$rexbot$game$card$HandCalculator);
    private static final int BASE = 16;
    private static final int HANDSIZE = 5;
    private static final long NO_PAIR = 0L * (long)Math.pow(16.0, 10.0);
    private static final long ONE_PAIR = 1L * (long)Math.pow(16.0, 10.0);
    private static final long TWO_PAIR = 2L * (long)Math.pow(16.0, 10.0);
    private static final long THREE_OF_A_KIND = 3L * (long)Math.pow(16.0, 10.0);
    private static final long STRAIGHT = 4L * (long)Math.pow(16.0, 10.0);
    private static final long FLUSH = 5L * (long)Math.pow(16.0, 10.0);
    private static final long FULL_HOUSE = 6L * (long)Math.pow(16.0, 10.0);
    private static final long FOUR_OF_A_KIND = 7L * (long)Math.pow(16.0, 10.0);
    private static final long STRAIGHT_FLUSH = 8L * (long)Math.pow(16.0, 10.0);
    static /* synthetic */ Class class$com$rexbot$game$card$HandCalculator;

    private HandCalculator() {
    }

    public static void main(String[] args) {
        ArrayList<Card> cards = new ArrayList<Card>();
        cards.add(new Card(0, 11));
        cards.add(new Card(2, 12));
        cards.add(new Card(0, 12));
        cards.add(new Card(0, 4));
        cards.add(new Card(1, 3));
        cards.add(new Card(0, 9));
        cards.add(new Card(0, 10));
        System.out.println("Value = " + HandCalculator.getPokerValue(cards));
        cards = new ArrayList();
        cards.add(new Card(0, 2));
        cards.add(new Card(2, 5));
        cards.add(new Card(0, 12));
        cards.add(new Card(0, 4));
        cards.add(new Card(1, 3));
        cards.add(new Card(0, 9));
        cards.add(new Card(0, 10));
        System.out.println("Value = " + HandCalculator.getPokerValue(cards));
    }

    public static int pokerValueToBrainValue(long value) {
        if (value >= STRAIGHT_FLUSH) {
            return 9;
        }
        if (value >= FOUR_OF_A_KIND) {
            return 8;
        }
        if (value >= FULL_HOUSE) {
            return 7;
        }
        if (value >= FLUSH) {
            return 6;
        }
        if (value >= STRAIGHT) {
            return 5;
        }
        if (value >= THREE_OF_A_KIND) {
            return 4;
        }
        if (value >= TWO_PAIR) {
            return 3;
        }
        if (value >= ONE_PAIR) {
            return 2;
        }
        return 1;
    }

    public static String pokerValueToString(long value) {
        if (value >= STRAIGHT_FLUSH) {
            return "Straight Flush";
        }
        if (value >= FOUR_OF_A_KIND) {
            return "Four of a Kind";
        }
        if (value >= FULL_HOUSE) {
            return "Full House";
        }
        if (value >= FLUSH) {
            return "Flush";
        }
        if (value >= STRAIGHT) {
            return "Straight";
        }
        if (value >= THREE_OF_A_KIND) {
            return "Three of a Kind";
        }
        if (value >= TWO_PAIR) {
            return "Two Pair";
        }
        if (value >= ONE_PAIR) {
            return "One Pair";
        }
        return "High Card";
    }

    public static String getPokerValueAsString(List cards) {
        long value = HandCalculator.getPokerValue(cards);
        return HandCalculator.pokerValueToString(value);
    }

    public static long getPokerValue(List cards) {
        if (cards.size() == 0) {
            return 0L;
        }
        Collections.sort(cards, Card.getComparator());
        long value = HandCalculator.getStraightFlushValue(cards);
        if (value >= STRAIGHT_FLUSH) {
            return value;
        }
        value = HandCalculator.getFourOfAKindValue(cards);
        if (value >= STRAIGHT_FLUSH) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= FOUR_OF_A_KIND) {
            return value;
        }
        value = HandCalculator.getFullHouseValue(cards);
        if (value >= FOUR_OF_A_KIND) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= FULL_HOUSE) {
            return value;
        }
        value = HandCalculator.getFlushValue(cards);
        if (value >= FULL_HOUSE) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= FLUSH) {
            return value;
        }
        value = HandCalculator.getStraightValue(cards);
        if (value >= FLUSH) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= STRAIGHT) {
            return value;
        }
        value = HandCalculator.getThreeOfAKindValue(cards);
        if (value >= STRAIGHT) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= THREE_OF_A_KIND) {
            return value;
        }
        value = HandCalculator.getTwoPairValue(cards);
        if (value >= THREE_OF_A_KIND) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= TWO_PAIR) {
            return value;
        }
        value = HandCalculator.getOnePairValue(cards);
        if (value >= TWO_PAIR) {
            throw new RuntimeException("Too HIGH");
        }
        if (value >= ONE_PAIR) {
            return value;
        }
        return HandCalculator.getNoPairValue(cards);
    }

    private static long getNoPairValue(List cards) {
        long result = 0L;
        for (int i = 0; i < cards.size(); ++i) {
            Card card = (Card)cards.get(i);
            result = (long)((double)result + (double)card.getPokerValue() * Math.pow(16.0, i));
        }
        return result += NO_PAIR;
    }

    private static long getOnePairValue(List cards) {
        long result = 0L;
        for (int i = 1; i < cards.size(); ++i) {
            Card card = (Card)cards.get(i);
            Card prevCard = (Card)cards.get(i - 1);
            if (card.getPokerValue() == prevCard.getPokerValue()) {
                result += ONE_PAIR;
            }
            result = (long)((double)result + (double)card.getPokerValue() * Math.pow(16.0, i));
        }
        return result;
    }

    private static long getTwoPairValue(List cards) {
        long result = 0L;
        int pairs = 0;
        int highCard = 0;
        for (int i = 1; i < cards.size(); ++i) {
            Card card = (Card)cards.get(i);
            Card prevCard = (Card)cards.get(i - 1);
            if (card.getPokerValue() != prevCard.getPokerValue()) continue;
            if (++pairs == 1) {
                result = (long)((double)result + (double)card.getPokerValue() * Math.pow(16.0, 2.0));
            }
            if (pairs == 2) {
                result = (long)((double)result + (double)card.getPokerValue() * Math.pow(16.0, 3.0));
                continue;
            }
            if (card.getPokerValue() > highCard) {
                highCard = card.getPokerValue();
            }
            if (prevCard.getPokerValue() <= highCard) continue;
            highCard = prevCard.getPokerValue();
        }
        if (pairs >= 2) {
            result += TWO_PAIR;
            result += (long)highCard;
        }
        return result;
    }

    private static long getThreeOfAKindValue(List cards) {
        long result = 0L;
        for (int i = 2; i < cards.size(); ++i) {
            Card card = (Card)cards.get(i);
            Card prevCard = (Card)cards.get(i - 1);
            Card prevPrevCard = (Card)cards.get(i - 2);
            if (card.getPokerValue() != prevCard.getPokerValue() || card.getPokerValue() != prevPrevCard.getPokerValue()) continue;
            result = card.getPokerValue();
        }
        if (result == 0L) {
            return result;
        }
        return result += THREE_OF_A_KIND;
    }

    private static long getFourOfAKindValue(List cards) {
        long result = 0L;
        for (int i = 3; i < cards.size(); ++i) {
            Card cardOne = (Card)cards.get(i);
            Card cardTwo = (Card)cards.get(i - 1);
            Card cardThree = (Card)cards.get(i - 2);
            Card cardFour = (Card)cards.get(i - 3);
            if (cardOne.getPokerValue() != cardTwo.getPokerValue() || cardTwo.getPokerValue() != cardThree.getPokerValue() || cardThree.getPokerValue() != cardFour.getPokerValue()) continue;
            result += FOUR_OF_A_KIND;
            return result += (long)cardFour.getPokerValue();
        }
        return 0L;
    }

    private static long getFullHouseValue(List cards) {
        long result = 0L;
        for (int i = 2; i < cards.size(); ++i) {
            Card card = (Card)cards.get(i);
            Card prevCard = (Card)cards.get(i - 1);
            Card prevPrevCard = (Card)cards.get(i - 2);
            if (card.getPokerValue() != prevCard.getPokerValue() || card.getPokerValue() != prevPrevCard.getPokerValue()) continue;
            result = card.getPokerValue();
        }
        if (result == 0L) {
            return result;
        }
        int resultTwo = 0;
        for (int i = 1; i < cards.size(); ++i) {
            Card card = (Card)cards.get(i);
            Card prevCard = (Card)cards.get(i - 1);
            if (card.getPokerValue() != prevCard.getPokerValue() || (long)card.getPokerValue() == result) continue;
            resultTwo = card.getPokerValue();
        }
        if (resultTwo == 0) {
            return resultTwo;
        }
        return result += FULL_HOUSE;
    }

    private static long getStraightValue(List cards) {
        long result = 0L;
        Card ace = (Card)cards.get(cards.size() - 1);
        for (int i = 4; i < cards.size(); ++i) {
            Card cardOne = (Card)cards.get(i - 4);
            Card cardTwo = (Card)cards.get(i - 3);
            Card cardThree = (Card)cards.get(i - 2);
            Card cardFour = (Card)cards.get(i - 1);
            Card cardFive = (Card)cards.get(i);
            if (cardOne.getPokerValue() + 1 != cardTwo.getPokerValue() || cardTwo.getPokerValue() + 1 != cardThree.getPokerValue() || cardThree.getPokerValue() + 1 != cardFour.getPokerValue()) continue;
            if (cardOne.getPokerValue() == 2 && ace.getPokerValue() == 1) {
                result = cardFour.getPokerValue();
            }
            if (cardFour.getPokerValue() + 1 != cardFive.getPokerValue()) continue;
            result = cardFive.getPokerValue();
        }
        if (result == 0L) {
            return result;
        }
        return result += STRAIGHT;
    }

    private static long getFlushValue(List cards) {
        long result = 0L;
        int spadeCount = 5;
        int heartCount = 5;
        int clubCount = 5;
        int diamondCount = 5;
        long spadeResult = 0L;
        long heartResult = 0L;
        long clubResult = 0L;
        long diamondResult = 0L;
        for (int i = cards.size() - 1; i >= 0; --i) {
            Card card = (Card)cards.get(i);
            switch (card.getSuit()) {
                case 2: {
                    spadeResult = (long)((double)spadeResult + (double)card.getPokerValue() * Math.pow(16.0, --spadeCount));
                    break;
                }
                case 0: {
                    heartResult = (long)((double)heartResult + (double)card.getPokerValue() * Math.pow(16.0, --heartCount));
                    break;
                }
                case 1: {
                    clubResult = (long)((double)clubResult + (double)card.getPokerValue() * Math.pow(16.0, --clubCount));
                    break;
                }
                case 3: {
                    diamondResult = (long)((double)diamondResult + (double)card.getPokerValue() * Math.pow(16.0, --diamondCount));
                }
            }
            if (spadeCount <= 0) {
                result += FLUSH;
                return result += spadeResult;
            }
            if (heartCount <= 0) {
                result += FLUSH;
                return result += heartResult;
            }
            if (clubCount <= 0) {
                result += FLUSH;
                return result += clubResult;
            }
            if (diamondCount > 0) continue;
            result += FLUSH;
            return result += diamondResult;
        }
        return 0L;
    }

    private static long getStraightFlushValue(List cards) {
        long result = 0L;
        Card ace = (Card)cards.get(cards.size() - 1);
        for (int i = 4; i < cards.size(); ++i) {
            Card cardOne = (Card)cards.get(i - 4);
            Card cardTwo = (Card)cards.get(i - 3);
            Card cardThree = (Card)cards.get(i - 2);
            Card cardFour = (Card)cards.get(i - 1);
            Card cardFive = (Card)cards.get(i);
            if (cardOne.getPokerValue() + 1 != cardTwo.getPokerValue() || cardTwo.getPokerValue() + 1 != cardThree.getPokerValue() || cardThree.getPokerValue() + 1 != cardFour.getPokerValue()) continue;
            if (cardOne.getPokerValue() == 2 && ace.getPokerValue() == 1 && cardOne.getSuit() == cardTwo.getSuit() && cardTwo.getSuit() == cardThree.getSuit() && cardThree.getSuit() == cardFour.getSuit() && cardFour.getSuit() == ace.getSuit()) {
                result = cardFour.getPokerValue();
            }
            if (cardFour.getPokerValue() + 1 != cardFive.getPokerValue() || cardOne.getSuit() != cardTwo.getSuit() || cardTwo.getSuit() != cardThree.getSuit() || cardThree.getSuit() != cardFour.getSuit() || cardFour.getSuit() != cardFive.getSuit()) continue;
            result = cardFive.getPokerValue();
        }
        if (result == 0L) {
            return result;
        }
        return result += STRAIGHT_FLUSH;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

