/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JScrollPane jScrollPane1;
    private JPanel buttonPanel;
    private JButton okButton;
    private JEditorPane helpEditorPane;
    private int returnStatus = 0;
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    static /* synthetic */ Class class$com$rexbot$game$card$HelpDialog;

    public HelpDialog(Frame parent, boolean modal, URL url) throws IOException {
        super(parent, modal);
        this.initComponents();
        if (url != null) {
            this.helpEditorPane.setEditable(false);
            this.helpEditorPane.setPage(url);
            this.helpEditorPane.addHyperlinkListener(this);
        }
        this.setSize(640, 480);
        this.center();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void center() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        Dimension size = this.getSize();
        this.setLocation((screenWidth - size.width) / 2, (screenHeight - size.height) / 2);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.helpEditorPane = new JEditorPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HelpDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HelpDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jScrollPane1.setViewportView(this.helpEditorPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        new HelpDialog((Frame)new JFrame(), true, (class$com$rexbot$game$card$HelpDialog == null ? (class$com$rexbot$game$card$HelpDialog = HelpDialog.class$("com.rexbot.game.card.HelpDialog")) : class$com$rexbot$game$card$HelpDialog).getResource("/Nag.html")).show();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            System.out.println("Got:" + hyperlinkEvent.getURL().toString());
            HelpDialog.displayURL(hyperlinkEvent.getURL().toString());
        }
    }

    public static void displayURL(String url) {
        boolean windows = HelpDialog.isWindowsPlatform();
        String cmd = null;
        try {
            if (windows) {
                cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                Process p = Runtime.getRuntime().exec(cmd);
            } else {
                cmd = "netscape " + url;
                Process p = Runtime.getRuntime().exec(cmd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

