/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.BackgroundPanel;
import com.rexbot.game.card.Card;
import com.rexbot.game.card.NoticeDialog;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.PlayerManager;
import com.rexbot.game.card.Table;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.apache.log4j.Category;

public class OptionsDialog
extends JDialog {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$OptionsDialog == null ? (class$com$rexbot$game$card$OptionsDialog = OptionsDialog.class$("com.rexbot.game.card.OptionsDialog")) : class$com$rexbot$game$card$OptionsDialog);
    private JCheckBox allFaceUpCheckBox;
    private JLabel allFaceUpLabel;
    private JCheckBox alwaysShowWinnerCheckBox;
    private JLabel alwaysShowWinnerLabel;
    private JComboBox backgroundComboBox;
    private JLabel backgroundLabel;
    private JButton cancelButton;
    private JLabel cardSet;
    private JComboBox cardSetComboBox;
    private JPanel closeOptionsPanel;
    private JTextField computerDelayTextField;
    private JLabel cumputerDelayLabel;
    private JComboBox currentBrainSetNameComboBox;
    private JLabel currentBrainSetNameLabel;
    private JComboBox freezeButtonComboBox;
    private JLabel freezeButtonLabel;
    private JPanel gameOptionsPanel;
    private JPanel guiOptionsPanel;
    private JComboBox humanPlayerComboBox;
    private JLabel humanPlayerLabel;
    private JButton importBackgroundButton;
    private JCheckBox learnFromHumanCheckBox;
    private JLabel learnFromHumanLabel;
    private JLabel maxRaisePerRoundLabel;
    private JTextField maxRaiseTextField;
    private JComboBox minMaxBetComboBox;
    private JLabel minMaxBetLabel;
    private JLabel mutationRateLabel;
    private JTextField mutationRateTextField;
    private JComboBox numPlayersComboBox;
    private JLabel numPlayersLabel;
    private JButton okButton;
    private JTabbedPane optionsTabbedPane;
    private JCheckBox preserveHistoryCheckBox;
    private JLabel preserveHistoryLabel;
    private JLabel rakeLabel;
    private JTextField rakeTextField;
    private JLabel roundsPerMatingLabel;
    private JTextField roundsPerMatingTextField;
    private JLabel roundsPerShuffleLabel;
    private JTextField roundsPerShuffleTextField;
    private JButton scrambleCurrentBrainSetButton;
    private JPanel simOptionsPanel;
    static /* synthetic */ Class class$com$rexbot$game$card$OptionsDialog;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cardSetComboBox.setRenderer(new ButtonComboBoxRenderer());
        this.optionsTabbedPane.setTitleAt(0, "Game Options");
        this.optionsTabbedPane.setTitleAt(1, "AI Options");
        this.optionsTabbedPane.setTitleAt(2, "GUI Options");
        this.center();
        this.setup();
        this.validate();
        this.pack();
        this.center();
    }

    private static void addItemsToCombo(Object[] items, JComboBox jcombo) {
        for (int i = 0; i < items.length; ++i) {
            jcombo.addItem(items[i]);
        }
    }

    public void center() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        Dimension size = this.getSize();
        this.setLocation((screenWidth - size.width) / 2, (screenHeight - size.height) / 2);
    }

    private void setup() {
        this.minMaxBetComboBox.addItem("$2-$4");
        this.minMaxBetComboBox.addItem("$4-$8");
        this.minMaxBetComboBox.addItem("$10-$20");
        this.minMaxBetComboBox.addItem("$20-$40");
        this.minMaxBetComboBox.addItem("$50-$100");
        this.minMaxBetComboBox.addItem("$100-$200");
        this.minMaxBetComboBox.addItem("$200-$400");
        this.minMaxBetComboBox.setSelectedItem(Opts.getGame(Opts.getInstance().getBetMultiplier()));
        Object[] oneThroughTen = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        Object[] zeroThroughTen = new String[]{"Don't Freeze", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        OptionsDialog.addItemsToCombo(oneThroughTen, this.numPlayersComboBox);
        this.numPlayersComboBox.setSelectedIndex(Opts.getInstance().getNumOfPlayers() - 1);
        this.learnFromHumanCheckBox.setSelected(Opts.getInstance().isLearnFromHuman());
        OptionsDialog.addItemsToCombo(oneThroughTen, this.humanPlayerComboBox);
        this.humanPlayerComboBox.setSelectedIndex(Opts.getInstance().getHumanPlayer() - 1);
        this.maxRaiseTextField.setText(Integer.toString(Opts.getInstance().getMaxRaisesPerRound()));
        this.computerDelayTextField.setText(Integer.toString(Opts.getInstance().getCumputerPlayerDelay()));
        this.mutationRateTextField.setText(Integer.toString(Opts.getInstance().getMutationRate()));
        this.roundsPerMatingTextField.setText(Integer.toString(Opts.getInstance().getRoundsPerMating()));
        this.roundsPerShuffleTextField.setText(Integer.toString(Opts.getInstance().getRoundsPerShuffle()));
        OptionsDialog.addItemsToCombo(Opts.getInstance().getAllBrainSetNames().toArray(), this.currentBrainSetNameComboBox);
        this.currentBrainSetNameComboBox.setSelectedItem(Opts.getInstance().getBrainSetName());
        this.allFaceUpCheckBox.setSelected(Opts.getInstance().isAllCardsFaceUp());
        this.rakeTextField.setText(Integer.toString(Opts.getInstance().getRakePercentage()));
        OptionsDialog.addItemsToCombo(zeroThroughTen, this.freezeButtonComboBox);
        this.freezeButtonComboBox.setSelectedIndex(Opts.getInstance().getFreezeButtonAt());
        OptionsDialog.addItemsToCombo(Opts.getInstance().getBackgroundList().toArray(), this.backgroundComboBox);
        this.backgroundComboBox.setSelectedItem(Opts.getInstance().getBackground());
        for (int i = 0; i < 15; ++i) {
            URL url = this.getClass().getResource("/cardBack_" + (i + 1) + ".png");
            ImageIcon ii = new ImageIcon(new ImageIcon(url).getImage().getScaledInstance(Card.CARD_WIDTH, Card.CARD_HEIGHT, 4));
            this.cardSetComboBox.addItem(new JButton("" + (i + 1), ii));
        }
        try {
            this.cardSetComboBox.setSelectedIndex(Integer.parseInt(Opts.getInstance().getCardSet()) - 1);
        }
        catch (Exception e) {
            cat.error(e, e);
        }
        this.preserveHistoryCheckBox.setSelected(Opts.getInstance().isPreserveHistory());
    }

    private void save() {
        Opts opts = Opts.getInstance();
        opts.setBetMultiplier(Opts.betMult(this.minMaxBetComboBox.getSelectedItem().toString()));
        opts.setNumOfPlayers(this.numPlayersComboBox.getSelectedIndex() + 1);
        opts.setLearnFromHuman(this.learnFromHumanCheckBox.isSelected());
        opts.setHumanPlayer(this.humanPlayerComboBox.getSelectedIndex() + 1);
        try {
            opts.setMaxRaisesPerRound(Integer.parseInt(this.maxRaiseTextField.getText()));
        }
        catch (NumberFormatException nfe) {
            new NoticeDialog("Raises per round must be a number", 5000L).show();
        }
        try {
            opts.setCumputerPlayerDelay(Integer.parseInt(this.computerDelayTextField.getText()));
        }
        catch (NumberFormatException nfe) {
            new NoticeDialog("Computer Delay must be a number", 5000L).show();
        }
        opts.setMutationRate(Integer.parseInt(this.mutationRateTextField.getText()));
        opts.setRoundsPerMating(Integer.parseInt(this.roundsPerMatingTextField.getText()));
        opts.setRoundsPerShuffle(Integer.parseInt(this.roundsPerShuffleTextField.getText()));
        opts.setBrainSetName(this.currentBrainSetNameComboBox.getSelectedItem().toString());
        opts.setAllCardsFaceUp(this.allFaceUpCheckBox.isSelected());
        opts.setRakePercentage(Integer.parseInt(this.rakeTextField.getText()));
        opts.setFreezeButtonAt(this.freezeButtonComboBox.getSelectedIndex());
        if (!opts.getBackground().equals(this.backgroundComboBox.getSelectedItem().toString())) {
            opts.setBackground(this.backgroundComboBox.getSelectedItem().toString());
            BackgroundPanel.reset();
        }
        opts.setCardSet(((JButton)this.cardSetComboBox.getSelectedItem()).getText());
        Card.resetGraphic();
        opts.setPreserveHistory(this.preserveHistoryCheckBox.isSelected());
        opts.save();
    }

    private void initComponents() {
        this.optionsTabbedPane = new JTabbedPane();
        this.gameOptionsPanel = new JPanel();
        this.numPlayersLabel = new JLabel();
        this.minMaxBetLabel = new JLabel();
        this.humanPlayerLabel = new JLabel();
        this.maxRaisePerRoundLabel = new JLabel();
        this.numPlayersComboBox = new JComboBox();
        this.minMaxBetComboBox = new JComboBox();
        this.humanPlayerComboBox = new JComboBox();
        this.maxRaiseTextField = new JTextField();
        this.cumputerDelayLabel = new JLabel();
        this.computerDelayTextField = new JTextField();
        this.alwaysShowWinnerLabel = new JLabel();
        this.alwaysShowWinnerCheckBox = new JCheckBox();
        this.rakeLabel = new JLabel();
        this.rakeTextField = new JTextField();
        this.allFaceUpLabel = new JLabel();
        this.allFaceUpCheckBox = new JCheckBox();
        this.freezeButtonLabel = new JLabel();
        this.freezeButtonComboBox = new JComboBox();
        this.preserveHistoryLabel = new JLabel();
        this.preserveHistoryCheckBox = new JCheckBox();
        this.simOptionsPanel = new JPanel();
        this.mutationRateLabel = new JLabel();
        this.roundsPerShuffleLabel = new JLabel();
        this.roundsPerMatingLabel = new JLabel();
        this.currentBrainSetNameLabel = new JLabel();
        this.mutationRateTextField = new JTextField();
        this.roundsPerShuffleTextField = new JTextField();
        this.roundsPerMatingTextField = new JTextField();
        this.currentBrainSetNameComboBox = new JComboBox();
        this.scrambleCurrentBrainSetButton = new JButton();
        this.learnFromHumanLabel = new JLabel();
        this.learnFromHumanCheckBox = new JCheckBox();
        this.guiOptionsPanel = new JPanel();
        this.backgroundLabel = new JLabel();
        this.backgroundComboBox = new JComboBox();
        this.importBackgroundButton = new JButton();
        this.cardSet = new JLabel();
        this.cardSetComboBox = new JComboBox();
        this.closeOptionsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.closeDialog(evt);
            }
        });
        this.gameOptionsPanel.setLayout(new GridBagLayout());
        this.numPlayersLabel.setText("Number of players: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.numPlayersLabel, gridBagConstraints);
        this.minMaxBetLabel.setText("Minumum/Maximum bet size: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.minMaxBetLabel, gridBagConstraints);
        this.humanPlayerLabel.setText("Human player at seat: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.humanPlayerLabel, gridBagConstraints);
        this.maxRaisePerRoundLabel.setText("Maximum raises per betting round: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.maxRaisePerRoundLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.numPlayersComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.minMaxBetComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.humanPlayerComboBox, gridBagConstraints);
        this.maxRaiseTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.maxRaiseTextField, gridBagConstraints);
        this.cumputerDelayLabel.setText("Cumputer Player Delay: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.cumputerDelayLabel, gridBagConstraints);
        this.computerDelayTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.computerDelayTextField, gridBagConstraints);
        this.alwaysShowWinnerLabel.setText("Always show winning cards? ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.alwaysShowWinnerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.alwaysShowWinnerCheckBox, gridBagConstraints);
        this.rakeLabel.setText("Rake percentage: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.rakeLabel, gridBagConstraints);
        this.rakeTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.rakeTextField, gridBagConstraints);
        this.allFaceUpLabel.setText("Deal all cards face up? ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.allFaceUpLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.allFaceUpCheckBox, gridBagConstraints);
        this.freezeButtonLabel.setText("Freeze the button at: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.freezeButtonLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.freezeButtonComboBox, gridBagConstraints);
        this.preserveHistoryLabel.setText("Preserve History?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        this.gameOptionsPanel.add((Component)this.preserveHistoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.gameOptionsPanel.add((Component)this.preserveHistoryCheckBox, gridBagConstraints);
        this.optionsTabbedPane.addTab("tab1", this.gameOptionsPanel);
        this.simOptionsPanel.setLayout(new GridBagLayout());
        this.mutationRateLabel.setText("1 point mutation per: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        this.simOptionsPanel.add((Component)this.mutationRateLabel, gridBagConstraints);
        this.roundsPerShuffleLabel.setText("Rounds per shuffle: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        this.simOptionsPanel.add((Component)this.roundsPerShuffleLabel, gridBagConstraints);
        this.roundsPerMatingLabel.setText("Rounds per mating: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.simOptionsPanel.add((Component)this.roundsPerMatingLabel, gridBagConstraints);
        this.currentBrainSetNameLabel.setText("Current brain set: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        this.simOptionsPanel.add((Component)this.currentBrainSetNameLabel, gridBagConstraints);
        this.mutationRateTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.simOptionsPanel.add((Component)this.mutationRateTextField, gridBagConstraints);
        this.roundsPerShuffleTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.simOptionsPanel.add((Component)this.roundsPerShuffleTextField, gridBagConstraints);
        this.roundsPerMatingTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.simOptionsPanel.add((Component)this.roundsPerMatingTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        this.simOptionsPanel.add((Component)this.currentBrainSetNameComboBox, gridBagConstraints);
        this.scrambleCurrentBrainSetButton.setText("Initialize");
        this.scrambleCurrentBrainSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.scrambleCurrentBrainSetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.simOptionsPanel.add((Component)this.scrambleCurrentBrainSetButton, gridBagConstraints);
        this.learnFromHumanLabel.setText("Learn from human player? ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.simOptionsPanel.add((Component)this.learnFromHumanLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.simOptionsPanel.add((Component)this.learnFromHumanCheckBox, gridBagConstraints);
        this.optionsTabbedPane.addTab("tab2", this.simOptionsPanel);
        this.guiOptionsPanel.setLayout(new GridBagLayout());
        this.backgroundLabel.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.guiOptionsPanel.add((Component)this.backgroundLabel, gridBagConstraints);
        this.backgroundComboBox.setAutoscrolls(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.guiOptionsPanel.add((Component)this.backgroundComboBox, gridBagConstraints);
        this.importBackgroundButton.setText("Import Background");
        this.importBackgroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.importBackgroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.guiOptionsPanel.add((Component)this.importBackgroundButton, gridBagConstraints);
        this.cardSet.setText("Card Set");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.guiOptionsPanel.add((Component)this.cardSet, gridBagConstraints);
        this.cardSetComboBox.setMaximumRowCount(3);
        this.cardSetComboBox.setAutoscrolls(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.guiOptionsPanel.add((Component)this.cardSetComboBox, gridBagConstraints);
        this.optionsTabbedPane.addTab("tab3", this.guiOptionsPanel);
        this.getContentPane().add((Component)this.optionsTabbedPane, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeOptionsPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.closeOptionsPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.closeOptionsPanel, "South");
        this.pack();
    }

    private void importBackgroundButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            Opts.getInstance().addBackground(file.getAbsolutePath());
            Table.background = null;
            this.backgroundComboBox.removeAllItems();
            OptionsDialog.addItemsToCombo(Opts.getInstance().getBackgroundList().toArray(), this.backgroundComboBox);
            this.backgroundComboBox.setSelectedItem(file.getAbsolutePath());
            this.validate();
            this.pack();
            this.center();
        }
    }

    private void scrambleCurrentBrainSetButtonActionPerformed(ActionEvent evt) {
        try {
            if (JOptionPane.showConfirmDialog(this, "This brainset: " + this.currentBrainSetNameComboBox.getSelectedItem() + " will be destroyed! Are you sure?") == 0) {
                Opts.getInstance().setBrainSetName(this.currentBrainSetNameComboBox.getSelectedItem().toString());
                PlayerManager.getInstance().scrambleBrains();
            }
        }
        catch (IOException ioe) {
            new NoticeDialog("Error initializing brains: " + ioe, 5000L).show();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.save();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OptionsDialog((Frame)new JFrame(), true).show();
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ButtonComboBoxRenderer
    extends BasicComboBoxRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            cat.debug("value=" + value);
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            if (value instanceof JTextArea) {
                return (Component)value;
            }
            if (value instanceof JCheckBox) {
                return (Component)value;
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            }
            if (value instanceof JButton) {
                return (Component)value;
            }
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

