//---------------------------------------------------------------------------
//This is the main unit of example how to use BigSpeed Zip DLL in Delphi
//Compiled with Delphi 4.0
//(c) BigSpeedSoft, 1999
//Be sure TSZD.DLL is available in directory!!!
//---------------------------------------------------------------------------

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, ComCtrls,ShellApi,
  StdCtrls, checklst, FileCtrl, Grids;


const
  GColMax = 7;
  GridHdr : array [0..GColMax] of shortstring =
   ('  ','Name','Date','Time','Size','Ratio','Packed','Path');
  GColWdt : array [0..GColMax] of integer =
    (20,100,70,80,90,45,90,200);
  GRightCol : array [0..GColMax] of boolean =
    (false,false,false,false,true,true,true,false);

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    DrawGrid1: TDrawGrid;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    sbOpen: TSpeedButton;
    sbAdd: TSpeedButton;
    sbRng: TSpeedButton;
    sbExtract: TSpeedButton;
    sbHelp: TSpeedButton;
    OpenZipDlg: TOpenDialog;
    sbClose: TSpeedButton;
    sbAddFiles: TSpeedButton;
    sbNew: TSpeedButton;
    dlgAddFiles: TOpenDialog;
    dlgSaveZip: TSaveDialog;
    function Compress : boolean;
    procedure ExecFile;
    procedure InvDrwGrd;
    procedure sbOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LoadGrid;
    procedure EmptyGrid;
    procedure FormDestroy(Sender: TObject);
    procedure DrawGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure DrawGrid1DblClick(Sender: TObject);
    procedure DrawGrid1SelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure DrawGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DrawGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure sbExtractClick(Sender: TObject);
    procedure sbHelpClick(Sender: TObject);
    procedure sbCloseClick(Sender: TObject);
    procedure sbAddFilesClick(Sender: TObject);
    procedure sbNewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;



//API of BigSpeed Zip DLL

function zOpenZipFile(zipfilename:PChar): integer; stdcall;
function zCloseZipFile: integer; stdcall;
function zGetTotalFiles : integer; stdcall;
function zGetTotalBytes : integer; stdcall;
function zGetSelectedFiles : integer; stdcall;
function zGetSelectedBytes : integer; stdcall;
function zGetLastErrorAsText : pchar; stdcall;
function zGetSkipedFiles: integer; stdcall;
function zGetRunTimeInfo(var ProcessedFiles,ProcessedBytes : integer) : boolean; stdcall;
function zCancelOperation : boolean; stdcall;

function zExtractOne(ItemNo: integer;ExtractDirectory,Password: pchar;
  OverwriteExisting,UseFolders,TestOnly : boolean;RTInfoFunc: pointer) : integer; stdcall;
function zExtractSelected(ExtractDirectory,Password: pchar;
  OverwriteExisting,UseFolders,TestOnly : boolean;RTInfoFunc: pointer) : integer; stdcall;
function zExtractAll(ExtractDirectory,Password: pchar;
  OverwriteExisting,UseFolders,TestOnly : boolean;RTInfoFunc: pointer) : integer; stdcall;

function zGetFileName(i : integer) : pchar; stdcall;
function zGetFileExt(i : integer) : pchar; stdcall;
function zGetFilePath(i : integer) : pchar; stdcall;
function zGetFileDate(i : integer) : integer; stdcall;
function zGetFileTime(i : integer) : integer; stdcall;
function zGetFileSize(i : integer) : integer; stdcall;
function zGetCompressedFileSize(i : integer) : integer; stdcall;
function zFileIsEncrypted(i : integer) : boolean; stdcall;
function zGetLastOperResult(i : integer) : pchar; stdcall;

function zFileIsSelected(i : integer) : boolean; stdcall;
function zSelectFile(i: integer;how : boolean): boolean; stdcall;


function zCreateNewZip(ZipFileName: pchar) : integer; stdcall;
function zOrderFile(FileName, StoredName : pchar; UpdateMode : integer) : integer; stdcall;
function zCompressFiles(Password: pchar; CompressionMethod : integer;
  ResetArchiveAttribute : boolean; RTInfoFunc: pointer) : integer; stdcall;



var
  Form1: TForm1;
  zipfilename, tempdir : string;
  begtime, endtime : cardinal;
  reqfiles, reqbytes, lsr : integer;
  onlymove : boolean;
  ImgList : TImageList;
  ImgInd, FFDel : TStringList;
  ProcRep: TStringList;

implementation

uses ExtrOpt, About, PgsInd, Report, CmprOpt;

{$R *.DFM}


function zOpenZipFile;external  'tszd.dll' name 'zOpenZipFile';
function zCloseZipFile;external  'tszd.dll' name 'zCloseZipFile';
function zGetTotalFiles;external  'tszd.dll' name 'zGetTotalFiles';
function zGetTotalBytes;external  'tszd.dll' name 'zGetTotalBytes';
function zGetSelectedFiles;external  'tszd.dll' name 'zGetSelectedFiles';
function zGetSelectedBytes;external  'tszd.dll' name 'zGetSelectedBytes';
function zGetLastErrorAsText;external  'tszd.dll' name 'zGetLastErrorAsText';
function zGetSkipedFiles;external  'tszd.dll' name 'zGetSkipedFiles';
function zGetRunTimeInfo;external  'tszd.dll' name 'zGetRunTimeInfo';
function zCancelOperation;external  'tszd.dll' name 'zCancelOperation';

function zExtractOne;external  'tszd.dll' name 'zExtractOne';
function zExtractSelected;external  'tszd.dll' name 'zExtractSelected';
function zExtractAll;external  'tszd.dll' name 'zExtractAll';

function zGetFileName;external  'tszd.dll' name 'zGetFileName';
function zGetFileExt;external  'tszd.dll' name 'zGetFileExt';
function zGetFilePath;external  'tszd.dll' name 'zGetFilePath';
function zGetFileDate;external  'tszd.dll' name 'zGetFileDate';
function zGetFileTime;external  'tszd.dll' name 'zGetFileTime';
function zGetFileSize;external  'tszd.dll' name 'zGetFileSize';
function zGetCompressedFileSize;external  'tszd.dll' name 'zGetCompressedFileSize';
function zFileIsEncrypted;external  'tszd.dll' name 'zFileIsEncrypted';
function zGetLastOperResult;external  'tszd.dll' name 'zGetLastOperResult';

function zFileIsSelected;external  'tszd.dll' name 'zFileIsSelected';
function zSelectFile;external  'tszd.dll' name 'zSelectFile';

function zCreateNewZip;external  'tszd.dll' name 'zCreateNewZip';
function zOrderFile;external  'tszd.dll' name 'zOrderFile';
function zCompressFiles;external  'tszd.dll' name 'zCompressFiles';


function RightStr(v: integer) : string;
var
  s1,s2 : string;
  i,j,k : integer;
begin
  s2 := '                              ';
  k := 30;
  s1 := IntToStr(v);
  i := length(s1);
  j := 3;
  while i > 0 do
  begin
    if j = 0 then begin
      s2[k] := ',';
      j := 3;
      dec(k);
    end;
    s2[k] := s1[i];
    dec(i); dec(j); dec(k);
  end;
  Result := copy(s2,k+1,30);
end;



procedure TForm1.LoadGrid;
begin
  with DrawGrid1 do
  begin
    RowCount := zGetTotalFiles + 1;
    FixedRows := 1;
    TopRow := 1;
    RowHeights[0] := 20;
  end;
  lsr := -1;
  StatusBar1.Panels[0].Text := 'Total: ' + RightStr(zGetTotalFiles)+ ' files  -  '
    +RightStr(zGetTotalBytes)+ ' bytes';
  StatusBar1.Panels[1].Text := 'Selected: 0 files';
  sbExtract.Enabled := true;
  sbAdd.Enabled := true;
  sbRng.Enabled := true;
  sbAddFiles.Enabled := true;
end;

procedure TForm1.EmptyGrid;
begin
  DrawGrid1.FixedRows := 0;
  DrawGrid1.RowCount := 1;
  DrawGrid1.Refresh;
  StatusBar1.Panels[0].Text := 'Total: 0 files';
  StatusBar1.Panels[1].Text := 'Selected: 0 files';
  sbExtract.Enabled := false;
  sbAdd.Enabled := false;
  sbRng.Enabled := false;
  sbAddFiles.Enabled := false;
end;



procedure TForm1.FormCreate(Sender: TObject);
var
  i: integer;
  SysIL: uint;
  SFI: TSHFileInfo;
  ps : string;
  pc : array [0..255] of char;
begin
  with DrawGrid1 do
  begin
    DefaultRowHeight := 16;
    RowHeights[0] := 20;
    ColCount := GColMax+1;
    for i := 0 to GColMax do
      ColWidths[i] := GColWdt[i];
  end;
  EmptyGrid;

  GetTempPath(sizeof(pc),pc);
  tempdir := StrPas(pc);
  onlymove := false;
  ProcRep := TStringList.Create;
  ImgInd := TStringList.Create;
  FFDel := TStringList.Create;
  FFDel.Duplicates := dupIgnore;
  FFDel.Sorted := false;
  FFDel.Add(tempdir+'$$report.txt');

  ImgList := TImageList.Create(self);
  SysIL := SHGetFileInfo('', 0, SFI, SizeOf(SFI), SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  if SysIL <> 0 then begin
    ImgList.Handle := SysIL;
    ImgList.ShareImages := TRUE;  // DON'T FREE THE SYSTEM IMAGE LIST!!!!!  BAD IDEA (tm)!
  end;

  ps := ParamStr(1);
  if length(ps) > 0 then
  begin
    if zOpenZipFile(PChar(ps)) <> 0 then
      MessageDlg('ERROR! '+zGetLastErrorAsText,mtError,[mbOk],0)
    else
    begin
      EmptyGrid;
      LoadGrid;
    end;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  i : integer;
begin
  ImgList.Free;
  with FFDel do
  begin
    if count > 0 then
      for i := 0 to count - 1 do
        deletefile(strings[i]);
  end;
  FFDel.Free;
  ProcRep.Free;
  ImgInd.Free;
end;



procedure TForm1.sbOpenClick(Sender: TObject);
begin
  OpenZipDlg.InitialDir := ExtractFileDir(OpenZipDlg.FileName);
  if not OpenZipDlg.Execute then
    exit;
  zipfilename := OpenZipDlg.FileName;
  if zOpenZipFile(PChar(zipfilename)) <> 0 then
    MessageDlg('ERROR! '+zGetLastErrorAsText,mtError,[mbOk],0)
  else
  begin
    EmptyGrid;
    LoadGrid;
  end;
end;



function Date2Str(dd: word): string;
var
  w : word;
  s1,s2 : string;
begin
  s1 := '';
  w := (dd shr 5) and $f;
  if w < 10 then
    s1 := s1 + '0' + IntToStr(w) + '/'
  else
    s1 := s1 + IntToStr(w) + '/';

  w := dd and $1f;
  if w < 10 then
    s1 := s1 + '0' + IntToStr(w) + '/'
  else
    s1 := s1 + IntToStr(w) + '/';

  w := (dd shr 9) and $7f;
  s2 := IntToStr(1980+w);
  s1 := s1 + copy(s2,3,2);
  result := s1;
end;


function Time2Str(dd: word): string;
var
  w : word;
  s1 : string;
begin
  s1 := '';
  w := (dd shr 11) and $1f;
  if w < 10 then
    s1 := s1 + '0' + IntToStr(w) + ':'
  else
    s1 := s1 + IntToStr(w) + ':';

  w := (dd shr 5) and $3f;
  if w < 10 then
    s1 := s1 + '0' + IntToStr(w) + ':'
  else
    s1 := s1 + IntToStr(w) + ':';

  w := (dd and $1f) * 2;
  if w < 10 then
    s1 := s1 + '0' + IntToStr(w)
  else
    s1 := s1 + IntToStr(w);
  result := s1;
end;


procedure GetRowTxt(col,row : integer;var txt: string;
  var slc: boolean);
begin
  txt := '';
  slc := zFileIsSelected(row-1);
  case col of
      1 : begin
            txt := zGetFileName(row-1);
            if zFileIsEncrypted(row-1) then txt := txt + '+';
          end;
      2 : txt := Date2Str(zGetFileDate(row-1));
      3 : txt := Time2Str(zGetFileTime(row-1));
      4 : txt := RightStr(zGetFileSize(row-1));
      5 : if zGetFileSize(row-1) = 0 then txt := '0' else
            txt := IntToStr(round(zGetCompressedFileSize(row-1)*100/zGetFileSize(row-1)))+'%';
      6 : txt := RightStr(zGetCompressedFileSize(row-1));
      7 : txt := zGetFilePath(row-1);
  end;
end;


function GetIconIndex(row : integer): integer;
var
  SFI: TSHFileInfo;
  s : string;
begin
  if zGetFileName(row-1) = PChar('[FOLDER]') then
  begin
    s := ImgInd.Values['FOLDER'];
    if length(s) = 0 then
    begin
      SHGetFileInfo(zGetFileName(row-1), FILE_ATTRIBUTE_NORMAL or FILE_ATTRIBUTE_DIRECTORY, SFI,
        SizeOf(TSHFileInfo), SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES);
      ImgInd.Values['FOLDER'] := IntToStr(SFI.iIcon);
      Result := SFI.iIcon;
    end
    else
      Result := StrToInt(s);
  end
  else
  begin
    s := ImgInd.Values[zGetFileExt(row-1)];
    if length(s) = 0 then
    begin
      SHGetFileInfo(zGetFileName(row-1), FILE_ATTRIBUTE_NORMAL, SFI,
        SizeOf(TSHFileInfo), SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES);
      ImgInd.Values[zGetFileExt(row-1)] := IntToStr(SFI.iIcon);
      Result := SFI.iIcon;
    end
    else
      Result := StrToInt(s);
  end;
end;



procedure TForm1.DrawGrid1DrawCell(Sender: TObject; Col, Row: Integer;
  Rect: TRect; State: TGridDrawState);
var
  x : integer;
  txt : string;
  slc : boolean;
begin
  with DrawGrid1.Canvas do
  begin
    if row = 0 then
    begin
      Font := Self.Font;
      Brush := Self.Brush;
      Font.Style := [fsBold];
      Font.Color := clBlack;
      txt := GridHdr[Col];
      Pen.Color := clBlack;
      Pen.Style := psSolid;
      Rectangle(Rect.Left,Rect.Top,Rect.Right,Rect.Bottom);
      TextOut(Rect.Left+2,Rect.Top+1,txt);
    end
    else
    begin
      Font := Self.Font;
      Brush := Self.Brush;

      GetRowTxt(Col,Row,txt,slc);
      if slc then
      begin
        Brush.Color := clBlue;
        Font.Color := clHighLightText;
      end
      else
        Brush.Color := clWhite;
      FillRect(Rect);

      if col <> 0 then
      begin
        if GRightCol[Col] then
          x := Rect.Left + Rect.Right-Rect.Left-TextWidth(txt)-3
        else
          x := Rect.Left + 2;
        TextOut(x,Rect.Top,txt);
      end
      else
      begin
        x := GetIconIndex(row);
        ImgList.Draw(DrawGrid1.Canvas,Rect.Left,Rect.Top,x);
      end;

      if DrawGrid1.Selection.Top = row then
      begin
        Pen.Color := clBlue;
        MoveTo(Rect.Left,Rect.Top);
        LineTo(Rect.Right,Rect.Top);
        MoveTo(Rect.Left,Rect.Bottom-1);
        LineTo(Rect.Right,Rect.Bottom-1);
        if col = 0 then
        begin
          MoveTo(Rect.Left,Rect.Top);
          LineTo(Rect.Left,Rect.Bottom);
        end;
        if col = GColMax then
        begin
          MoveTo(Rect.Right-1,Rect.Top);
          LineTo(Rect.Right-1,Rect.Bottom);
        end;
      end;
    end;
  end;
end;



procedure TForm1.ExecFile;
var
  efn : string;
  r : integer;
begin
  if zGetTotalFiles < 1 then exit;
  efn := zGetFileName(DrawGrid1.row-1);
  if efn = '[FOLDER]' then begin
    ShowMessage('There is nothing to do with folder');
    exit;
  end;
  r := zExtractOne(DrawGrid1.row-1,PChar(tempdir),'',true,false,false,nil);
  if r <> 0 then
    MessageDlg('ERROR! '+zGetLastErrorAsText,mtError,[mbOk],0)
  else
  begin
    ShellExecute(0,nil,PChar(tempdir+efn),nil,nil,SW_SHOW);
    FFDel.Add(tempdir+efn);
  end;
end;


procedure TForm1.DrawGrid1DblClick(Sender: TObject);
begin
  ExecFile;
end;


procedure TForm1.InvDrwGrd;
var
  Rect: TRect;
begin
  with DrawGrid1 do
  begin
    Rect.TopLeft := CellRect(LeftCol,TopRow).TopLeft;
    Rect.BottomRight := ClientRect.BottomRight;
    InvalidateRect(Handle,@Rect,false);
  end;
end;




procedure TForm1.DrawGrid1SelectCell(Sender: TObject; Col, Row: Integer;
  var CanSelect: Boolean);
var
  i, i1, i2 : integer;
  rngsel : boolean;

begin
  canselect := true;
  if row < 1 then exit;

  if onlymove then
  begin
    onlymove := false;
    InvDrwGrd;
    exit;
  end;

  if (not sbAdd.Down) and (not sbRng.Down) then
  begin
    if (zGetSelectedFiles = 1) and (lsr <> row-1) then
      zSelectFile(lsr,not zFileIsSelected(lsr))
    else
      if zGetSelectedFiles > 1 then
        for i := 0 to zGetTotalFiles-1 do
          zSelectFile(i,false);
  end;

  if sbRng.Down and (zGetSelectedFiles > 0) then
  begin
    rngsel := not zFileIsSelected(row-1);
    if lsr < row-1 then begin
      i1 := lsr; i2 := row-1; end
    else begin
      i1 := row-1; i2 := lsr; end;

    for i := i1 to i2 do
      zSelectFile(i,rngsel);
  end
  else
    zSelectFile(row-1,not zFileIsSelected(row-1));

  lsr := row-1;
  StatusBar1.Panels[1].Text := 'Selected: ' + RightStr(zGetSelectedFiles)+ ' files  -  '
    +RightStr(zGetSelectedBytes)+ ' bytes';
  InvDrwGrd;
end;



procedure TForm1.DrawGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if DrawGrid1.rowcount < 2 then exit;
  case key of
    17: sbAdd.Down := true;
    16: sbRng.Down := true;
    32:   with DrawGrid1 do
          begin
            if col > leftcol then
              col := col - 1
            else
              col := col + 1;
          end;
    40:   with DrawGrid1 do
            if row < rowcount-1 then begin
              onlymove := true;
              row := row + 1;
            end;
    38:   with DrawGrid1 do
            if row > 1 then begin
              onlymove := true;
              row := row - 1;
            end;
    37:   with DrawGrid1 do
          begin
            if LeftCol = 0 then
              LeftCol := ColCount - 1
            else
              LeftCol := LeftCol - 1;
            onlymove := true;
            Col := LeftCol;
          end;
    39:   with DrawGrid1 do
          begin
            if LeftCol = ColCount - VisibleColCount then
              LeftCol := 0
            else
              LeftCol := LeftCol + 1;
            onlymove := true;
            Col := LeftCol;
          end;
    36:   with DrawGrid1 do
          begin
            onlymove := true;
            row := 1;
          end;
    35:   with DrawGrid1 do
          begin
            onlymove := true;
            row := rowcount-1;
          end;
    33:   with DrawGrid1 do
          begin
            onlymove := true;
            if row - VisibleRowCount < 1 then
              row := 1
            else
              row := row - VisibleRowCount;
          end;
    34:   with DrawGrid1 do
          begin
            onlymove := true;
            if row + VisibleRowCount > RowCount - 1 then
              row := RowCount - 1
            else
              row := row + VisibleRowCount;
          end;
    13:   ExecFile;
  end;
  key := 0;
end;

procedure TForm1.DrawGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case key of
    17: sbAdd.Down := false;
    16: sbRng.Down := false;
  end;
  key := 0;
end;



procedure ShowRTInfo;
var
  ii, pf, pb : integer;
  msg: TMsg;
begin
  zGetRunTimeInfo(pf,pb);
  if reqbytes > 0 then
    ii := round(pb / reqbytes * 100)
  else
    ii := 0;

  with FPgsInd do
  begin
      stprocfiles.Caption := RightStr(pf);
      stprocbytes.Caption := RightStr(pb);
      PgsBar.Position := ii;
      Update;
    end;
  if PeekMessage(msg,FPgsInd.PgsBtn.Handle,0,0,PM_REMOVE) then
  begin
    TranslateMessage(msg);
    DispatchMessage(msg);
  end;
end;



procedure TForm1.sbExtractClick(Sender: TObject);
var
  testonly, wantrep : boolean;
  msg,extrdir : string;
  r, i, mr, pf, pb : integer;
begin
  with FExtrOpt do
  begin
    if zGetSelectedFiles = 0 then
      rgFiles.ItemIndex := 0
    else
      rgFiles.ItemIndex := 1;

    mr := ShowModal;
    if mr = mrCancel then
    begin
      exit;
    end;
    if ddDir.Items.Strings[0] <> ddDir.Text then
      ddDir.Items.Insert(0,ddDir.Text);
    extrdir := ddDir.Text;
  end;

  if mr = mrYes then
  begin
    testonly := true;
    FPgsInd.Caption := 'Testing ' + zipfilename;
  end
  else
  begin
    testonly := false;
    FPgsInd.Caption := 'Extracting from ' + zipfilename;
    if length(extrdir) > 0 then
    begin
      if extrdir[length(extrdir)] <> '\' then
        extrdir := extrdir + '\';

      if not DirectoryExists(extrdir) then
      begin
        MessageDlg('ERROR! Directory '+ extrdir + ' does not exist!',
        mtError,[mbOk],0);
        exit;
      end;
    end;
  end;

  begtime := GetTickCount;
  if FExtrOpt.rgFiles.ItemIndex = 0 then
  begin
    reqbytes := zGetTotalBytes;
    FPgsInd.stselfiles.Caption := 'Selected files: ' + RightStr(zGetTotalFiles);
    FPgsInd.stselbytes.Caption := 'Selected bytes: ' + RightStr(reqbytes);
    FPgsInd.Show;
    r := zExtractAll(PChar(extrdir),PChar(FExtrOpt.edPswd.Text),FExtrOpt.cbOver.Checked,
      FExtrOpt.cbUse.Checked,testonly,addr(ShowRTInfo));
  end
  else
  begin
    reqbytes := zGetSelectedBytes;
    FPgsInd.stselfiles.Caption := 'Selected files: ' + RightStr(zGetSelectedFiles);
    FPgsInd.stselbytes.Caption := 'Selected bytes: ' + RightStr(reqbytes);
    FPgsInd.Show;
    r := zExtractSelected(PChar(extrdir),PChar(FExtrOpt.edPswd.Text),FExtrOpt.cbOver.Checked,
      FExtrOpt.cbUse.Checked,testonly,addr(ShowRTInfo));
  end;
  endtime := GetTickCount - begtime;
  FPgsInd.Hide;
  wantrep := false;
  if r <> 0 then
  begin
    if MessageDlg('ERROR! '+ zGetLastErrorAsText +
      #13' Would you like a report?',mtError,[mbYes,mbNo],0) = mrYes then
        wantrep := true;
  end
  else
  begin
    if zGetSkipedFiles = 0 then
      msg := 'All is Ok!  '
    else
      if zGetSkipedFiles = 1 then
        msg := 'There is a skiped file!   '
      else
        msg := 'There are ' + IntToStr(zGetSkipedFiles) + ' skiped files!  ';
    if MessageDlg(msg + '   Elapsed time ' + RightStr(endtime)+' ms'+
      #13' Would you like a report?',mtInformation,[mbYes,mbNo],0) = mrYes then
        wantrep := true;
  end;
  if wantrep then
  begin
    zGetRuntimeInfo(pf,pb);
    ProcRep.CLear;
    for i := 0 to pf-1 do
      ProcRep.Add(String(zGetLastOperResult(i)));

    ProcRep.Add('-----------------------------Total:');
    ProcRep.Add('Processed files: ' + RightStr(pf));
    ProcRep.Add('Processed bytes: ' + RightStr(pb));
    ProcRep.Add('Skiped files: ' + RightStr(zGetSkipedFiles));
    ProcRep.Add('Elapsed time: ' + RightStr(endtime)+' ms');

    ProcRep.SaveToFile(tempdir+'$$report.txt');
    FReport.RichEdit1.Lines.LoadFromFile(tempdir+'$$report.txt');
    FReport.ShowModal;
  end;
end;


procedure TForm1.sbHelpClick(Sender: TObject);
begin
  FAbout.ShowModal;
end;


procedure TForm1.sbCloseClick(Sender: TObject);
begin
  zCloseZipFile;
  EmptyGrid;
end;





function TForm1.Compress : boolean;
var
  rslt, um, i, nf, fh, pf, pb : integer;
  msg, fpn, fn : string;
  wantrep : boolean;
begin
  Result := false;
  EmptyGrid;

  dlgAddFiles.InitialDir := ExtractFileDir(dlgAddFiles.FileName);
  if not dlgAddFiles.Execute then
    exit;

  if FCmprOpt.ShowModal <> mrOk then
    exit;

  um := FCmprOpt.rgUpdMode.ItemIndex;
  with dlgAddFiles.Files do
  begin
    nf := Count-1;
    reqfiles := 0; reqbytes := 0;
    for i := 0 to nf do
    begin
      fpn := Strings[i];
      fn := ExtractFileName(fpn);
      if zOrderFile(PChar(fpn),PChar(fn),um) = 0 then
      begin
        inc(reqfiles);
        fh := createfile(PChar(fpn),0,FILE_SHARE_READ,
          nil,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,0);
        if fh > 0 then
        begin
          inc(reqbytes,GetFileSize(fh,nil));
          fileclose(fh);
        end;
      end;
    end;
    if reqfiles = 0 then
    begin
      ShowMessage('Nothing to do!');
      Result := true;
      exit;
    end;


    FPgsInd.Caption := 'Compressing to ' + zipfilename;
    FPgsInd.stselfiles.Caption := 'Selected files: ' + RightStr(reqfiles);
    FPgsInd.stselbytes.Caption := 'Selected bytes: ' + RightStr(reqbytes);
    FPgsInd.Show;
    begtime := GetTickCount;
    rslt := zCompressFiles(PChar(FCmprOpt.edPswd.Text),FCmprOpt.rgCmprMthd.ItemIndex,FCmprOpt.cbRAA.Checked,addr(ShowRTInfo));
    endtime := GetTickCount - begtime;
    FPgsInd.Hide;
    if rslt <> 0 then
    begin
      MessageDlg('ERROR! '+zGetLastErrorAsText,mtError,[mbOk],0);
      exit;
    end;
    if zGetSkipedFiles = 0 then
      msg := 'All is Ok!  '
    else
      if zGetSkipedFiles = 1 then
        msg := 'There is a skipped file!   '
      else
        msg := 'There are ' + IntToStr(zGetSkipedFiles) + ' skipped files!  ';
    wantrep := false;
    if MessageDlg(msg + '   Elapsed time ' + RightStr(endtime)+' ms'+
      #13' Would you like a report?',mtInformation,[mbYes,mbNo],0) = mrYes then
        wantrep := true;
    if wantrep then
    begin
      zGetRuntimeInfo(pf,pb);
      ProcRep.CLear;
      for i := 0 to pf-1 do
        ProcRep.Add(String(zGetLastOperResult(i)));

      ProcRep.Add('-----------------------------Total:');
      ProcRep.Add('Processed files: ' + RightStr(pf));
      ProcRep.Add('Processed bytes: ' + RightStr(pb));
      ProcRep.Add('Skiped files: ' + RightStr(zGetSkipedFiles));
      ProcRep.Add('Elapsed time: ' + RightStr(endtime)+' ms');

      ProcRep.SaveToFile(tempdir+'$$report.txt');
      FReport.RichEdit1.Lines.LoadFromFile(tempdir+'$$report.txt');
      FReport.ShowModal;
    end;
  end;
  Result := true;
end;




procedure TForm1.sbAddFilesClick(Sender: TObject);
begin
  if Compress then
  begin
    LoadGrid;
  end;
end;

procedure TForm1.sbNewClick(Sender: TObject);
begin
  if not dlgSaveZip.Execute then
    exit;

  zipfilename := dlgSaveZip.FileName;
  if zCreateNewZip(PChar(zipfilename)) <> 0 then
    MessageDlg('ERROR! '+zGetLastErrorAsText,mtError,[mbOk],0)
  else
  begin
    if Compress then
    begin
      LoadGrid;
    end;
  end;
end;

end.
