#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DBrs.h : header file
//

#include "Resource.h"

/////////////////////////////////////////////////////////////////////////////
// CDBrs DAO recordset

extern CDaoDatabase * pMainDatabase;
extern UINT	m_PrivateFormId;
extern CString	GetString( COleVariant& var );
extern long GetLong( COleVariant& var );

void __declspec(dllexport)  SetMainDatabase( CDaoDatabase * pDB );
void __declspec(dllexport)  OpenForm( CRuntimeClass* prt, CString Title );

//void SetMainDatabase( CDaoDatabase * pDB );

class AFX_EXT_CLASS CDBrs : public CDaoRecordset
{
private:
	CPtrArray	m_Fields;

public:
	CDBrs(CDaoDatabase* pDatabase = NULL);
	~CDBrs();
	DECLARE_DYNAMIC(CDBrs)

// Field/Param Data
	//{{AFX_FIELD(CDBrs, CDaoRecordset)
	//}}AFX_FIELD
	void	SetFieldString( CString FieldName, CString str );

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDBrs)
	public:
	virtual void DoFieldExchange(CDaoFieldExchange* pFX);  // RFX support
	virtual void Open(int nOpenType = AFX_DAO_USE_DEFAULT_TYPE, LPCTSTR lpszSql = NULL, int nOptions = 0);
	//}}AFX_VIRTUAL

// Implementation
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};

// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
class AFX_EXT_CLASS CDBChildFrame : public CMDIChildWnd
{
	DECLARE_DYNCREATE(CDBChildFrame)
public:
	CDBChildFrame();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDBChildFrame)
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDBChildFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CToolBar    m_wndToolBar;

	// Generated message map functions
protected:
	//{{AFX_MSG(CDBChildFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

enum ty_ed_ctrl{	ty_edit,	ty_cbo,		ty_check,	ty_list,	ty_grid};

#define	FLAG_EDIT_R_ONLY	0
#define	FLAG_EDIT			1

class AFX_EXT_CLASS CDBForm : public CFormView
{
protected:
	CDBForm( UINT i);           // protected constructor used by dynamic creation
	CDBForm( void );           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CDBForm)

// Form Data
public:
	//{{AFX_DATA(CDBForm)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA
private:

	CUIntArray	m_updCtrls;
	CUIntArray	m_tyCtrls;
	CUIntArray	m_FlagCtrls;
	CStringArray m_Fileds;
	CPtrArray	m_RecSet;
	BOOL		m_Editing;
	BOOL		m_Bof;
	BOOL		m_Eof;


// Attributes
public:

// Operations
public:
	virtual void EnableEditing( BOOL E);
	virtual void ClearData( void );
	virtual void ReadData( void );
	virtual void WriteData();
	virtual BOOL Editing( void );
	virtual void UpdateStatus( void );
	virtual void AddEditCtrl( UINT Id, CString field, UINT flags = FLAG_EDIT );
	virtual void AddComboCtrl( UINT Id, CString field, UINT flags = FLAG_EDIT );
	virtual void AddCheckCtrl( UINT Id, CString field, UINT flags = FLAG_EDIT );
	virtual void AddListCtrl( UINT Id, CString field, int nCur, CString Filter, UINT flags = FLAG_EDIT );
	virtual void AddListCol( UINT Id, CString field, int width, UINT flags = FLAG_EDIT );
	virtual void AddListColCbo( UINT Id, CString field, int width, int nCur, UINT flags = FLAG_EDIT );
	virtual void FillCombo( UINT Id, int nCur);
	virtual void PrintPreview( CString s);

	// Cursor management
	virtual int	OpenCursor( CString s, char * Filter = NULL, char * Sort = NULL, int mode = dbOpenDynaset, int opt = 0);
	virtual CDBrs * Cursor( int i = 0 );
	virtual int NCursor( void );

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDBForm)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CDBForm();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CDBForm)
	afx_msg void OnAddRec();
	afx_msg void OnUpdateAddRec(CCmdUI* pCmdUI);
	afx_msg void OnDelRec();
	afx_msg void OnUpdateDelRec(CCmdUI* pCmdUI);
	afx_msg void OnEditRec();
	afx_msg void OnUpdateEditRec(CCmdUI* pCmdUI);
	afx_msg void OnSave();
	afx_msg void OnUpdateSave(CCmdUI* pCmdUI);
	afx_msg void OnUndo();
	afx_msg void OnUpdateUndo(CCmdUI* pCmdUI);
	afx_msg void OnRecordFirst();
	afx_msg void OnUpdateRecordFirst(CCmdUI* pCmdUI);
	afx_msg void OnRecordLast();
	afx_msg void OnUpdateRecordLast(CCmdUI* pCmdUI);
	afx_msg void OnRecordNext();
	afx_msg void OnUpdateRecordNext(CCmdUI* pCmdUI);
	afx_msg void OnRecordPrev();
	afx_msg void OnUpdateRecordPrev(CCmdUI* pCmdUI);
	afx_msg void OnFileClose();
	afx_msg void OnUpdateFileClose(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CDBEdit window

class CDBEdit : public CEdit
{
// Construction
public:
	CDBEdit();

// Attributes
public:

// Operations
public:


private:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDBEdit)
	protected:
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDBEdit();

	// Generated message map functions
protected:
	//{{AFX_MSG(CDBEdit)
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg UINT OnGetDlgCode();
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CDBGrid window
#define NOT_EDIT	-1

class AFX_EXT_CLASS CDBGrid : public CListCtrl
{
	DECLARE_DYNAMIC( CDBGrid )

private:
	CDBrs *		m_pCursor;
	COleVariant	m_Par;
	CStringArray m_FieldNames;
	CUIntArray	m_Width;
	CUIntArray	m_Flags;
	CUIntArray	m_CursorSec;
	CUIntArray	m_tyCtrls;
	int			m_X;
	int			m_Y;
	BOOL		m_CtrlPressed;

	// Construction
public:
	CDBGrid();

// Attributes
public:
	CString		m_Filter;
	CString		m_Param;

// Operations
public:
	void	AddRecord( void );
	void	SetCursor( CDBrs * cur);
	int		NFields( void );
	void	Edit( void );
	void	Move( int x, int y);
	void	SaveEditData( void );
	void	BeginEdit( void );
	void	EndEdit( void );
	void	WriteData( void );
	CRect	Rect( int x, int y);
	virtual CDBrs * Cursor( int i = -1 );
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDBGrid)
	protected:
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	void	SetParam( COleVariant p );
	void	Refresh();
	void	AddCol( CString field, int width, UINT flags = FLAG_EDIT );
	void	AddColCbo( CString field, int width, int nCur, UINT flags = FLAG_EDIT );
	virtual ~CDBGrid();

	afx_msg void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct);
	// Generated message map functions
protected:
	//{{AFX_MSG(CDBGrid)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDBCombo window

class CDBCombo : public CComboBox
{
// Construction
public:
	CDBCombo();

// Attributes
public:

// Operations
public:
private:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDBCombo)
	protected:
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
public:
	void LocateOnValue( CString v);
	virtual ~CDBCombo();
	void	FillCombo( CDBrs * rs);

	// Generated message map functions
protected:
	//{{AFX_MSG(CDBCombo)
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
